/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.actions.SyncActionKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"3\u0015\u0001Q!\u0001E\t\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0011!B\u0001\u0005\u0005\u0015\t\u0001bB\u0003\u0002\t\u0005ia\u0004\u0003\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0003IB\u0001c\u0001\u000e\u00051\u0005\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\u0019AI!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u0006#\u000e\t\u0001B\u0002+\u0004\u000e5\u0019\u0002bB\u0007\u00021\u0017IB\u0001c\u0004\u000e\u00051\u0005\u0001\u0004C\r\u0007\u0011#iA!\u0003\u0002\n\u0003a\t\u0001\u0014A)\u0004\u0003!IAk!\u0004"}, strings={"createMergeActions", "", "Ljavax/swing/Action;", "project", "Lcom/intellij/openapi/project/Project;", "urlTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "dialogParent", "Ljava/awt/Container;", "okAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;Ljava/awt/Container;Lkotlin/jvm/functions/Function0;)[Ljavax/swing/Action;", "UpstreamEditorKt", "updateSyncButtonState", "url", "", "syncActions", "(Ljava/lang/String;[Ljavax/swing/Action;)V"}, moduleName="settings-repository")
public final class UpstreamEditorKt {
    public static final void updateSyncButtonState(@Nullable String url, @NotNull Action[] syncActions) {
        Intrinsics.checkParameterIsNotNull((Object)syncActions, (String)"syncActions");
        try {
            boolean enabled = url != null && CollectionsKt.length((CharSequence)url) > 1 && IcsManagerKt.getIcsManager().getRepositoryService().checkUrl(url, null);
        }
        finally {
            int n = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Action[] createMergeActions(@Nullable Project project, @NotNull TextFieldWithBrowseButton urlTextField, @NotNull Container dialogParent, @NotNull Function0<? extends Unit> okAction) {
        void size;
        void syncTypes;
        Intrinsics.checkParameterIsNotNull((Object)urlTextField, (String)"urlTextField");
        Intrinsics.checkParameterIsNotNull((Object)dialogParent, (String)"dialogParent");
        Intrinsics.checkParameterIsNotNull(okAction, (String)"okAction");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SyncType.values();
        if (SystemInfo.isMac) {
            Object[] objectArray = ArrayUtil.reverseArray((Object[])((Object[])((SyncType[])syncTypes.element)));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.reverseArray(syncTypes)");
            syncTypes.element = (SyncType[])objectArray;
        }
        IcsManager icsManager2 = IcsManagerKt.getIcsManager();
        int n = 3;
        Action[] result = new Action[size];
        boolean bl = false;
        void var9_9 = size - true;
        if (bl <= var9_9) {
            void i;
            do {
                void it;
                void var10_10 = ++i;
                void var15_13 = i;
                Action[] actionArray = result;
                SyncType syncType = ((SyncType[])syncTypes.element)[it];
                AbstractAction abstractAction = new AbstractAction(syncType, IcsBundleKt.icsMessage("action." + (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.MERGE)) ? "Merge" : (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? "ResetToTheirs" : "ResetToMy")) + "Settings.text", new Object[0]), (Ref.ObjectRef)syncTypes, urlTextField, icsManager2, dialogParent, project, okAction){
                    final /* synthetic */ SyncType $syncType;
                    final /* synthetic */ Ref.ObjectRef $syncTypes$inlined;
                    final /* synthetic */ TextFieldWithBrowseButton $urlTextField$inlined;
                    final /* synthetic */ IcsManager $icsManager$inlined;
                    final /* synthetic */ Container $dialogParent$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Function0 $okAction$inlined;

                    private final boolean saveRemoteRepositoryUrl() {
                        String url = StringUtil.nullize((String)this.$urlTextField$inlined.getText());
                        if (url != null && !this.$icsManager$inlined.getRepositoryService().checkUrl(url, this.$dialogParent$inlined)) {
                            return false;
                        }
                        RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                        repositoryManager.createRepositoryIfNeed();
                        repositoryManager.setUpstream(url, null);
                        return true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void actionPerformed(ActionEvent event) {
                        boolean repositoryWillBeCreated = !this.$icsManager$inlined.getRepositoryManager().isRepositoryExists();
                        boolean upstreamSet = false;
                        try {
                            if (!this.saveRemoteRepositoryUrl()) {
                                if (repositoryWillBeCreated) {
                                    this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                                }
                                return;
                            }
                            upstreamSet = true;
                            if (repositoryWillBeCreated && Intrinsics.areEqual((Object)((Object)this.$syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ^ true) {
                                ApplicationManager.getApplication().saveSettings();
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<? extends Unit>)((Function0)createMergeActions.1.actionPerformed.1.INSTANCE));
                            } else {
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<? extends Unit>)((Function0)null));
                            }
                        }
                        catch (Throwable e) {
                            if (repositoryWillBeCreated) {
                                this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                            }
                            IcsManagerKt.getLOG().warn(e);
                            if (!upstreamSet || e instanceof NoRemoteRepositoryException) {
                                void $receiver;
                                Object[] objectArray;
                                Throwable throwable = e;
                                int n = 0;
                                Object[] objectArray2 = objectArray = new Object[1];
                                String string = "set.upstream.failed.message";
                                Component component = this.$dialogParent$inlined;
                                String string2 = $receiver.getMessage();
                                objectArray[n] = string2;
                                Messages.showErrorDialog((Component)component, (String)IcsBundleKt.icsMessage(string, objectArray2), (String)IcsBundleKt.icsMessage("set.upstream.failed.title", new Object[0]));
                            } else {
                                Throwable $receiver = e;
                                Component component = this.$dialogParent$inlined;
                                String string = $receiver.getMessage();
                                Messages.showErrorDialog((Component)component, (String)StringUtil.notNullize((String)string, (String)"Internal error"), (String)IcsBundleKt.icsMessage(e instanceof AuthenticationException ? "sync.not.authorized.title" : "sync.rejected.title", new Object[0]));
                            }
                            return;
                        }
                        SyncActionKt.getNOTIFICATION_GROUP().createNotification(IcsBundleKt.icsMessage("sync.done.message", new Object[0]), NotificationType.INFORMATION).notify(this.$project$inlined);
                        this.$okAction$inlined.invoke();
                    }
                    {
                        void $super_call_param$2;
                        this.$syncType = syncType;
                        this.$syncTypes$inlined = objectRef;
                        this.$urlTextField$inlined = textFieldWithBrowseButton;
                        this.$icsManager$inlined = icsManager2;
                        this.$dialogParent$inlined = container;
                        this.$project$inlined = project;
                        this.$okAction$inlined = function0;
                        super((String)$super_call_param$2);
                    }
                };
                actionArray[var15_13] = abstractAction;
            } while (i != var9_9);
        }
        return (Action[])((Object[])result);
    }
}

