/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import kotlin.StringsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.settingsRepository.IcsManagerKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u000e\u001c!\rQB\u0001G\u00011\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB\u0001V\u0002\u0002##!\u0011\t\b\u0005\u0001\u001b\u0005A\n!U\u0002\u0002\u000b\u0001!6!\u0001"}, strings={"canUseGitExe", "", "GitCredentialKt", "getCredentialsUsingGit", "Lorg/jetbrains/keychain/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;"}, moduleName="settings-repository")
public final class GitCredentialKt {
    private static boolean canUseGitExe = true;

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository2) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        if (!canUseGitExe || repository2.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"git", "credential", "fill"});
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"commandLine.createProcess()");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStreamWriter writer = ByteStreamsKt.writer$default((OutputStream)process.getOutputStream(), null, (int)1);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        BufferedReader reader = TextStreamsKt.buffered$default((Reader)ByteStreamsKt.reader$default((InputStream)process.getInputStream(), null, (int)1), (int)0, (int)1);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string = reader.readLine();
            String string2 = line = string != null ? StringsKt.trim((String)string) : null;
            if (line == null || StringsKt.isEmpty((String)line)) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    return StringsKt.trim((String)StringsKt.substring((String)this.$line, (int)(StringsKt.indexOf$default((String)this.$line, (char)'=', (int)0, (boolean)false, (int)6) + 1)));
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2)) {
                username = readValue$.invoke();
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        String errorText = TextStreamsKt.readText((Reader)ByteStreamsKt.reader$default((InputStream)process.getErrorStream(), null, (int)1));
        if (!StringUtil.isEmpty((String)errorText)) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? (Credentials)null : new Credentials((String)username, (String)password);
    }
}

