/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.util;

import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream
extends OutputStream {
    private final OutputStream os;
    private long count = 0L;

    public DebugOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.count += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public long count() {
        return this.count;
    }
}

