/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.sdklib.devices.Storage;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeUIUtils {
    private WelcomeUIUtils() {
    }

    public static void makeButtonAHyperlink(@NotNull JButton button, final @NotNull String url) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/welcome/wizard/WelcomeUIUtils", "makeButtonAHyperlink"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/welcome/wizard/WelcomeUIUtils", "makeButtonAHyperlink"));
        }
        WelcomeUIUtils.makeButtonAHyperlink(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)url);
            }
        });
    }

    private static void makeButtonAHyperlink(JButton button) {
        button.setBorderPainted(false);
        button.setBorder(null);
        button.setForeground((Color)JBColor.blue);
        button.setOpaque(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        Font font = button.getFont();
        if (font == null) {
            font = UIUtil.getButtonFont();
        }
        Font underlinedFont = font.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_LOW_ONE_PIXEL));
        button.setFont(underlinedFont);
    }

    public static String getSizeLabel(long size) {
        Storage.Unit[] values = Storage.Unit.values();
        Storage.Unit unit = values[values.length - 1];
        for (int i = values.length - 2; unit.getNumberOfBytes() > size && i >= 0; --i) {
            unit = values[i];
        }
        double space = (double)size * 1.0 / (double)unit.getNumberOfBytes();
        String formatted = WelcomeUIUtils.roundToNumberOfDigits(space, 3);
        return String.format("%s %s", formatted, unit.getDisplayValue());
    }

    private static String roundToNumberOfDigits(double number, int maxDigits) {
        int digits;
        int multiplier = 1;
        for (digits = maxDigits; digits > 0 && number > (double)multiplier; --digits) {
            multiplier *= 10;
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setGroupingUsed(false);
        numberInstance.setRoundingMode(RoundingMode.HALF_UP);
        numberInstance.setMaximumFractionDigits(digits);
        return numberInstance.format(number);
    }

    public static String getMessageWithDetails(@NotNull String message, @Nullable String details) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/welcome/wizard/WelcomeUIUtils", "getMessageWithDetails"));
        }
        if (StringUtil.isEmptyOrSpaces((String)details)) {
            return message + ".";
        }
        String dotIfNeeded = details.trim().endsWith(".") ? "" : ".";
        return message + ": " + details + dotIfNeeded;
    }
}

