/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontDescriptionPanel
extends JPanel {
    private JPanel myPanel;
    private ColorPanel myBackgroundChooser;
    private ColorPanel myForegroundChooser;
    private ColorPanel myEffectsColorChooser;
    private ColorPanel myErrorStripeColorChooser;
    private JBCheckBox myCbBackground;
    private JBCheckBox myCbForeground;
    private JBCheckBox myCbEffects;
    private JBCheckBox myCbErrorStripe;
    private Map<String, EffectType> myEffectsMap;
    private JComboBox myEffectsCombo;
    private final EffectsComboModel myEffectsModel;
    private JBCheckBox myCbBold;
    private JBCheckBox myCbItalic;
    private JLabel myLabelFont;
    private JTextPane myInheritanceLabel;
    private JBCheckBox myInheritAttributesBox;

    public ColorAndFontDescriptionPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        map.put(ApplicationBundle.message((String)"combobox.effect.underscored", (Object[])new Object[0]), EffectType.LINE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.boldunderscored", (Object[])new Object[0]), EffectType.BOLD_LINE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.underwaved", (Object[])new Object[0]), EffectType.WAVE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.bordered", (Object[])new Object[0]), EffectType.BOXED);
        map.put(ApplicationBundle.message((String)"combobox.effect.strikeout", (Object[])new Object[0]), EffectType.STRIKEOUT);
        map.put(ApplicationBundle.message((String)"combobox.effect.bold.dottedline", (Object[])new Object[0]), EffectType.BOLD_DOTTED_LINE);
        this.myEffectsMap = Collections.unmodifiableMap(map);
        this.add((Component)this.myPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        this.myEffectsModel = new EffectsComboModel(ContainerUtil.newArrayList(this.myEffectsMap.keySet()));
        this.myEffectsCombo.setModel(this.myEffectsModel);
        this.myEffectsCombo.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value : "<invalid>");
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorAndFontDescriptionPanel.this.onSettingsChanged(e);
            }
        };
        for (JBCheckBox jBCheckBox : new JBCheckBox[]{this.myCbBackground, this.myCbForeground, this.myCbEffects, this.myCbErrorStripe, this.myCbItalic, this.myCbBold, this.myInheritAttributesBox}) {
            jBCheckBox.addActionListener(actionListener);
        }
        for (JBCheckBox jBCheckBox : new ColorPanel[]{this.myBackgroundChooser, this.myForegroundChooser, this.myEffectsColorChooser, this.myErrorStripeColorChooser}) {
            jBCheckBox.addActionListener(actionListener);
        }
        this.myEffectsCombo.addActionListener(actionListener);
        Messages.configureMessagePaneUi((JTextPane)this.myInheritanceLabel, (String)"<html>", (boolean)false);
        this.myInheritanceLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                ColorAndFontDescriptionPanel.this.onHyperLinkClicked(e);
            }
        });
        this.myInheritanceLabel.setBorder(BorderFactory.createEmptyBorder());
        this.myLabelFont.setVisible(false);
    }

    protected void onHyperLinkClicked(HyperlinkEvent e) {
    }

    protected void onSettingsChanged(ActionEvent e) {
        this.myErrorStripeColorChooser.setEnabled(this.myCbErrorStripe.isSelected());
        this.myForegroundChooser.setEnabled(this.myCbForeground.isSelected());
        this.myBackgroundChooser.setEnabled(this.myCbBackground.isSelected());
        this.myEffectsColorChooser.setEnabled(this.myCbEffects.isSelected());
        this.myEffectsCombo.setEnabled(this.myCbEffects.isSelected());
    }

    public void resetDefault() {
        this.myLabelFont.setEnabled(false);
        this.myCbBold.setSelected(false);
        this.myCbBold.setEnabled(false);
        this.myCbItalic.setSelected(false);
        this.myCbItalic.setEnabled(false);
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbForeground, this.myForegroundChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbBackground, this.myBackgroundChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbErrorStripe, this.myErrorStripeColorChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbEffects, this.myEffectsColorChooser, false, false, null);
        this.myEffectsCombo.setEnabled(false);
        this.myInheritanceLabel.setVisible(false);
        this.myInheritAttributesBox.setVisible(false);
    }

    private static void updateColorChooser(JCheckBox checkBox, ColorPanel colorPanel, boolean isEnabled, boolean isChecked, @Nullable Color color) {
        checkBox.setEnabled(isEnabled);
        checkBox.setSelected(isChecked);
        if (color != null) {
            colorPanel.setSelectedColor(color);
        } else {
            colorPanel.setSelectedColor((Color)JBColor.WHITE);
        }
        colorPanel.setEnabled(isChecked);
    }

    public void reset(ColorAndFontDescription description) {
        if (description.isFontEnabled()) {
            this.myLabelFont.setEnabled(true);
            this.myCbBold.setEnabled(true);
            this.myCbItalic.setEnabled(true);
            int fontType = description.getFontType();
            this.myCbBold.setSelected((fontType & 1) != 0);
            this.myCbItalic.setSelected((fontType & 2) != 0);
        } else {
            this.myLabelFont.setEnabled(false);
            this.myCbBold.setSelected(false);
            this.myCbBold.setEnabled(false);
            this.myCbItalic.setSelected(false);
            this.myCbItalic.setEnabled(false);
        }
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbForeground, this.myForegroundChooser, description.isForegroundEnabled(), description.isForegroundChecked(), description.getForegroundColor());
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbBackground, this.myBackgroundChooser, description.isBackgroundEnabled(), description.isBackgroundChecked(), description.getBackgroundColor());
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbErrorStripe, this.myErrorStripeColorChooser, description.isErrorStripeEnabled(), description.isErrorStripeChecked(), description.getErrorStripeColor());
        EffectType effectType = description.getEffectType();
        ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbEffects, this.myEffectsColorChooser, description.isEffectsColorEnabled(), description.isEffectsColorChecked(), description.getEffectColor());
        if (description.isEffectsColorEnabled() && description.isEffectsColorChecked()) {
            this.myEffectsCombo.setEnabled(true);
            this.myEffectsModel.setEffectName((String)ContainerUtil.reverseMap(this.myEffectsMap).get(effectType));
        } else {
            this.myEffectsCombo.setEnabled(false);
        }
        this.setInheritanceInfo(description);
        this.myLabelFont.setEnabled(this.myCbBold.isEnabled() || this.myCbItalic.isEnabled());
    }

    private void setInheritanceInfo(ColorAndFontDescription description) {
        Pair<ColorSettingsPage, AttributesDescriptor> baseDescriptor = description.getBaseAttributeDescriptor();
        if (baseDescriptor != null && ((AttributesDescriptor)baseDescriptor.second).getDisplayName() != null) {
            String labelText;
            String tooltipText;
            String attrName = ((AttributesDescriptor)baseDescriptor.second).getDisplayName();
            String attrLabel = attrName.replaceAll("//", FontUtil.rightArrow((Font)UIUtil.getLabelFont()));
            ColorSettingsPage settingsPage = (ColorSettingsPage)baseDescriptor.first;
            String style = "<div style=\"text-align:right\" vertical-align=\"top\">";
            if (settingsPage != null) {
                String pageName = settingsPage.getDisplayName();
                tooltipText = "'" + attrLabel + "' from<br>'" + pageName + "' section";
                labelText = style + "'" + attrLabel + "'<br>of <a href=\"" + attrName + "\">" + pageName;
            } else {
                tooltipText = attrLabel;
                labelText = style + attrLabel + "<br>&nbsp;";
            }
            this.myInheritanceLabel.setVisible(true);
            this.myInheritanceLabel.setText(labelText);
            this.myInheritanceLabel.setToolTipText(tooltipText);
            this.myInheritanceLabel.setEnabled(true);
            this.myInheritAttributesBox.setVisible(true);
            this.myInheritAttributesBox.setEnabled(true);
            this.myInheritAttributesBox.setSelected(description.isInherited());
            this.setEditEnabled(!description.isInherited(), description);
        } else {
            this.myInheritanceLabel.setVisible(false);
            this.myInheritAttributesBox.setSelected(false);
            this.myInheritAttributesBox.setVisible(false);
            this.setEditEnabled(true, description);
        }
    }

    private void setEditEnabled(boolean isEditEnabled, ColorAndFontDescription description) {
        this.myCbBackground.setEnabled(isEditEnabled && description.isBackgroundEnabled());
        this.myCbForeground.setEnabled(isEditEnabled && description.isForegroundEnabled());
        this.myCbBold.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbItalic.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbEffects.setEnabled(isEditEnabled && description.isEffectsColorEnabled());
        this.myCbErrorStripe.setEnabled(isEditEnabled && description.isErrorStripeEnabled());
        this.myErrorStripeColorChooser.setEditable(isEditEnabled);
        this.myEffectsColorChooser.setEditable(isEditEnabled);
        this.myForegroundChooser.setEditable(isEditEnabled);
        this.myBackgroundChooser.setEditable(isEditEnabled);
    }

    public void apply(ColorAndFontDescription description, EditorColorsScheme scheme) {
        if (description != null) {
            description.setInherited(this.myInheritAttributesBox.isSelected());
            if (description.isInherited()) {
                TextAttributes baseAttributes = description.getBaseAttributes();
                if (baseAttributes != null) {
                    description.setFontType(baseAttributes.getFontType());
                    description.setForegroundChecked(baseAttributes.getForegroundColor() != null);
                    description.setForegroundColor(baseAttributes.getForegroundColor());
                    description.setBackgroundChecked(baseAttributes.getBackgroundColor() != null);
                    description.setBackgroundColor(baseAttributes.getBackgroundColor());
                    description.setErrorStripeChecked(baseAttributes.getErrorStripeColor() != null);
                    description.setErrorStripeColor(baseAttributes.getErrorStripeColor());
                    description.setEffectColor(baseAttributes.getEffectColor());
                    description.setEffectType(baseAttributes.getEffectType());
                    description.setEffectsColorChecked(baseAttributes.getEffectColor() != null);
                } else {
                    description.setInherited(false);
                }
                this.reset(description);
            } else {
                this.setInheritanceInfo(description);
                int fontType = 0;
                if (this.myCbBold.isSelected()) {
                    fontType |= 1;
                }
                if (this.myCbItalic.isSelected()) {
                    fontType |= 2;
                }
                description.setFontType(fontType);
                description.setForegroundChecked(this.myCbForeground.isSelected());
                description.setForegroundColor(this.myForegroundChooser.getSelectedColor());
                description.setBackgroundChecked(this.myCbBackground.isSelected());
                description.setBackgroundColor(this.myBackgroundChooser.getSelectedColor());
                description.setErrorStripeChecked(this.myCbErrorStripe.isSelected());
                description.setErrorStripeColor(this.myErrorStripeColorChooser.getSelectedColor());
                description.setEffectsColorChecked(this.myCbEffects.isSelected());
                description.setEffectColor(this.myEffectsColorChooser.getSelectedColor());
                if (this.myEffectsCombo.isEnabled()) {
                    String effectType = (String)this.myEffectsCombo.getModel().getSelectedItem();
                    description.setEffectType(this.myEffectsMap.get(effectType));
                }
            }
            description.apply(scheme);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JTextPane jTextPane;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        ColorPanel colorPanel4;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 10, 10, 10), -1, -1, false, false));
        this.myCbForeground = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.foreground"));
        jPanel.add((Component)jBCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbBackground = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.background"));
        jPanel.add((Component)jBCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbErrorStripe = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.error.stripe.mark"));
        jPanel.add((Component)jBCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbEffects = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.effects"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundChooser = colorPanel4 = new ColorPanel();
        jPanel.add((Component)colorPanel4, new GridConstraints(1, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myBackgroundChooser = colorPanel3 = new ColorPanel();
        jPanel.add((Component)colorPanel3, new GridConstraints(2, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myErrorStripeColorChooser = colorPanel2 = new ColorPanel();
        jPanel.add((Component)colorPanel2, new GridConstraints(3, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myEffectsColorChooser = colorPanel = new ColorPanel();
        jPanel.add((Component)colorPanel, new GridConstraints(4, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(30, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 3, 2, 0, 3, 0, 0, null, null, null, 0, true));
        this.myInheritanceLabel = jTextPane = new JTextPane();
        jTextPane.setText("labl");
        jPanel2.add((Component)jTextPane, new GridConstraints(1, 0, 2, 2, 0, 3, 0, 0, null, null, null));
        this.myInheritAttributesBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.inherit.attributes"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 4, 2, 0, 0, null, null, null));
        this.myCbBold = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.font.bold"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCbItalic = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.font.italic"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myLabelFont = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.font.type"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = new ComboBox();
        this.myEffectsCombo = comboBox;
        jPanel.add((Component)comboBox, new GridConstraints(5, 0, 1, 2, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class EffectsComboModel
    extends CollectionComboBoxModel<String> {
        public EffectsComboModel(List<String> names) {
            super(names);
        }

        public void setEffectName(@NotNull String effectName) {
            if (effectName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectName", "com/intellij/application/options/colors/ColorAndFontDescriptionPanel$EffectsComboModel", "setEffectName"));
            }
            this.mySelection = effectName;
        }
    }
}

