/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadableExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    @Nullable
    private Set<VirtualFile> myAnnotationsRoots = null;

    public ReadableExternalAnnotationsManager(PsiManager psiManager) {
        super(psiManager);
    }

    @Override
    protected boolean hasAnyAnnotationsRoots() {
        return !this.initRoots().isEmpty();
    }

    @NotNull
    private synchronized Set<VirtualFile> initRoots() {
        if (this.myAnnotationsRoots == null) {
            Module[] modules;
            this.myAnnotationsRoots = new HashSet<VirtualFile>();
            for (Module module : modules = ModuleManager.getInstance((Project)this.myPsiManager.getProject()).getModules()) {
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    VirtualFile[] files = AnnotationOrderRootType.getFiles(entry);
                    if (files.length <= 0) continue;
                    Collections.addAll(this.myAnnotationsRoots, files);
                }
            }
        }
        Set<VirtualFile> set = this.myAnnotationsRoots;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ReadableExternalAnnotationsManager", "initRoots"));
        }
        return set;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile libraryFile) {
        if (libraryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFile", "com/intellij/codeInsight/ReadableExternalAnnotationsManager", "getExternalAnnotationsRoots"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
        LinkedHashSet result2 = new LinkedHashSet();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(libraryFile)) {
            if (entry instanceof ModuleOrderEntry) continue;
            Collections.addAll(result2, AnnotationOrderRootType.getFiles(entry));
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result2);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ReadableExternalAnnotationsManager", "getExternalAnnotationsRoots"));
        }
        return arrayList;
    }

    @Override
    protected synchronized void dropCache() {
        this.myAnnotationsRoots = null;
        super.dropCache();
    }

    public boolean isUnderAnnotationRoot(VirtualFile file) {
        return VfsUtilCore.isUnder((VirtualFile)file, this.initRoots());
    }
}

