/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.XmlTextFilter;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.XmlTokenTypeFilter;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCompletionData
extends CompletionData {
    public XmlCompletionData() {
        CompletionVariant variant;
        this.declareFinalScope(XmlTag.class);
        this.declareFinalScope(XmlAttribute.class);
        this.declareFinalScope(XmlAttributeValue.class);
        CompletionVariant variant2 = new CompletionVariant(this.createTagCompletionFilter());
        variant2.includeScopeClass(XmlTag.class);
        variant2.addCompletionFilter(TrueFilter.INSTANCE);
        this.registerVariant(variant2);
        variant2 = new CompletionVariant(this.createAttributeCompletionFilter());
        variant2.includeScopeClass(XmlAttribute.class);
        variant2.addCompletionFilter(TrueFilter.INSTANCE);
        this.registerVariant(variant2);
        XmlAttributeValueGetter getter = this.getAttributeValueGetter();
        if (getter != null) {
            variant = new CompletionVariant(this.createAttributeValueCompletionFilter());
            variant.includeScopeClass(XmlAttributeValue.class);
            variant.addCompletion(getter, TailType.NONE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailType.NONE);
            this.registerVariant(variant);
        }
        ElementFilter entityCompletionFilter = this.createXmlEntityCompletionFilter();
        variant = new CompletionVariant(new AndFilter(new XmlTokenTypeFilter(XmlTokenType.XML_DATA_CHARACTERS), new NotFilter(entityCompletionFilter), new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
                if (tag != null) {
                    return XmlUtil.getSchemaSimpleContent(tag) != null;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
        variant.includeScopeClass(XmlToken.class, true);
        variant.addCompletion(new SimpleTagContentEnumerationValuesGetter(), TailType.NONE);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter((ElementFilter)new XmlTokenTypeFilter(XmlTokenType.XML_DATA_CHARACTERS), (ElementFilter)new NotFilter(entityCompletionFilter)));
        variant.includeScopeClass(XmlToken.class, true);
        this.registerVariant(variant);
        variant = new CompletionVariant(entityCompletionFilter);
        variant.includeScopeClass(XmlToken.class, true);
        variant.addCompletion(new EntityRefGetter());
        variant.setInsertHandler(new EntityRefInsertHandler());
        this.registerVariant(variant);
    }

    protected ElementFilter createXmlEntityCompletionFilter() {
        return new AndFilter((ElementFilter)new LeftNeighbour(new XmlTextFilter("&")), (ElementFilter)new OrFilter(new XmlTokenTypeFilter(XmlTokenType.XML_DATA_CHARACTERS), new XmlTokenTypeFilter(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)));
    }

    protected XmlAttributeValueGetter getAttributeValueGetter() {
        return new XmlAttributeValueGetter();
    }

    protected ElementFilter createAttributeCompletionFilter() {
        return TrueFilter.INSTANCE;
    }

    protected ElementFilter createAttributeValueCompletionFilter() {
        return TrueFilter.INSTANCE;
    }

    protected ElementFilter createTagCompletionFilter() {
        return TrueFilter.INSTANCE;
    }

    public static XmlFile findDescriptorFile(XmlTag tag, XmlFile containingFile) {
        XmlFile descriptorFile;
        XmlNSDescriptor nsDescriptor;
        XmlElementDescriptor descriptor = tag.getDescriptor();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = descriptor != null ? descriptor.getNSDescriptor() : null;
        Object object = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : (descriptorFile = containingFile.getDocument().getProlog().getDoctype() != null ? containingFile : null);
        if (nsDescriptor != null && (descriptorFile == null || descriptorFile.getName().equals(containingFile.getName() + ".dtd"))) {
            descriptorFile = containingFile;
        }
        return descriptorFile;
    }

    protected static class EntityRefInsertHandler
    extends BasicInsertHandler {
        protected EntityRefInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            context.setAddCompletionChar(false);
            CaretModel caretModel = context.getEditor().getCaretModel();
            context.getEditor().getDocument().insertString(caretModel.getOffset(), (CharSequence)";");
            caretModel.moveToOffset(caretModel.getOffset() + 1);
        }
    }

    protected static class EntityRefGetter
    implements ContextGetter {
        protected EntityRefGetter() {
        }

        @Nullable
        private static Object getLookupItem(@Nullable XmlEntityDecl decl) {
            String valueText;
            int i;
            ASTNode[] nodes;
            if (decl == null) {
                return null;
            }
            String name = decl.getName();
            if (name == null) {
                return null;
            }
            XmlAttributeValue value = decl.getValueElement();
            ASTNode node = value.getNode();
            if (node != null && (nodes = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CHAR_ENTITY_REF}))).length == 1 && (i = (valueText = nodes[0].getText()).indexOf(35)) > 0) {
                String s = valueText.substring(i + 1);
                if (s.endsWith(";")) {
                    s = s.substring(0, s.length() - 1);
                }
                try {
                    int unicodeChar = Integer.valueOf(s);
                    return LookupValueFactory.createLookupValueWithHint(name, null, String.valueOf((char)unicodeChar));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object[] get(PsiElement context, CompletionContext completionContext) {
            XmlDocument document;
            XmlFile containingFile = null;
            XmlFile descriptorFile = null;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
            if (tag != null) {
                containingFile = (XmlFile)tag.getContainingFile();
                descriptorFile = XmlCompletionData.findDescriptorFile(tag, containingFile);
            }
            if (HtmlUtil.isHtml5Context((XmlElement)tag)) {
                descriptorFile = XmlUtil.findXmlFile((PsiFile)containingFile, Html5SchemaProvider.getCharsDtdLocation());
            } else if (tag == null && (document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class)) != null) {
                String namespace;
                XmlNSDescriptor nsDescriptor;
                containingFile = (XmlFile)document.getContainingFile();
                FileType ft = containingFile.getFileType();
                if (HtmlUtil.isHtml5Document(document)) {
                    descriptorFile = XmlUtil.findXmlFile((PsiFile)containingFile, Html5SchemaProvider.getCharsDtdLocation());
                } else if (ft != StdFileTypes.XML && (nsDescriptor = document.getDefaultNSDescriptor(namespace = ft == StdFileTypes.XHTML || ft == StdFileTypes.JSPX ? "http://www.w3.org/1999/xhtml" : "http://www.w3.org/1999/html", true)) != null) {
                    descriptorFile = nsDescriptor.getDescriptorFile();
                }
            }
            if (descriptorFile != null) {
                XmlProlog element;
                final ArrayList results = new ArrayList();
                final boolean acceptSystemEntities = containingFile.getFileType() == StdFileTypes.XML;
                PsiElementProcessor processor2 = new PsiElementProcessor(){

                    public boolean execute(@NotNull PsiElement element) {
                        XmlEntityDecl xmlEntityDecl;
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/XmlCompletionData$EntityRefGetter$1", "execute"));
                        }
                        if (element instanceof XmlEntityDecl && ((xmlEntityDecl = (XmlEntityDecl)element).isInternalReference() || acceptSystemEntities)) {
                            String name = xmlEntityDecl.getName();
                            Object _item = EntityRefGetter.getLookupItem(xmlEntityDecl);
                            results.add(_item == null ? name : _item);
                        }
                        return true;
                    }
                };
                XmlUtil.processXmlElements((XmlElement)descriptorFile, processor2, true);
                if (descriptorFile != containingFile && containingFile.getFileType() == StdFileTypes.XML && (element = containingFile.getDocument().getProlog()) != null) {
                    XmlUtil.processXmlElements((XmlElement)element, processor2, true);
                }
                return ArrayUtil.toObjectArray(results);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private static class SimpleTagContentEnumerationValuesGetter
    implements ContextGetter {
        private SimpleTagContentEnumerationValuesGetter() {
        }

        @Override
        public Object[] get(PsiElement context, CompletionContext completionContext) {
            XmlTag simpleContent;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
            if (tag != null && (simpleContent = XmlUtil.getSchemaSimpleContent(tag)) != null) {
                HashSet<String> variants = new HashSet<String>();
                XmlUtil.collectEnumerationValues(simpleContent, variants);
                return ArrayUtil.toObjectArray(variants);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

