/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HighlightSuppressedWarningsHandler
extends HighlightUsagesHandlerBase<PsiLiteralExpression> {
    private static final Logger LOG = Logger.getInstance((String)("#" + HighlightSuppressedWarningsHandler.class.getName()));
    private final PsiAnnotation myTarget;
    private final PsiLiteralExpression mySuppressedExpression;

    protected HighlightSuppressedWarningsHandler(Editor editor, PsiFile file, PsiAnnotation target, PsiLiteralExpression suppressedExpression) {
        super(editor, file);
        this.myTarget = target;
        this.mySuppressedExpression = suppressedExpression;
    }

    @Override
    public List<PsiLiteralExpression> getTargets() {
        PsiNameValuePair[] attributes;
        ArrayList<PsiLiteralExpression> result2 = new ArrayList<PsiLiteralExpression>();
        if (this.mySuppressedExpression != null) {
            result2.add(this.mySuppressedExpression);
            return result2;
        }
        PsiAnnotationParameterList list = this.myTarget.getParameterList();
        for (PsiNameValuePair attribute : attributes = list.getAttributes()) {
            PsiAnnotationMemberValue[] initializers;
            PsiAnnotationMemberValue value = attribute.getValue();
            if (!(value instanceof PsiArrayInitializerMemberValue)) continue;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                if (!(initializer instanceof PsiLiteralExpression)) continue;
                result2.add((PsiLiteralExpression)initializer);
            }
        }
        return result2;
    }

    @Override
    protected void selectTargets(List<PsiLiteralExpression> targets, final Consumer<List<PsiLiteralExpression>> selectionConsumer) {
        if (targets.size() == 1) {
            selectionConsumer.consume(targets);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiLiteralExpression>("Choose Inspections to Highlight Suppressed Problems from", targets){

                public PopupStep onChosen(PsiLiteralExpression selectedValue, boolean finalChoice) {
                    selectionConsumer.consume(Collections.singletonList(selectedValue));
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(PsiLiteralExpression value) {
                    Object o = value.getValue();
                    LOG.assertTrue(o instanceof String);
                    String string = (String)o;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/HighlightSuppressedWarningsHandler$1", "getTextFor"));
                    }
                    return string;
                }
            }).showInBestPositionFor(this.myEditor);
        }
    }

    @Override
    public void computeUsages(List<PsiLiteralExpression> targets) {
        Project project = this.myTarget.getProject();
        PsiElement parent = this.myTarget.getParent().getParent();
        final LocalInspectionsPass pass = new LocalInspectionsPass(this.myFile, this.myFile.getViewProvider().getDocument(), parent.getTextRange().getStartOffset(), parent.getTextRange().getEndOffset(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, false, HighlightInfoProcessor.getEmpty());
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        for (PsiLiteralExpression target : targets) {
            InspectionToolWrapper toolWrapperById;
            Object value = target.getValue();
            if (!(value instanceof String) || !((toolWrapperById = ((InspectionProfileImpl)inspectionProfile).getToolById((String)value, (PsiElement)target)) instanceof LocalInspectionToolWrapper)) continue;
            final LocalInspectionToolWrapper toolWrapper = ((LocalInspectionToolWrapper)toolWrapperById).createCopy();
            final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
            final GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
            toolWrapper.initialize(context);
            ((RefManagerImpl)context.getRefManager()).inspectionReadActionStarted();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            Runnable inspect = new Runnable(){

                @Override
                public void run() {
                    pass.doInspectInBatch(context, managerEx, Collections.singletonList(toolWrapper));
                }
            };
            if (indicator == null) {
                ProgressManager.getInstance().executeProcessUnderProgress(inspect, (ProgressIndicator)new ProgressIndicatorBase());
            } else {
                inspect.run();
            }
            for (HighlightInfo info : pass.getInfos()) {
                PsiElement element = CollectHighlightsUtil.findCommonParent((PsiElement)this.myFile, info.startOffset, info.endOffset);
                if (element == null) continue;
                this.addOccurrence(element);
            }
        }
    }
}

