/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInference {
    public static Nullness inferNullity(final PsiMethod method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        PsiType type = method.getReturnType();
        if (type == null || type instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<Nullness>(){

            @Nullable
            public CachedValueProvider.Result<Nullness> compute() {
                Nullness result2 = (Nullness)((Object)RecursionManager.doPreventingRecursion((Object)method, (boolean)true, (Computable)new Computable<Nullness>(){

                    public Nullness compute() {
                        return NullityInference.doInferNullity(method);
                    }
                }));
                if (result2 == null) {
                    result2 = Nullness.UNKNOWN;
                }
                return CachedValueProvider.Result.create((Object)((Object)result2), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }));
    }

    @NotNull
    private static Nullness doInferNullity(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            final AtomicBoolean hasErrors = new AtomicBoolean();
            final AtomicBoolean hasNotNulls = new AtomicBoolean();
            final AtomicBoolean hasNulls = new AtomicBoolean();
            final AtomicBoolean hasUnknowns = new AtomicBoolean();
            final LinkedHashSet delegates = ContainerUtil.newLinkedHashSet();
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiExpression value = statement.getReturnValue();
                    if (value == null) {
                        hasErrors.set(true);
                    } else if (value instanceof PsiLiteralExpression) {
                        if (value.textMatches((CharSequence)"null")) {
                            hasNulls.set(true);
                        } else {
                            hasNotNulls.set(true);
                        }
                    } else if (value instanceof PsiLambdaExpression || value.getType() instanceof PsiPrimitiveType) {
                        hasNotNulls.set(true);
                    } else if (this.containsNulls(value)) {
                        hasNulls.set(true);
                    } else if (value instanceof PsiMethodCallExpression) {
                        PsiMethod target = ((PsiMethodCallExpression)value).resolveMethod();
                        if (target == null) {
                            hasUnknowns.set(true);
                        } else {
                            delegates.add(target);
                        }
                    } else {
                        hasUnknowns.set(true);
                    }
                    super.visitReturnStatement(statement);
                }

                private boolean containsNulls(PsiExpression value) {
                    if (value instanceof PsiConditionalExpression) {
                        return this.containsNulls(((PsiConditionalExpression)value).getElseExpression()) || this.containsNulls(((PsiConditionalExpression)value).getThenExpression());
                    }
                    if (value instanceof PsiParenthesizedExpression) {
                        return this.containsNulls(((PsiParenthesizedExpression)value).getExpression());
                    }
                    return value instanceof PsiLiteralExpression && value.textMatches((CharSequence)"null");
                }

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }

                public void visitErrorElement(PsiErrorElement element) {
                    hasErrors.set(true);
                    super.visitErrorElement(element);
                }
            });
            if (hasNulls.get()) {
                Nullness nullness = InferenceFromSourceUtil.suppressNullable(method) ? Nullness.UNKNOWN : Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
                }
                return nullness;
            }
            if (hasErrors.get() || hasUnknowns.get() || delegates.size() > 1) {
                Nullness nullness = Nullness.UNKNOWN;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
                }
                return nullness;
            }
            if (delegates.size() == 1) {
                if (NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)delegates.iterator().next()))) {
                    Nullness nullness = Nullness.NOT_NULL;
                    if (nullness == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
                    }
                    return nullness;
                }
                Nullness nullness = Nullness.UNKNOWN;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
                }
                return nullness;
            }
            if (hasNotNulls.get()) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullityInference", "doInferNullity"));
        }
        return nullness;
    }
}

