/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private final HashSet<Object> myExpandedUserObjects;
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    private SelectionPath mySelectionPath;
    private static final ProblemDescriptor[] EMPTY_DESCRIPTORS = new ProblemDescriptor[0];

    public InspectionTree(@NotNull Project project, @NotNull GlobalInspectionContextImpl context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/InspectionTree", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ui/InspectionTree", "<init>"));
        }
        super((TreeNode)new InspectionRootNode(project));
        this.myContext = context;
        this.setCellRenderer((TreeCellRenderer)((Object)new CellRenderer()));
        this.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.addTreeWillExpandListener(new ExpandListener());
        this.myExpandedUserObjects = new HashSet();
        this.myExpandedUserObjects.add(project);
        TreeUtil.installActions((JTree)((Object)this));
        new TreeSpeedSearch(this, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                return InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString());
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath newSelection = e.getNewLeadSelectionPath();
                if (newSelection != null) {
                    InspectionTree.this.mySelectionPath = new SelectionPath(newSelection);
                }
            }
        });
    }

    public void removeAllNodes() {
        this.getRoot().removeAllChildren();
        this.nodeStructureChanged(this.getRoot());
    }

    public InspectionTreeNode getRoot() {
        return (InspectionTreeNode)this.getModel().getRoot();
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        InspectionToolWrapper toolWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (!(node instanceof InspectionNode)) continue;
                InspectionToolWrapper wrapper = ((InspectionNode)node).getToolWrapper();
                if (toolWrapper == null) {
                    toolWrapper = wrapper;
                    continue block0;
                }
                if (toolWrapper == wrapper) continue block0;
                return null;
            }
        }
        return toolWrapper;
    }

    @NotNull
    public RefEntity[] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper();
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            ArrayList<RefEntity> result2 = new ArrayList<RefEntity>();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            RefEntity[] refEntityArray = result2.toArray(new RefEntity[result2.size()]);
            if (refEntityArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    private static void addElementsInNode(InspectionTreeNode node, List<RefEntity> out) {
        RefEntity element;
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode && !out.contains(element = ((RefElementNode)node).getElement())) {
            out.add(0, element);
        }
        if (node instanceof ProblemDescriptionNode && !out.contains(element = ((ProblemDescriptionNode)node).getElement())) {
            out.add(0, element);
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children.nextElement();
            InspectionTree.addElementsInNode(child, out);
        }
    }

    public CommonProblemDescriptor[] getSelectedDescriptors() {
        InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper();
        if (this.getSelectionCount() == 0) {
            return EMPTY_DESCRIPTORS;
        }
        TreePath[] paths = this.getSelectionPaths();
        LinkedHashSet<CommonProblemDescriptor> descriptors = new LinkedHashSet<CommonProblemDescriptor>();
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            InspectionTree.traverseDescriptors((InspectionTreeNode)node, descriptors);
        }
        return descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
    }

    private static void traverseDescriptors(InspectionTreeNode node, LinkedHashSet<CommonProblemDescriptor> descriptors) {
        if (node instanceof ProblemDescriptionNode) {
            descriptors.add(((ProblemDescriptionNode)node).getDescriptor());
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            InspectionTree.traverseDescriptors((InspectionTreeNode)node.getChildAt(i), descriptors);
        }
    }

    private void nodeStructureChanged(InspectionTreeNode node) {
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
    }

    public void restoreExpansionAndSelection() {
        this.restoreExpansionStatus((InspectionTreeNode)this.getModel().getRoot());
        if (this.mySelectionPath != null) {
            this.mySelectionPath.restore();
        }
    }

    private void restoreExpansionStatus(InspectionTreeNode node) {
        if (this.myExpandedUserObjects.contains(node.getUserObject())) {
            this.sortChildren(node);
            Object[] pathToNode = node.getPath();
            this.expandPath(new TreePath(pathToNode));
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                InspectionTreeNode childNode = (InspectionTreeNode)children.nextElement();
                this.restoreExpansionStatus(childNode);
            }
        }
    }

    private void sortChildren(InspectionTreeNode node) {
        ArrayList children = TreeUtil.childrenToArray((TreeNode)node);
        Collections.sort(children, InspectionResultsViewComparator.getInstance());
        node.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)node, (List)children);
        ((DefaultTreeModel)this.getModel()).reload(node);
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getContext"));
        }
        return globalInspectionContextImpl;
    }

    private class SelectionPath {
        private final Object[] myPath;
        private final int[] myIndicies;

        public SelectionPath(TreePath path) {
            this.myPath = path.getPath();
            this.myIndicies = new int[this.myPath.length];
            for (int i = 0; i < this.myPath.length - 1; ++i) {
                InspectionTreeNode node = (InspectionTreeNode)this.myPath[i];
                this.myIndicies[i + 1] = this.getChildIndex(node, (InspectionTreeNode)this.myPath[i + 1]);
            }
        }

        private int getChildIndex(InspectionTreeNode node, InspectionTreeNode child) {
            InspectionTreeNode ch;
            int idx = 0;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements() && (ch = (InspectionTreeNode)children.nextElement()) != child) {
                ++idx;
            }
            return idx;
        }

        public void restore() {
            InspectionTree.this.getSelectionModel().removeSelectionPaths(InspectionTree.this.getSelectionModel().getSelectionPaths());
            TreeUtil.selectPath((JTree)((Object)InspectionTree.this), (TreePath)this.restorePath());
        }

        private TreePath restorePath() {
            ArrayList<Object> newPath = new ArrayList<Object>();
            newPath.add(InspectionTree.this.getModel().getRoot());
            this.restorePath(newPath, 1);
            return new TreePath(newPath.toArray(new InspectionTreeNode[newPath.size()]));
        }

        private void restorePath(ArrayList<Object> newPath, int idx) {
            if (idx >= this.myPath.length) {
                return;
            }
            InspectionTreeNode oldNode = (InspectionTreeNode)this.myPath[idx];
            InspectionTreeNode newRoot = (InspectionTreeNode)newPath.get(idx - 1);
            InspectionResultsViewComparator comparator2 = InspectionResultsViewComparator.getInstance();
            Enumeration<TreeNode> children = newRoot.children();
            while (children.hasMoreElements()) {
                InspectionTreeNode child = (InspectionTreeNode)children.nextElement();
                if (comparator2.compare(child, oldNode) != 0) continue;
                newPath.add(child);
                this.restorePath(newPath, idx + 1);
                return;
            }
            int count = newRoot.getChildCount();
            if (count > 0) {
                if (this.myIndicies[idx] < count) {
                    newPath.add(newRoot.getChildAt(this.myIndicies[idx]));
                } else {
                    newPath.add(newRoot.getChildAt(count - 1));
                }
            }
        }
    }

    private static class CellRenderer
    extends ColoredTreeCellRenderer {
        private CellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            InspectionTreeNode node = (InspectionTreeNode)value;
            this.append(node.toString(), CellRenderer.patchAttr(node, CellRenderer.appearsBold(node) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : CellRenderer.getMainForegroundAttributes(node)));
            int problemCount = node.getProblemCount();
            if (!leaf) {
                this.append(" " + InspectionsBundle.message((String)"inspection.problem.descriptor.count", (Object[])new Object[]{problemCount}), CellRenderer.patchAttr(node, SimpleTextAttributes.GRAYED_ATTRIBUTES));
            }
            if (!node.isValid()) {
                this.append(" " + InspectionsBundle.message((String)"inspection.invalid.node.text", (Object[])new Object[0]), CellRenderer.patchAttr(node, SimpleTextAttributes.ERROR_ATTRIBUTES));
            } else {
                this.setIcon(node.getIcon(expanded));
            }
        }

        public static SimpleTextAttributes patchAttr(InspectionTreeNode node, SimpleTextAttributes attributes) {
            if (node.isResolved()) {
                return new SimpleTextAttributes(attributes.getBgColor(), attributes.getFgColor(), attributes.getWaveColor(), attributes.getStyle() | 4);
            }
            return attributes;
        }

        private static SimpleTextAttributes getMainForegroundAttributes(InspectionTreeNode node) {
            FileStatus nodeStatus;
            RefEntity refElement;
            SimpleTextAttributes foreground = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (node instanceof RefElementNode && (refElement = ((RefElementNode)node).getElement()) instanceof RefElement && ((RefElement)(refElement = ((RefElement)refElement).getContainingEntry())).isEntry() && ((RefElement)refElement).isPermanentEntry()) {
                foreground = new SimpleTextAttributes(0, (Color)JBColor.blue);
            }
            if ((nodeStatus = node.getNodeStatus()) != FileStatus.NOT_CHANGED) {
                foreground = new SimpleTextAttributes(foreground.getBgColor(), nodeStatus.getColor(), foreground.getWaveColor(), foreground.getStyle());
            }
            return foreground;
        }

        private static boolean appearsBold(Object node) {
            return ((InspectionTreeNode)node).appearsBold();
        }
    }

    private class ExpandListener
    implements TreeWillExpandListener {
        private ExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            final InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            Object userObject = node.getUserObject();
            if (node.isValid() && !InspectionTree.this.myExpandedUserObjects.contains(userObject)) {
                InspectionTree.this.sortChildren(node);
                InspectionTree.this.nodeStructureChanged(node);
            }
            InspectionTree.this.myExpandedUserObjects.add(userObject);
            if (node.getChildCount() == 1) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InspectionTree.this.expandPath(new TreePath(node.getPath()));
                    }
                });
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myExpandedUserObjects.remove(node.getUserObject());
        }
    }
}

