/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.InstructionParser;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class LocalVariablesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
    private static final boolean ourInitializationOk;
    private static Class<?> ourSlotInfoClass;
    private static Constructor<?> slotInfoConstructor;
    private static Class<?> ourGetValuesClass;
    private static Method ourEnqueueMethod;
    private static Method ourWaitForReplyMethod;

    public static Map<DecompiledLocalVariable, Value> fetchValues(@NotNull StackFrameProxyImpl frameProxy, DebugProcess process) throws Exception {
        if (frameProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameProxy", "com/intellij/debugger/jdi/LocalVariablesUtil", "fetchValues"));
        }
        LinkedHashMap<DecompiledLocalVariable, Value> map = new LinkedHashMap<DecompiledLocalVariable, Value>();
        com.sun.jdi.Method method = frameProxy.location().method();
        int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
        MultiMap<Integer, String> namesMap = LocalVariablesUtil.calcNames(new SimpleStackFrameContext(frameProxy, process), firstLocalVariableSlot);
        int slot = 0;
        List<String> typeNames = method.argumentTypeNames();
        List<Value> argValues = frameProxy.getArgumentValues();
        for (int i = 0; i < argValues.size(); ++i) {
            map.put(new DecompiledLocalVariable(slot, true, null, namesMap.get((Object)slot)), argValues.get(i));
            slot += LocalVariablesUtil.getTypeSlotSize(typeNames.get(i));
        }
        if (!ourInitializationOk) {
            return map;
        }
        List<DecompiledLocalVariable> vars = LocalVariablesUtil.collectVariablesFromBytecode(frameProxy, namesMap);
        StackFrame frame = frameProxy.getStackFrame();
        for (int size = vars.size(); size > 0; --size) {
            try {
                return LocalVariablesUtil.fetchSlotValues(map, vars.subList(0, size), frame);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                continue;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<DecompiledLocalVariable, Value> fetchSlotValues(Map<DecompiledLocalVariable, Value> map, List<DecompiledLocalVariable> vars, StackFrame frame) throws Exception {
        Object ps;
        Object vmState;
        Field frameIdField = frame.getClass().getDeclaredField("id");
        frameIdField.setAccessible(true);
        Object frameId = frameIdField.get(frame);
        VirtualMachine vm = frame.virtualMachine();
        Method stateMethod = vm.getClass().getDeclaredMethod("state", new Class[0]);
        stateMethod.setAccessible(true);
        Object slotInfoArray = LocalVariablesUtil.createSlotInfoArray(vars);
        Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
        synchronized (object) {
            ps = ourEnqueueMethod.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
        }
        Object reply = ourWaitForReplyMethod.invoke(null, vm, ps);
        Field valuesField = reply.getClass().getDeclaredField("values");
        valuesField.setAccessible(true);
        Value[] values = (Value[])valuesField.get(reply);
        if (vars.size() != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            map.put(var, values[idx++]);
        }
        return map;
    }

    private static Object createSlotInfoArray(Collection<DecompiledLocalVariable> vars) throws Exception {
        Object arrayInstance = Array.newInstance(ourSlotInfoClass, vars.size());
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            Object info = slotInfoConstructor.newInstance(var.getSlot(), (byte)var.getSignature().charAt(0));
            Array.set(arrayInstance, idx++, info);
        }
        return arrayInstance;
    }

    private static Method findMethod(Class aClass, String methodName) throws NoSuchMethodException {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        throw new NoSuchMethodException(aClass.getName() + "." + methodName);
    }

    @NotNull
    private static List<DecompiledLocalVariable> collectVariablesFromBytecode(StackFrameProxyImpl frame, final MultiMap<Integer, String> namesMap) throws EvaluateException {
        block12: {
            ArrayList<DecompiledLocalVariable> arrayList;
            HashMap usedVars;
            block13: {
                com.sun.jdi.Method method;
                Location location;
                block11: {
                    if (!frame.getVirtualMachine().canGetBytecodes()) {
                        List<DecompiledLocalVariable> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                        }
                        return list;
                    }
                    location = frame.location();
                    LOG.assertTrue(location != null);
                    method = location.method();
                    Location methodLocation = method.location();
                    if (methodLocation != null && methodLocation.codeIndex() >= 0L) break block11;
                    List<DecompiledLocalVariable> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                    }
                    return list;
                }
                byte[] bytecodes = method.bytecodes();
                if (bytecodes == null || bytecodes.length <= 0) break block12;
                final int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
                usedVars = new HashMap();
                new InstructionParser(bytecodes, location.codeIndex()){

                    @Override
                    protected void localVariableInstructionFound(int opcode, int slot, String typeSignature) {
                        DecompiledLocalVariable variable;
                        if (!(slot < firstLocalVariableSlot || (variable = (DecompiledLocalVariable)usedVars.get(slot)) != null && typeSignature.equals(variable.getSignature()))) {
                            variable = new DecompiledLocalVariable(slot, false, typeSignature, namesMap.get((Object)slot));
                            usedVars.put(slot, variable);
                        }
                    }
                }.parse();
                if (!usedVars.isEmpty()) break block13;
                List<DecompiledLocalVariable> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                }
                return list;
            }
            try {
                ArrayList<DecompiledLocalVariable> vars = new ArrayList<DecompiledLocalVariable>(usedVars.values());
                Collections.sort(vars, DecompiledLocalVariable.COMPARATOR);
                arrayList = vars;
            }
            catch (UnsupportedOperationException location) {
                break block12;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
            }
            return arrayList;
        }
        List<DecompiledLocalVariable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
        }
        return list;
    }

    @NotNull
    private static MultiMap<Integer, String> calcNames(final @NotNull StackFrameContext context, final int firstLocalsSlot) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/jdi/LocalVariablesUtil", "calcNames"));
        }
        MultiMap multiMap = (MultiMap)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MultiMap<Integer, String>>(){

            public MultiMap<Integer, String> compute() {
                PsiParameterList params;
                PsiElement element;
                PsiElement method;
                SourcePosition position = ContextUtil.getSourcePosition(context);
                if (position != null && (method = DebuggerUtilsEx.getContainingMethod(element = position.getElementAt())) != null && (params = DebuggerUtilsEx.getParameterList(method)) != null) {
                    MultiMap res = new MultiMap();
                    int psiFirstLocalsSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
                    int slot = Math.max(0, firstLocalsSlot - psiFirstLocalsSlot);
                    for (int i = 0; i < params.getParametersCount(); ++i) {
                        PsiParameter parameter = params.getParameters()[i];
                        res.putValue((Object)slot, (Object)parameter.getName());
                        slot += LocalVariablesUtil.getTypeSlotSize(parameter.getType());
                    }
                    PsiElement body = DebuggerUtilsEx.getBody(method);
                    if (body != null) {
                        try {
                            body.accept((PsiElementVisitor)new LocalVariableNameFinder(firstLocalsSlot, (MultiMap<Integer, String>)res, element));
                        }
                        catch (Exception e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return res;
                }
                return MultiMap.empty();
            }
        });
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "calcNames"));
        }
        return multiMap;
    }

    private static int getFirstLocalsSlot(PsiElement method) {
        PsiParameterList params;
        int startSlot = 0;
        if (method instanceof PsiModifierListOwner) {
            int n = startSlot = ((PsiModifierListOwner)method).hasModifierProperty("static") ? 0 : 1;
        }
        if ((params = DebuggerUtilsEx.getParameterList(method)) != null) {
            for (PsiParameter parameter : params.getParameters()) {
                startSlot += LocalVariablesUtil.getTypeSlotSize(parameter.getType());
            }
        }
        return startSlot;
    }

    private static int getTypeSlotSize(PsiType varType) {
        if (varType == PsiType.DOUBLE || varType == PsiType.LONG) {
            return 2;
        }
        return 1;
    }

    private static int getFirstLocalsSlot(com.sun.jdi.Method method) {
        int firstLocalVariableSlot = method.isStatic() ? 0 : 1;
        for (String type : method.argumentTypeNames()) {
            firstLocalVariableSlot += LocalVariablesUtil.getTypeSlotSize(type);
        }
        return firstLocalVariableSlot;
    }

    private static int getTypeSlotSize(String name) {
        if ("double".equals(name) || "long".equals(name)) {
            return 2;
        }
        return 1;
    }

    static {
        boolean success = false;
        try {
            ourSlotInfoClass = Class.forName("com.sun.tools.jdi.JDWP$StackFrame$GetValues$SlotInfo");
            slotInfoConstructor = ourSlotInfoClass.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            slotInfoConstructor.setAccessible(true);
            ourGetValuesClass = Class.forName("com.sun.tools.jdi.JDWP$StackFrame$GetValues");
            ourEnqueueMethod = LocalVariablesUtil.findMethod(ourGetValuesClass, "enqueueCommand");
            ourEnqueueMethod.setAccessible(true);
            ourWaitForReplyMethod = LocalVariablesUtil.findMethod(ourGetValuesClass, "waitForReply");
            ourWaitForReplyMethod.setAccessible(true);
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOk = success;
    }

    private static class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final MultiMap<Integer, String> myNames;
        private int myCurrentSlotIndex;
        private final PsiElement myElement;
        private final Stack<Integer> myIndexStack;

        public LocalVariableNameFinder(int startSlot, MultiMap<Integer, String> names, PsiElement element) {
            this.myNames = names;
            this.myCurrentSlotIndex = startSlot;
            this.myElement = element;
            this.myIndexStack = new Stack();
        }

        private boolean shouldVisit(PsiElement scope) {
            return PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)this.myElement, (boolean)false);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.appendName(variable.getName());
            this.myCurrentSlotIndex += LocalVariablesUtil.getTypeSlotSize(variable.getType());
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            if (this.shouldVisit((PsiElement)statement)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    this.appendName("<monitor>");
                    ++this.myCurrentSlotIndex;
                    super.visitSynchronizedStatement(statement);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        private void appendName(String varName) {
            this.myNames.putValue((Object)this.myCurrentSlotIndex, (Object)varName);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.shouldVisit((PsiElement)block)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCodeBlock(block);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForStatement(PsiForStatement statement) {
            if (this.shouldVisit((PsiElement)statement)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForStatement(statement);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            if (this.shouldVisit((PsiElement)statement)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForeachStatement(statement);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitCatchSection(PsiCatchSection section) {
            if (this.shouldVisit((PsiElement)section)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCatchSection(section);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            if (this.shouldVisit((PsiElement)resourceList)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitResourceList(resourceList);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }
}

