/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public abstract class EditorEvaluationCommand<T>
extends DebuggerContextCommandImpl {
    protected final PsiElement myElement;
    @Nullable
    private final Editor myEditor;
    protected final ProgressIndicator myProgressIndicator;
    private final DebuggerContextImpl myDebuggerContext;

    public EditorEvaluationCommand(@Nullable Editor editor, PsiElement expression, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(context);
        Project project = expression.getProject();
        this.myProgressIndicator = indicator;
        this.myEditor = editor;
        this.myElement = expression;
        this.myDebuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
    }

    @Override
    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    protected abstract T evaluate(EvaluationContextImpl var1) throws EvaluateException;

    public T evaluate() throws EvaluateException {
        this.myProgressIndicator.setText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return EditorEvaluationCommand.this.myElement.getText();
            }
        })}));
        try {
            T result2 = this.evaluate(this.myDebuggerContext.createEvaluationContext());
            if (this.myProgressIndicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            return result2;
        }
        catch (EvaluateException e) {
            if (this.myEditor != null) {
                DebuggerInvocationUtil.invokeLater(this.myDebuggerContext.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        EditorEvaluationCommand.showEvaluationHint(EditorEvaluationCommand.this.myEditor, EditorEvaluationCommand.this.myElement, e);
                    }
                }, this.myProgressIndicator.getModalityState());
            }
            throw e;
        }
    }

    public static void showEvaluationHint(Editor myEditor, PsiElement myElement, EvaluateException e) {
        if (myEditor.isDisposed() || !myEditor.getComponent().isVisible()) {
            return;
        }
        HintManager.getInstance().showErrorHint(myEditor, e.getMessage(), myElement.getTextRange().getStartOffset(), myElement.getTextRange().getEndOffset(), (short)2, 9, 1500);
    }
}

