/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.formatting.contextConfiguration.CodeFragmentCodeStyleSettingsPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureCodeStyleOnSelectedFragment
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(ConfigureCodeStyleOnSelectedFragment.class);

    @Nls
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("ConfigureCodeStyleOnSelectedFragment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "getFamilyName"));
        }
        return "ConfigureCodeStyleOnSelectedFragment";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "isAvailable"));
        }
        Language language = file.getLanguage();
        return editor.getSelectionModel().hasSelection() && LanguageCodeStyleSettingsProvider.forLanguage((Language)language) != null && file.isWritable();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "invoke"));
        }
        SelectedTextFormatter textFormatter = new SelectedTextFormatter(project, editor, file);
        CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow = ConfigureCodeStyleOnSelectedFragment.calculateAffectingSettings(editor, file);
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        new FragmentCodeStyleSettingsDialog(editor, textFormatter, file.getLanguage(), settings, settingsToShow).show();
    }

    private static CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow calculateAffectingSettings(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "calculateAffectingSettings"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment", "calculateAffectingSettings"));
        }
        SelectionModel model = editor.getSelectionModel();
        int start = model.getSelectionStart();
        int end = model.getSelectionEnd();
        CodeStyleSettingsCodeFragmentFilter settingsProvider = new CodeStyleSettingsCodeFragmentFilter(file, new TextRange(start, end));
        return CodeFragmentCodeStyleSettingsPanel.calcSettingNamesToShow(settingsProvider);
    }

    public boolean startInWriteAction() {
        return false;
    }

    static class FragmentCodeStyleSettingsDialog
    extends DialogWrapper {
        private final CodeFragmentCodeStyleSettingsPanel myTabbedLanguagePanel;
        private final Editor myEditor;
        private final Document myDocument;
        private SelectedTextFormatter mySelectedTextFormatter;
        private CodeStyleSettings mySettings;

        public FragmentCodeStyleSettingsDialog(@NotNull Editor editor, @NotNull SelectedTextFormatter selectedTextFormatter, @NotNull Language language, CodeStyleSettings settings, CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog", "<init>"));
            }
            if (selectedTextFormatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTextFormatter", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog", "<init>"));
            }
            super((Component)editor.getContentComponent(), true);
            this.mySettings = settings;
            this.mySelectedTextFormatter = selectedTextFormatter;
            this.myTabbedLanguagePanel = new CodeFragmentCodeStyleSettingsPanel(settings, settingsToShow, language, selectedTextFormatter);
            this.myOKAction = new ApplyToSettings();
            this.myOKAction.setEnabled(false);
            this.myTabbedLanguagePanel.setOnSomethingChangedCallback(new Runnable(){

                @Override
                public void run() {
                    boolean isModified = FragmentCodeStyleSettingsDialog.this.myTabbedLanguagePanel.isModified(FragmentCodeStyleSettingsDialog.this.mySettings);
                    FragmentCodeStyleSettingsDialog.this.myOKAction.setEnabled(isModified);
                }
            });
            this.myEditor = editor;
            this.myDocument = editor.getDocument();
            String title = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
            this.setTitle(StringUtil.capitalizeWords((String)title, (boolean)true) + ": " + language.getDisplayName());
            this.setInitialLocationCallback((Computable)new Computable<Point>(){

                public Point compute() {
                    return new DialogPositionProvider().calculateLocation();
                }
            });
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTabbedLanguagePanel.getPreferredFocusedComponent();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myTabbedLanguagePanel.getPanel();
        }

        protected void dispose() {
            super.dispose();
            Disposer.dispose((Disposable)this.myTabbedLanguagePanel);
        }

        protected void doOKAction() {
            this.applyFromUiToSettings();
            super.doOKAction();
        }

        private void applyFromUiToSettings() {
            try {
                this.createNewCodeStyleSchemeIfDefault();
                this.myTabbedLanguagePanel.apply(this.mySettings);
            }
            catch (ConfigurationException e) {
                LOG.debug("Can not apply code style settings from context menu to project code style settings");
            }
        }

        private void createNewCodeStyleSchemeIfDefault() {
            CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
            CodeStyleScheme current = schemes.getCurrentScheme();
            if (current != null && CodeStyleSchemesModel.cannotBeModified(current)) {
                CodeStyleScheme newScheme = schemes.createNewScheme(null, current);
                schemes.addScheme(newScheme);
                CodeStyleSettingsManager.getInstance((Project)this.myEditor.getProject()).PREFERRED_PROJECT_CODE_STYLE = newScheme.getName();
                this.mySettings = newScheme.getCodeStyleSettings();
            }
        }

        public void doCancelAction() {
            this.mySelectedTextFormatter.restoreSelectedText();
            super.doCancelAction();
        }

        private class ApplyToSettingsAndReformat
        extends AbstractAction {
            public ApplyToSettingsAndReformat() {
                super("Save and Reformat File");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentCodeStyleSettingsDialog.this.applyFromUiToSettings();
                FragmentCodeStyleSettingsDialog.this.mySelectedTextFormatter.reformatWholeFile();
                FragmentCodeStyleSettingsDialog.super.doOKAction();
            }
        }

        private class ApplyToSettings
        extends AbstractAction
        implements OptionAction {
            private Action[] myOptions;

            private ApplyToSettings() {
                super("Save");
                this.myOptions = new Action[]{new ApplyToSettingsAndReformat()};
                this.putValue("DefaultAction", Boolean.TRUE);
            }

            @Override
            public void setEnabled(boolean value) {
                super.setEnabled(value);
                for (Action option : this.myOptions) {
                    option.setEnabled(value);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentCodeStyleSettingsDialog.this.doOKAction();
            }

            @NotNull
            public Action[] getOptions() {
                if (this.myOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog$ApplyToSettings", "getOptions"));
                }
                return this.myOptions;
            }
        }

        private class DialogPositionProvider {
            private static final int PREFERRED_PADDING = 100;
            private JComponent myEditorComponent;
            private JComponent myContentComponent;
            private int mySelectionStartY;
            private int mySelectionEndY;
            private int myTextRangeMaxColumnX;
            private int myEditorComponentWidth;
            private int myEditorComponentHeight;

            public DialogPositionProvider() {
                this.myContentComponent = FragmentCodeStyleSettingsDialog.this.myEditor.getContentComponent();
                this.myEditorComponent = FragmentCodeStyleSettingsDialog.this.myEditor.getComponent();
                this.myEditorComponentWidth = this.myEditorComponent.getWidth();
                this.myEditorComponentHeight = this.myEditorComponent.getHeight();
            }

            public Point calculateLocation() {
                this.calculateSelectedTextRectangle();
                int dialogWidth = FragmentCodeStyleSettingsDialog.this.getSize().width;
                int dialogHeight = FragmentCodeStyleSettingsDialog.this.getSize().height;
                int spaceIfPlacedOnTheRight = this.myEditorComponentWidth - (this.myTextRangeMaxColumnX + dialogWidth);
                Integer dialogX = null;
                Integer dialogY = null;
                if (spaceIfPlacedOnTheRight > 0) {
                    int paddingFromText = spaceIfPlacedOnTheRight > 100 ? 100 : spaceIfPlacedOnTheRight / 2;
                    dialogX = this.myTextRangeMaxColumnX + paddingFromText;
                    dialogY = this.mySelectionEndY - this.mySelectionStartY > dialogHeight ? Integer.valueOf((this.myEditorComponentHeight - dialogHeight) / 2) : this.getYMatchingDialogAndSelectionCenter(dialogHeight);
                } else if (this.mySelectionStartY > dialogHeight) {
                    dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
                    dialogY = this.mySelectionStartY - dialogHeight;
                } else if (this.mySelectionEndY + dialogHeight < this.myEditorComponentHeight) {
                    dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
                    dialogY = this.mySelectionEndY;
                }
                if (dialogX != null && dialogY != null) {
                    Point location = new Point(dialogX, dialogY);
                    SwingUtilities.convertPointToScreen(location, FragmentCodeStyleSettingsDialog.this.myEditor.getComponent());
                    return location;
                }
                return null;
            }

            private Integer getYMatchingDialogAndSelectionCenter(int dialogHeight) {
                int extraBottomSpace;
                int selectionCenter = (this.mySelectionStartY + this.mySelectionEndY) / 2;
                int dialogTop = selectionCenter - dialogHeight / 2;
                int dialogBottom = selectionCenter + dialogHeight / 2;
                if (dialogTop >= 0 && dialogBottom <= this.myEditorComponentHeight) {
                    return dialogTop;
                }
                if (dialogTop < 0) {
                    int extraTopSpace = -dialogTop;
                    if (dialogBottom + extraTopSpace <= this.myEditorComponentHeight) {
                        return 0;
                    }
                } else if (dialogBottom > this.myEditorComponentHeight && dialogTop - (extraBottomSpace = dialogBottom - this.myEditorComponentHeight) >= 0) {
                    return dialogTop - extraBottomSpace;
                }
                return null;
            }

            private void calculateSelectedTextRectangle() {
                SelectionModel selectionModel = FragmentCodeStyleSettingsDialog.this.myEditor.getSelectionModel();
                int selectionStartOffset = selectionModel.getSelectionStart();
                int selectionEndOffset = selectionModel.getSelectionEnd();
                VisualPosition maxColumnVp = this.getMaxColumnInsideRange(selectionStartOffset, selectionEndOffset);
                Point maxColumnsPoint = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(maxColumnVp);
                Point selectionStart = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(selectionStartOffset));
                Point selectionEnd = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(selectionEndOffset));
                selectionStart = SwingUtilities.convertPoint(this.myContentComponent, selectionStart, this.myEditorComponent);
                selectionEnd = SwingUtilities.convertPoint(this.myContentComponent, selectionEnd, this.myEditorComponent);
                maxColumnsPoint = SwingUtilities.convertPoint(this.myContentComponent, maxColumnsPoint, this.myEditorComponent);
                this.mySelectionStartY = selectionStart.y;
                this.mySelectionEndY = selectionEnd.y;
                this.myTextRangeMaxColumnX = maxColumnsPoint.x;
            }

            private VisualPosition getMaxColumnInsideRange(int startOffset, int endOffset) {
                int firstLine = FragmentCodeStyleSettingsDialog.this.myDocument.getLineNumber(startOffset);
                int lastLine = FragmentCodeStyleSettingsDialog.this.myDocument.getLineNumber(endOffset);
                VisualPosition positionWithMaxColumn = new VisualPosition(0, 0);
                for (int currentLine = firstLine; currentLine <= lastLine; ++currentLine) {
                    int offset = FragmentCodeStyleSettingsDialog.this.myDocument.getLineEndOffset(currentLine);
                    VisualPosition position = FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(offset);
                    if (position.getColumn() <= positionWithMaxColumn.getColumn()) continue;
                    positionWithMaxColumn = position;
                }
                return positionWithMaxColumn;
            }
        }
    }
}

