/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.ImportSettingsActionKt;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0005\u00031\u0001\u0011$\u0001M\u00013\u0005A\u0012!)\u0002R\u0007\u0005A\u0019!\n\u0005\u0005\u0017!\u0011Q\"\u0001M\u00033\rA1!D\u0001\u0019\b\u0015BA!\u0001\u0005\u0005\u001b\u0005A*!G\u0002\t\n5\t\u0001$B\u0013\u000f\t\u0005AY!\u0004\u0003\n\u0005%\t\u0001T\u0002\r\u00073\u0019Aq!\u0004\u0003\n\u0005%\t\u0001t\u0002\r\u0007K!!\u0011\u0001\u0003\u0005\u000e\u0003a5\u0011d\u0001E\t\u001b\u0005AR!\n\u0005\u0005\u0003!IQ\"\u0002I\n+\ta\t\u0001'\u0004\u0019\u000e\u0001"}, strings={"Lcom/intellij/ide/actions/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doImport", "saveFile", "Ljava/io/File;", "getRelativeNamesToExtract", "", "", "chosenComponents", "Lcom/intellij/ide/actions/ExportableItem;", "presentableFileName", "file", "promptLocationMessage", "kotlin.jvm.PlatformType"}, moduleName="configuration-store-impl")
public final class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ChooseComponentsToExportDialog.chooseSettingsFile(PathManager.getConfigPath(), component, IdeBundle.message((String)"title.import.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.import.file.path", (Object[])new Object[0])).doWhenDone((Consumer)new Consumer<String>(this){
            final /* synthetic */ ImportSettingsAction this$0;

            /*
             * WARNING - void declaration
             */
            public void consume(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                File saveFile = new File(path);
                try {
                    ImportSettingsAction.access$doImport(this.this$0, saveFile);
                }
                catch (ZipException e1) {
                    void $receiver;
                    Object[] objectArray = new Object[3];
                    objectArray[0] = ImportSettingsAction.access$presentableFileName(this.this$0, saveFile);
                    Throwable throwable = e1;
                    int n = 1;
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = objectArray;
                    String string = "error.reading.settings.file";
                    String string2 = $receiver.getMessage();
                    objectArray2[n] = string2;
                    objectArray3[2] = ImportSettingsAction.access$promptLocationMessage(this.this$0);
                    Messages.showErrorDialog((String)IdeBundle.message((String)string, (Object[])objectArray3), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
                }
                catch (IOException e1) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ImportSettingsAction.access$presentableFileName(this.this$0, saveFile);
                    Throwable $receiver = e1;
                    int n = 1;
                    Object[] objectArray4 = objectArray;
                    Object[] objectArray5 = objectArray;
                    String string = "error.reading.settings.file.2";
                    String string3 = $receiver.getMessage();
                    objectArray4[n] = string3;
                    Messages.showErrorDialog((String)IdeBundle.message((String)string, (Object[])objectArray5), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void doImport(File saveFile) {
        String key;
        if (!saveFile.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.find.file", (Object[])new Object[]{this.presentableFileName(saveFile)}), (String)IdeBundle.message((String)"title.file.not.found", (Object[])new Object[0]));
            return;
        }
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(FilesKt.inputStream((File)saveFile));
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{this.presentableFileName(saveFile), this.promptLocationMessage()}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
            return;
        }
        String configPath = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(ExportSettingsActionKt.getExportableComponentsMap$default(false, true, null, relativePaths, 4), false, IdeBundle.message((String)"title.select.components.to.import", (Object[])new Object[0]), IdeBundle.message((String)"prompt.check.components.to.import", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        File tempFile = new File(PathManager.getPluginTempPath(), saveFile.getName());
        FileUtil.copy((File)saveFile, (File)tempFile);
        Set<ExportableItem> set = dialog.getExportableComponents();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"dialog.exportableComponents");
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(set));
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.UnzipCommand(tempFile, new File(configPath), (FilenameFilter)filenameFilter)));
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(tempFile)));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        String string = key = ApplicationManager.getApplication().isRestartCapable() ? "message.settings.imported.successfully.restart" : "message.settings.imported.successfully";
        if (Messages.showOkCancelDialog((String)IdeBundle.message((String)key, (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), ApplicationNamesInfo.getInstance().getFullProductName()}), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
            }
            ((ApplicationEx)application).restart(true);
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<? extends ExportableItem> chosenComponents) {
        THashSet result2 = new THashSet();
        for (ExportableItem exportableItem : chosenComponents) {
            for (File exportFile : exportableItem.getFiles()) {
                String string = FileUtilRt.getRelativePath((File)new File(PathManager.getConfigPath()), (File)exportFile);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                result2.add((Object)FileUtil.toSystemIndependentName((String)string));
            }
        }
        result2.add((Object)"installed.txt");
        return (Set)result2;
    }

    private final String presentableFileName(File file) {
        return "'" + FileUtil.toSystemDependentName((String)file.getPath()) + "'";
    }

    private final String promptLocationMessage() {
        return IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0]);
    }

    public static final /* synthetic */ void access$doImport(ImportSettingsAction $this, @NotNull File saveFile) {
        $this.doImport(saveFile);
    }

    @NotNull
    public static final /* synthetic */ String access$presentableFileName(ImportSettingsAction $this, @NotNull File file) {
        return $this.presentableFileName(file);
    }

    public static final /* synthetic */ String access$promptLocationMessage(ImportSettingsAction $this) {
        return $this.promptLocationMessage();
    }
}

