/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WeighingActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.WeighingActionGroup");
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public void update(AnActionEvent e) {
        this.getDelegate().update(e);
    }

    protected abstract ActionGroup getDelegate();

    private static void getAllChildren(@Nullable AnActionEvent e, ActionGroup group, List<AnAction> result2) {
        for (AnAction action : group.getChildren(e)) {
            if (action == null) {
                LOG.error("Null child for " + group + " of class " + group.getClass());
                continue;
            }
            if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                WeighingActionGroup.getAllChildren(e, (ActionGroup)action, result2);
                continue;
            }
            result2.add(action);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] children = this.getDelegate().getChildren(e);
        if (e == null) {
            if (children == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
            }
            return children;
        }
        ArrayList<AnAction> all = new ArrayList<AnAction>();
        WeighingActionGroup.getAllChildren(e, this.getDelegate(), all);
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action : all) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            presentation.setWeight(0.0);
            Utils.updateGroupChild(e.getDataContext(), e.getPlace(), action, presentation);
            if (!presentation.isEnabled() || !presentation.isVisible()) continue;
            if (presentation.getWeight() > maxWeight) {
                maxWeight = presentation.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action);
        }
        if (heaviest == null) {
            if (children == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
            }
            return children;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action : all) {
            boolean separator = action instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action)) {
                heaviest.add(action);
            }
            if (!heaviest.contains(action)) continue;
            chosen.add(action);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(this.getDelegate(), heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText("Other...");
        AnAction[] anActionArray = new AnAction[]{chosen, new Separator(), other};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    protected boolean shouldBeChosenAnyway(AnAction action) {
        return false;
    }
}

