/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends com.intellij.openapi.diagnostic.Logger {
    private static ApplicationInfoProvider ourApplicationInfoProvider = IdeaLogger.getIdeaInfoProvider();
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static String ourCompilationTimestamp;
    @NonNls
    private static final String COMPILATION_TIMESTAMP_RESOURCE_NAME = "/.compilation-timestamp";
    private final Logger myLogger;

    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    IdeaLogger(Logger logger) {
        this.myLogger = logger;
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        this.myLogger.error((Object)LogMessageEx.createEvent(message, DebugUtil.currentStackTrace(), attachments));
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    public void debug(String message) {
        this.myLogger.debug((Object)message);
    }

    public void debug(Throwable t) {
        this.myLogger.debug((Object)"", t);
    }

    public void debug(@NonNls String message, Throwable t) {
        this.myLogger.debug((Object)message, t);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/idea/IdeaLogger", "error"));
        }
        if (t instanceof ProcessCanceledException) {
            this.myLogger.error((Object)message, new Throwable("Do not log ProcessCanceledException").initCause(t));
            throw (ProcessCanceledException)t;
        }
        if (t != null && t.getClass().getName().contains("ReparsedSuccessfullyException")) {
            this.myLogger.error((Object)new Throwable("Do not log ReparsedSuccessfullyException").initCause(t));
            throw (RuntimeException)t;
        }
        String detailString = StringUtil.join((String[])details, (String)"\n");
        if (ourErrorsOccurred == null) {
            String s = message != null && !message.isEmpty() ? "Error message is '" + message + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (!detailString.isEmpty() ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message + (!detailString.isEmpty() ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    public void info(String message) {
        this.myLogger.info((Object)message);
    }

    public void info(String message, @Nullable Throwable t) {
        this.myLogger.info((Object)message, t);
    }

    public void warn(@NonNls String message, @Nullable Throwable t) {
        this.myLogger.warn((Object)message, t);
    }

    public static void setApplicationInfoProvider(ApplicationInfoProvider aProvider) {
        ourApplicationInfoProvider = aProvider;
    }

    private static ApplicationInfoProvider getIdeaInfoProvider() {
        return new ApplicationInfoProvider(){

            public String getInfo() {
                ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
                return info.getFullApplicationName() + "  " + "Build #" + info.getBuild().asStringWithAllDetails();
            }
        };
    }

    public void setLevel(Level level) {
        this.myLogger.setLevel(level);
    }

    static {
        InputStream stream = com.intellij.openapi.diagnostic.Logger.class.getResourceAsStream(COMPILATION_TIMESTAMP_RESOURCE_NAME);
        if (stream != null) {
            try {
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
                try {
                    String s = reader.readLine();
                    if (s != null) {
                        ourCompilationTimestamp = s.trim();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

