/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchBootJdkAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.SwitchBootJdkAction");
    @NonNls
    private static final String productJdkConfigFileName = ApplicationNamesInfo.getInstance().getScriptName() + ".jdk";
    @NonNls
    private static final File productJdkConfigFile = new File(PathManager.getConfigPath(), productJdkConfigFileName);
    @NonNls
    private static final File customJdkFile = new File(PathManager.getHomePath() + File.separator + "jre" + File.separator + "jdk");
    private static final String STANDARD_JDK_LOCATION_ON_MAC_OS_X = "/Library/Java/JavaVirtualMachines/";
    private static final String STANDARD_JDK_6_LOCATION_ON_MAC_OS_X = "/System/Library/Java/JavaVirtualMachines/";

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!SystemInfo.isMac || !customJdkFile.exists()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setText("Switch Boot JDK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JdkBundleDescriptor> getBundlesFromFile(@NotNull File fileWithBundles) {
        if (fileWithBundles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithBundles", "com/intellij/openapi/util/SwitchBootJdkAction", "getBundlesFromFile"));
        }
        FileInputStream stream = null;
        ArrayList<JdkBundleDescriptor> list = new ArrayList<JdkBundleDescriptor>();
        try {
            String line;
            stream = new FileInputStream(fileWithBundles);
            InputStreamReader inputStream = new InputStreamReader((InputStream)stream, Charset.forName("UTF-8"));
            BufferedReader bufferedReader = new BufferedReader(inputStream);
            while ((line = bufferedReader.readLine()) != null) {
                File file = new File(line);
                if (!file.exists()) continue;
                list.add(new JdkBundleDescriptor(file, file.getName()));
            }
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error reading JDK bundles", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent event) {
        SwitchBootJdkDialog dialog;
        if (!productJdkConfigFile.exists()) {
            try {
                if (!productJdkConfigFile.createNewFile()) {
                    LOG.error("Could not create " + productJdkConfigFileName + " productJdkConfigFile");
                    return;
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        if ((dialog = new SwitchBootJdkDialog(null, SwitchBootJdkAction.getBundlesFromFile(productJdkConfigFile))).showAndGet()) {
            File selectedJdkBundleFile = dialog.getSelectedFile();
            FileWriter fooWriter = null;
            try {
                fooWriter = new FileWriter(productJdkConfigFile, false);
                fooWriter.write(selectedJdkBundleFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    if (fooWriter != null) {
                        fooWriter.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().restart();
        }
    }

    private static class JdkUtil {
        private JdkUtil() {
        }

        private static ArrayList<JdkBundleDescriptor> findJdkPaths() {
            ArrayList<JdkBundleDescriptor> jdk6List;
            ArrayList<JdkBundleDescriptor> jdkPathsList = new ArrayList<JdkBundleDescriptor>();
            if (!SystemInfo.isMac) {
                return jdkPathsList;
            }
            if (customJdkFile.exists()) {
                jdkPathsList.add(new JdkBundleDescriptor(customJdkFile, "JDK bundled with IDE"));
            }
            if ((jdk6List = JdkUtil.jdkBundlesFromLocation(SwitchBootJdkAction.STANDARD_JDK_6_LOCATION_ON_MAC_OS_X, "1.6.0")).isEmpty()) {
                jdkPathsList.addAll(JdkUtil.jdkBundlesFromLocation(SwitchBootJdkAction.STANDARD_JDK_LOCATION_ON_MAC_OS_X, "1.6.0"));
            }
            jdkPathsList.addAll(JdkUtil.jdkBundlesFromLocation(SwitchBootJdkAction.STANDARD_JDK_LOCATION_ON_MAC_OS_X, "jdk1.8.0_(\\d*).jdk"));
            return jdkPathsList;
        }

        private static ArrayList<JdkBundleDescriptor> jdkBundlesFromLocation(String jdkLocationOnMacOsX, String filter) {
            ArrayList<JdkBundleDescriptor> localJdkPathsList = new ArrayList<JdkBundleDescriptor>();
            File standardJdkLocationOnMacFile = new File(jdkLocationOnMacOsX);
            if (!standardJdkLocationOnMacFile.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Location does not exists: " + jdkLocationOnMacOsX);
                }
                return localJdkPathsList;
            }
            File[] filesInStandardJdkLocation = standardJdkLocationOnMacFile.listFiles();
            if (filesInStandardJdkLocation == null) {
                LOG.debug("Some IO  exception happened.");
                return localJdkPathsList;
            }
            int latestUpdateNumber = 0;
            JdkBundleDescriptor latestBundle = null;
            Pattern p = Pattern.compile(filter);
            for (File possibleJdkBundle : filesInStandardJdkLocation) {
                Matcher m = p.matcher(possibleJdkBundle.getName());
                while (m.find()) {
                    try {
                        if (m.groupCount() > 0) {
                            int updateNumber = Integer.parseInt(m.group(1));
                            if (latestUpdateNumber >= updateNumber) continue;
                            latestBundle = new JdkBundleDescriptor(possibleJdkBundle, possibleJdkBundle.getName());
                            continue;
                        }
                        latestBundle = new JdkBundleDescriptor(possibleJdkBundle, possibleJdkBundle.getName());
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Fail parsing update number");
                    }
                }
            }
            if (latestBundle != null) {
                localJdkPathsList.add(latestBundle);
            }
            return localJdkPathsList;
        }
    }

    private static class SwitchBootJdkDialog
    extends DialogWrapper {
        @NotNull
        private final ComboBox myComboBox;

        protected SwitchBootJdkDialog(@Nullable Project project, final List<JdkBundleDescriptor> jdkBundlesList) {
            super(project, false);
            final ArrayList pathsList = JdkUtil.findJdkPaths();
            if (!jdkBundlesList.isEmpty()) {
                JdkBundleDescriptor jdkBundleDescription = jdkBundlesList.get(0);
                pathsList.add(0, jdkBundleDescription);
            }
            this.myComboBox = new ComboBox();
            DefaultComboBoxModel<JdkBundleDescriptor> model = new DefaultComboBoxModel<JdkBundleDescriptor>();
            for (JdkBundleDescriptor jdkBundlePath : pathsList) {
                if (!jdkBundlesList.isEmpty() && jdkBundlePath != null && FileUtil.filesEqual((File)jdkBundlePath.getBundleAsFile(), (File)jdkBundlesList.get(0).getBundleAsFile())) continue;
                model.addElement(jdkBundlePath);
            }
            this.myComboBox.setModel(model);
            if (pathsList.isEmpty()) {
                this.myComboBox.setEnabled(false);
            }
            this.myComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value != null) {
                        JdkBundleDescriptor jdkBundleDescriptor = (JdkBundleDescriptor)value;
                        this.setText(jdkBundleDescriptor.getVisualRepresentation());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Null value has been passed to a cell renderer. Available JDKs count: " + pathsList.size());
                        StringBuilder jdkNames = new StringBuilder();
                        for (JdkBundleDescriptor jdkBundlePath : pathsList) {
                            if (!jdkBundlesList.isEmpty()) continue;
                            jdkNames.append(jdkBundlePath.getVisualRepresentation()).append("; ");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Available JDKs names: " + jdkNames.toString());
                        }
                    }
                }
            });
            this.setTitle("Switch IDE Boot JDK");
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JBLabel("Select Boot JDK");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComboBox;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        public File getSelectedFile() {
            return ((JdkBundleDescriptor)this.myComboBox.getSelectedItem()).bundleAsFile;
        }
    }

    private static class JdkBundleDescriptor {
        private File bundleAsFile;
        private String visualRepresentation;

        public JdkBundleDescriptor(@NotNull File bundleAsFile, @NotNull String visualRepresentation) {
            if (bundleAsFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAsFile", "com/intellij/openapi/util/SwitchBootJdkAction$JdkBundleDescriptor", "<init>"));
            }
            if (visualRepresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visualRepresentation", "com/intellij/openapi/util/SwitchBootJdkAction$JdkBundleDescriptor", "<init>"));
            }
            this.bundleAsFile = bundleAsFile;
            this.visualRepresentation = visualRepresentation;
        }

        public File getBundleAsFile() {
            return this.bundleAsFile;
        }

        public String getVisualRepresentation() {
            return this.visualRepresentation;
        }
    }
}

