/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.diff.impl.IgnoreSpaceEnum;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.highlighting.DiffPanelState;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.FragmentedDiffPanelState;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeOutdatedException;
import com.intellij.openapi.vcs.changes.PreparedFragmentedContent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.BeforeAfter;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesFragmentedDiffPanel
implements Disposable {
    private static final int SHORT_DIFF_DIVIDER_POLYGONS_OFFSET = 2;
    private final JPanel myPanel;
    private final Project myProject;
    private final JComponent myParent;
    private PreparedFragmentedContent myFragmentedContent;
    private final String myFilePath;
    private final VcsConfiguration myConfiguration;
    private DiffPanel myHorizontal;
    private DiffPanel myVertical;
    private boolean myCurrentHorizontal;
    private JPanel myTopPanel;
    private List<Integer> myLeftLines;
    private final MyNextDiffAction myNextDiff;
    private final MyPreviousDiffAction myPreviousDiff;
    private final JLabel myTitleLabel;
    private PresentationState myPresentationState;
    private DumbAwareAction myNavigateAction;
    private static final Icon ourIcon = PlatformIcons.CHECK_ICON;
    private static final int[] ourMarks = new int[]{1, 2, 4, 8, -1};
    public static final Hashtable<Integer, JComponent> LABELS = new Hashtable();
    public static final int ALL_VALUE = 5;

    public ChangesFragmentedDiffPanel(Project project, String filePath, JComponent parent) {
        this.myProject = project;
        this.myParent = parent;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myFilePath = filePath;
        this.myPanel = new JPanel(new BorderLayout());
        this.myNextDiff = new MyNextDiffAction();
        this.myPreviousDiff = new MyPreviousDiffAction();
        this.myTitleLabel = new JLabel(this.myFilePath);
    }

    public void dispose() {
        this.myPanel.removeAll();
        this.myHorizontal = null;
        this.myVertical = null;
        this.myPreviousDiff.unregisterCustomShortcutSet(this.myParent);
        this.myNextDiff.unregisterCustomShortcutSet(this.myParent);
    }

    public void buildUi() {
        this.myTopPanel = new JPanel(new BorderLayout());
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BorderLayout());
        this.myTitleLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 0, 0));
        wrapper.add((Component)this.myTitleLabel, "West");
        DefaultActionGroup dag = new DefaultActionGroup();
        this.myPreviousDiff.copyShortcutFrom(ActionManager.getInstance().getAction("PreviousDiff"));
        this.myNextDiff.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        dag.add((AnAction)new MyChangeContextAction());
        dag.add((AnAction)this.myPreviousDiff);
        dag.add((AnAction)this.myNextDiff);
        this.createNavigateAction();
        dag.add((AnAction)this.myNavigateAction);
        this.myPreviousDiff.registerCustomShortcutSet(this.myPreviousDiff.getShortcutSet(), this.myPanel);
        this.myNextDiff.registerCustomShortcutSet(this.myNextDiff.getShortcutSet(), this.myPanel);
        dag.add((AnAction)new PopupAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)dag, true);
        wrapper.add((Component)toolbar.getComponent(), "East");
        this.myTopPanel.add((Component)wrapper, "Center");
        JPanel wrapperDiffs = new JPanel(new GridBagLayout());
        JPanel oneMore = new JPanel(new BorderLayout());
        oneMore.add((Component)wrapperDiffs, "North");
        this.myCurrentHorizontal = this.myConfiguration.SHORT_DIFF_HORIZONTALLY;
        this.myHorizontal = this.createPanel(true);
        this.myVertical = this.createPanel(false);
        this.myPanel.add((Component)this.myTopPanel, "North");
        this.myPanel.add((Component)this.getCurrentPanel().getComponent(), "Center");
        this.myPreviousDiff.registerCustomShortcutSet(this.myPreviousDiff.getShortcutSet(), this.myParent);
        this.myNextDiff.registerCustomShortcutSet(this.myNextDiff.getShortcutSet(), this.myParent);
    }

    private void createNavigateAction() {
        this.myNavigateAction = new DumbAwareAction("Edit Source", "Edit Source", AllIcons.Actions.EditSource){

            @Nullable
            private OpenFileDescriptor createDescriptor() {
                int correctLine;
                int column;
                if (ChangesFragmentedDiffPanel.this.myFragmentedContent == null || ChangesFragmentedDiffPanel.this.myFragmentedContent.getFile() == null) {
                    return null;
                }
                DiffPanel panel = ChangesFragmentedDiffPanel.this.myCurrentHorizontal ? ChangesFragmentedDiffPanel.this.myHorizontal : ChangesFragmentedDiffPanel.this.myVertical;
                DiffSideView side = ((DiffPanelImpl)panel).getCurrentSide();
                if (side == null || side.getEditor() == null) {
                    return null;
                }
                boolean isAfter = FragmentSide.SIDE2.equals((Object)side.getSide());
                if (isAfter) {
                    LogicalPosition position = side.getEditor().getCaretModel().getLogicalPosition();
                    int line = position.line;
                    int converted = ChangesFragmentedDiffPanel.this.myFragmentedContent.getNewConvertor().execute(line);
                    return new OpenFileDescriptor(ChangesFragmentedDiffPanel.this.myProject, ChangesFragmentedDiffPanel.this.myFragmentedContent.getFile(), converted, position.column);
                }
                if (((DiffPanelImpl)panel).getEditor1().getDocument().getTextLength() == 0) {
                    return new OpenFileDescriptor(ChangesFragmentedDiffPanel.this.myProject, ChangesFragmentedDiffPanel.this.myFragmentedContent.getFile(), 0);
                }
                CaretModel model = side.getEditor().getCaretModel();
                FragmentList fragments = ((DiffPanelImpl)panel).getFragments();
                int line = model.getLogicalPosition().line;
                int offset = model.getOffset();
                BeforeAfter<Integer> current = null;
                List<BeforeAfter<Integer>> ranges = ChangesFragmentedDiffPanel.this.myFragmentedContent.getLineRanges();
                for (BeforeAfter<Integer> range : ranges) {
                    if ((Integer)range.getBefore() > line) break;
                    current = range;
                }
                if (current == null) {
                    return null;
                }
                Fragment at = fragments.getFragmentAt(offset, FragmentSide.SIDE1, Conditions.alwaysTrue());
                if (at == null) {
                    return null;
                }
                TextRange opposite = at.getRange(FragmentSide.SIDE2);
                int lineInNew = ((DiffPanelImpl)panel).getEditor2().getDocument().getLineNumber(opposite.getStartOffset());
                if (at.getType() == null || TextDiffTypeEnum.NONE.equals((Object)at.getType())) {
                    column = model.getLogicalPosition().column;
                    int startIn1 = ((DiffPanelImpl)panel).getEditor1().getDocument().getLineNumber(at.getRange(FragmentSide.SIDE1).getStartOffset());
                    correctLine = lineInNew + line - startIn1;
                } else {
                    column = 0;
                    correctLine = Math.max(lineInNew, (Integer)current.getAfter());
                }
                int converted = ChangesFragmentedDiffPanel.this.myFragmentedContent.getNewConvertor().execute(correctLine);
                return new OpenFileDescriptor(ChangesFragmentedDiffPanel.this.myProject, ChangesFragmentedDiffPanel.this.myFragmentedContent.getFile(), converted, column);
            }

            public void actionPerformed(AnActionEvent e) {
                if (!this.getEnabled()) {
                    return;
                }
                final OpenFileDescriptor descriptor = this.createDescriptor();
                if (descriptor == null) {
                    return;
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManager.getInstance((Project)ChangesFragmentedDiffPanel.this.myProject).openTextEditor(descriptor, true);
                    }
                };
                if (ModalityState.NON_MODAL.equals(ModalityState.current())) {
                    runnable.run();
                } else {
                    DialogWrapper wrapper;
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    if (window instanceof DialogWrapperDialog && (wrapper = ((DialogWrapperDialog)window).getDialogWrapper()) != null) {
                        wrapper.doCancelAction();
                        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, ChangesFragmentedDiffPanel.this.myProject.getDisposed());
                    }
                }
            }

            public void update(AnActionEvent e) {
                super.update(e);
                boolean enabled = this.getEnabled();
                e.getPresentation().setEnabled(enabled);
            }

            private boolean getEnabled() {
                DiffPanel panel;
                DiffPanel diffPanel = panel = ChangesFragmentedDiffPanel.this.myCurrentHorizontal ? ChangesFragmentedDiffPanel.this.myHorizontal : ChangesFragmentedDiffPanel.this.myVertical;
                if (panel == null) {
                    return false;
                }
                DiffSideView side = ((DiffPanelImpl)panel).getCurrentSide();
                return side != null && side.getEditor() != null;
            }
        };
    }

    public void setTitle(String filePath) {
        this.myTitleLabel.setText(filePath);
    }

    public void refreshData(PreparedFragmentedContent fragmentedContent) {
        FragmentedEditorHighlighter ah;
        this.myPresentationState = new PresentationState(this.myConfiguration, this.myCurrentHorizontal);
        this.myFragmentedContent = fragmentedContent;
        boolean navigationEnabled = !this.myFragmentedContent.isOneSide();
        this.myNextDiff.setEnabled(navigationEnabled);
        this.myPreviousDiff.setEnabled(navigationEnabled);
        this.adjustPanelData((DiffPanelImpl)this.myHorizontal);
        this.adjustPanelData((DiffPanelImpl)this.myVertical);
        if (((DiffPanelImpl)this.myHorizontal).getEditor1() != null) {
            this.myNavigateAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), ((DiffPanelImpl)this.myHorizontal).getEditor1().getComponent());
            this.myNavigateAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), ((DiffPanelImpl)this.myVertical).getEditor1().getComponent());
        }
        if (((DiffPanelImpl)this.myHorizontal).getEditor2() != null) {
            this.myNavigateAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), ((DiffPanelImpl)this.myHorizontal).getEditor2().getComponent());
            this.myNavigateAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), ((DiffPanelImpl)this.myVertical).getEditor2().getComponent());
        }
        DiffPanel currentPanel = this.getCurrentPanel();
        FragmentedDiffPanelState state = (FragmentedDiffPanelState)((DiffPanelImpl)currentPanel).getDiffPanelState();
        this.myTitleLabel.setText(this.titleText((DiffPanelImpl)currentPanel));
        this.myLeftLines = state.getLeftLines();
        EditorEx hEditor1 = (EditorEx)((DiffPanelImpl)this.myHorizontal).getEditor1();
        EditorEx vEditor1 = (EditorEx)((DiffPanelImpl)this.myVertical).getEditor1();
        EditorEx hEditor2 = (EditorEx)((DiffPanelImpl)this.myHorizontal).getEditor2();
        EditorEx vEditor2 = (EditorEx)((DiffPanelImpl)this.myVertical).getEditor2();
        assert (hEditor1 != null);
        assert (vEditor1 != null);
        assert (hEditor2 != null);
        assert (vEditor2 != null);
        FragmentedEditorHighlighter bh = fragmentedContent.getBeforeHighlighter();
        if (bh != null) {
            hEditor1.setHighlighter((EditorHighlighter)bh);
            vEditor1.setHighlighter((EditorHighlighter)bh);
        }
        if ((ah = fragmentedContent.getAfterHighlighter()) != null) {
            hEditor2.setHighlighter((EditorHighlighter)ah);
            vEditor2.setHighlighter((EditorHighlighter)ah);
        }
        if (((DiffPanelImpl)currentPanel).getEditor1() != null) {
            this.highlightTodo(true, fragmentedContent.getBeforeTodoRanges());
        }
        if (((DiffPanelImpl)currentPanel).getEditor2() != null) {
            this.highlightTodo(false, fragmentedContent.getAfterTodoRanges());
        }
        if (fragmentedContent.getFileType() != null && this.myProject != null && !this.myProject.isDisposed()) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)this.myProject);
            int tabSize = codeStyleFacade.getTabSize(fragmentedContent.getFileType());
            boolean useTabCharacter = codeStyleFacade.useTabCharacter(fragmentedContent.getFileType());
            hEditor1.getSettings().setTabSize(tabSize);
            vEditor1.getSettings().setTabSize(tabSize);
            hEditor2.getSettings().setTabSize(tabSize);
            vEditor2.getSettings().setTabSize(tabSize);
            hEditor1.getSettings().setUseTabCharacter(useTabCharacter);
            vEditor1.getSettings().setUseTabCharacter(useTabCharacter);
            hEditor2.getSettings().setUseTabCharacter(useTabCharacter);
            vEditor2.getSettings().setUseTabCharacter(useTabCharacter);
        }
        this.ensurePresentation();
        this.softWraps(this.myConfiguration.SOFT_WRAPS_IN_SHORT_DIFF);
    }

    private void softWraps(boolean value) {
        DiffPanel currentPanel = this.getCurrentPanel();
        if (((DiffPanelImpl)currentPanel).getEditor1() != null) {
            ((DiffPanelImpl)this.myHorizontal).getEditor1().getSettings().setUseSoftWraps(value);
            ((DiffPanelImpl)this.myVertical).getEditor1().getSettings().setUseSoftWraps(value);
        }
        if (((DiffPanelImpl)currentPanel).getEditor2() != null) {
            ((DiffPanelImpl)this.myHorizontal).getEditor2().getSettings().setUseSoftWraps(value);
            ((DiffPanelImpl)this.myVertical).getEditor2().getSettings().setUseSoftWraps(value);
        }
    }

    private void highlightTodo(boolean left, List<Pair<TextRange, TextAttributes>> todoRanges) {
        FragmentedDiffPanelState panelState = (FragmentedDiffPanelState)((DiffPanelImpl)this.myHorizontal).getDiffPanelState();
        FragmentedDiffPanelState panelState2 = (FragmentedDiffPanelState)((DiffPanelImpl)this.myVertical).getDiffPanelState();
        for (Pair<TextRange, TextAttributes> range : todoRanges) {
            TextAttributes second = ((TextAttributes)range.getSecond()).clone();
            panelState.addRangeHighlighter(left, ((TextRange)range.getFirst()).getStartOffset(), ((TextRange)range.getFirst()).getEndOffset(), second);
            panelState2.addRangeHighlighter(left, ((TextRange)range.getFirst()).getStartOffset(), ((TextRange)range.getFirst()).getEndOffset(), second);
        }
    }

    private String titleText(DiffPanelImpl diffPanel) {
        return this.myFilePath + " " + diffPanel.getNumDifferencesText();
    }

    private void adjustPanelData(DiffPanelImpl diffPanel) {
        FragmentedDiffPanelState diffPanelState = (FragmentedDiffPanelState)diffPanel.getDiffPanelState();
        diffPanelState.setRanges(this.myFragmentedContent.getLineRanges());
        diffPanel.setContents(this.myFragmentedContent.createBeforeContent(), this.myFragmentedContent.createAfterContent());
        diffPanel.setLineNumberConvertors(this.myFragmentedContent.getOldConvertor(), this.myFragmentedContent.getNewConvertor());
        diffPanel.prefferedSizeByContents(-1);
    }

    private DiffPanel createPanel(final boolean horizontal) {
        DiffPanelImpl diffPanel = new DiffPanelImpl(null, this.myProject, false, horizontal, 2, null){

            @Override
            protected DiffPanelState createDiffPanelState(@NotNull Disposable parentDisposable) {
                if (parentDisposable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/changes/ChangesFragmentedDiffPanel$2", "createDiffPanelState"));
                }
                return new FragmentedDiffPanelState(this, ChangesFragmentedDiffPanel.this.myProject, this.getDiffDividerPolygonsOffset(), !horizontal, parentDisposable);
            }
        };
        diffPanel.enableToolbar(false);
        diffPanel.removeStatusBar();
        DiffPanelOptions o = ((DiffPanelEx)diffPanel).getOptions();
        o.setRequestFocusOnNewContent(false);
        Disposer.register((Disposable)this, (Disposable)diffPanel);
        return diffPanel;
    }

    public void away() {
        this.myPreviousDiff.unregisterCustomShortcutSet(this.myParent);
        this.myNextDiff.unregisterCustomShortcutSet(this.myParent);
    }

    public void refreshPresentation() {
        PresentationState current = new PresentationState(this.myConfiguration, this.myCurrentHorizontal);
        if (this.myFragmentedContent != null && !Comparing.equal((Object)this.myPresentationState, (Object)current)) {
            this.recalculatePresentation();
        } else {
            this.ensurePresentation();
        }
        this.myPreviousDiff.registerCustomShortcutSet(this.myPreviousDiff.getShortcutSet(), this.myParent);
        this.myNextDiff.registerCustomShortcutSet(this.myNextDiff.getShortcutSet(), this.myParent);
    }

    private void ensurePresentation() {
        if (this.myCurrentHorizontal != this.myConfiguration.SHORT_DIFF_HORIZONTALLY) {
            DiffPanel panel = this.getCurrentPanel();
            this.myPanel.removeAll();
            this.myPanel.add((Component)this.myTopPanel, "North");
            this.myPanel.add((Component)panel.getComponent(), "Center");
            this.myPanel.revalidate();
            this.myPanel.repaint();
            this.myCurrentHorizontal = this.myConfiguration.SHORT_DIFF_HORIZONTALLY;
        }
    }

    private DiffPanel getCurrentPanel() {
        DiffPanel panel = this.myConfiguration.SHORT_DIFF_HORIZONTALLY ? this.myHorizontal : this.myVertical;
        return panel;
    }

    private int getCurrentLogicalLineIdx(boolean forward) {
        assert (!this.myLeftLines.isEmpty());
        BeforeAfter<Integer> editorLines = this.getEditorLines();
        if (forward) {
            Integer line = (Integer)editorLines.getAfter();
            if (line >= this.myLeftLines.get(this.myLeftLines.size() - 1)) {
                return this.myLeftLines.size() - 1;
            }
            for (int i = this.myLeftLines.size() - 1; i >= 0; --i) {
                Integer integer = this.myLeftLines.get(i);
                if (integer > line) continue;
                return i;
            }
            return 0;
        }
        Integer line = (Integer)editorLines.getBefore();
        if (line <= this.myLeftLines.get(0)) {
            return 0;
        }
        for (int i = 0; i < this.myLeftLines.size(); ++i) {
            Integer integer = this.myLeftLines.get(i);
            if (integer < line) continue;
            return i;
        }
        return this.myLeftLines.size() - 1;
    }

    private BeforeAfter<Integer> getEditorLines() {
        Editor editor = ((DiffPanelImpl)this.getCurrentPanel()).getEditor1();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int offset = editor.getScrollingModel().getVerticalScrollOffset();
        int leftPixels = offset % editor.getLineHeight();
        Point start = visibleArea.getLocation();
        LogicalPosition startLp = editor.xyToLogicalPosition(start);
        Point location = new Point(start.x + visibleArea.width, start.y + visibleArea.height);
        LogicalPosition lp = editor.xyToLogicalPosition(location);
        int curStartLine = startLp.line == editor.getDocument().getLineCount() - 1 ? startLp.line : startLp.line + 1;
        int cutEndLine = lp.line == 0 ? 0 : lp.line - 1;
        boolean commonPartOk = leftPixels == 0 || startLp.line == lp.line;
        return new BeforeAfter((Object)(commonPartOk && EditorUtil.getSoftWrapCountAfterLineStart(editor, startLp) == 0 ? startLp.line : curStartLine), (Object)(commonPartOk && EditorUtil.getSoftWrapCountAfterLineStart(editor, lp) == 0 ? lp.line : cutEndLine));
    }

    private static JLabel markLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(UIUtil.getLabelFont());
        return label;
    }

    private void recalculatePresentation() {
        this.myFragmentedContent.recalculate();
        this.refreshData(this.myFragmentedContent);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    static {
        LABELS.put(1, ChangesFragmentedDiffPanel.markLabel("1"));
        LABELS.put(2, ChangesFragmentedDiffPanel.markLabel("2"));
        LABELS.put(3, ChangesFragmentedDiffPanel.markLabel("4"));
        LABELS.put(4, ChangesFragmentedDiffPanel.markLabel("8"));
        LABELS.put(5, ChangesFragmentedDiffPanel.markLabel("All"));
    }

    private class MyNextDiffAction
    extends DumbAwareAction {
        private boolean myEnabled;

        private MyNextDiffAction() {
            super("Next Change", "Next Change", AllIcons.Actions.NextOccurence);
        }

        public void actionPerformed(AnActionEvent e) {
            int currentLogicalLineIdx = ChangesFragmentedDiffPanel.this.getCurrentLogicalLineIdx(true);
            int nextLineIdx = currentLogicalLineIdx == ChangesFragmentedDiffPanel.this.myLeftLines.size() - 1 ? currentLogicalLineIdx : currentLogicalLineIdx + 1;
            DiffPanelImpl panel = (DiffPanelImpl)ChangesFragmentedDiffPanel.this.getCurrentPanel();
            panel.getSideView(FragmentSide.SIDE1).scrollToFirstDiff((Integer)ChangesFragmentedDiffPanel.this.myLeftLines.get(nextLineIdx));
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }

    private class MyPreviousDiffAction
    extends DumbAwareAction {
        private boolean myEnabled;

        private MyPreviousDiffAction() {
            super("Previous Change", "Previous Change", AllIcons.Actions.PreviousOccurence);
        }

        public void actionPerformed(AnActionEvent e) {
            int currentLogicalLineIdx = ChangesFragmentedDiffPanel.this.getCurrentLogicalLineIdx(false);
            int nextLineIdx = currentLogicalLineIdx == 0 ? 0 : currentLogicalLineIdx - 1;
            DiffPanelImpl panel = (DiffPanelImpl)ChangesFragmentedDiffPanel.this.getCurrentPanel();
            panel.getSideView(FragmentSide.SIDE1).scrollToFirstDiff((Integer)ChangesFragmentedDiffPanel.this.myLeftLines.get(nextLineIdx));
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }

    private class MyChangeContextAction
    extends DumbAwareAction {
        private MyChangeContextAction() {
            super("More/Less Lines...", "More/Less Lines...", AllIcons.Actions.Expandall);
        }

        public void actionPerformed(AnActionEvent e) {
            JPanel result2 = new JPanel(new BorderLayout());
            JLabel label = new JLabel("Lines around:");
            label.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
            JPanel wrapper = new JPanel(new BorderLayout());
            wrapper.add((Component)label, "North");
            result2.add((Component)wrapper, "West");
            final JSlider slider = new JSlider(0, 1, 5, 1);
            slider.setMinorTickSpacing(1);
            slider.setPaintTicks(true);
            slider.setPaintTrack(true);
            slider.setSnapToTicks(true);
            UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
            slider.setPaintLabels(true);
            slider.setLabelTable(LABELS);
            result2.add((Component)slider, "Center");
            final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)ChangesFragmentedDiffPanel.this.myProject);
            for (int i = 0; i < ourMarks.length; ++i) {
                int mark = ourMarks[i];
                if (mark != configuration.SHORT_DIFF_EXTRA_LINES) continue;
                slider.setValue(i + 1);
            }
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)result2, (JComponent)slider).createPopup();
            popup.setFinalRunnable(new Runnable(){

                @Override
                public void run() {
                    int value = slider.getModel().getValue();
                    if (configuration.SHORT_DIFF_EXTRA_LINES != ourMarks[value - 1]) {
                        configuration.SHORT_DIFF_EXTRA_LINES = ourMarks[value - 1];
                        try {
                            ChangesFragmentedDiffPanel.this.recalculatePresentation();
                        }
                        catch (ChangeOutdatedException changeOutdatedException) {
                            // empty catch block
                        }
                    }
                }
            });
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                int width = result2.getPreferredSize().width;
                MouseEvent inputEvent1 = (MouseEvent)inputEvent;
                Point point1 = new Point(inputEvent1.getX() - width / 2, inputEvent1.getY());
                RelativePoint point = new RelativePoint(inputEvent1.getComponent(), point1);
                popup.show(point);
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }
    }

    private class MyUseSoftWrapsAction
    extends ToggleAction
    implements DumbAware {
        private final Icon myIcon;

        private MyUseSoftWrapsAction() {
            super("Use soft wraps", "", ourIcon);
            this.myIcon = ourIcon;
        }

        public boolean isSelected(AnActionEvent e) {
            return ((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SOFT_WRAPS_IN_SHORT_DIFF;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SOFT_WRAPS_IN_SHORT_DIFF = state;
            ChangesFragmentedDiffPanel.this.softWraps(((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SOFT_WRAPS_IN_SHORT_DIFF);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setIcon(((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SOFT_WRAPS_IN_SHORT_DIFF ? this.myIcon : null);
        }
    }

    private class PopupAction
    extends DumbAwareAction {
        private final AnAction myUsual;
        private final AnAction myNumbered;
        private final MyUseSoftWrapsAction mySoftWrapsAction;

        private PopupAction() {
            super("Settings", "Settings", AllIcons.General.SecondaryGroup);
            this.myUsual = new AnAction("Top | Bottom", "", AllIcons.General.Mdot_empty){

                public void actionPerformed(AnActionEvent e) {
                    ((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SHORT_DIFF_HORIZONTALLY = false;
                    ChangesFragmentedDiffPanel.this.ensurePresentation();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SHORT_DIFF_HORIZONTALLY ? AllIcons.General.Mdot_empty : AllIcons.General.Mdot);
                }
            };
            this.myNumbered = new AnAction("Left | Right", "", AllIcons.General.Mdot_empty){

                public void actionPerformed(AnActionEvent e) {
                    ((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SHORT_DIFF_HORIZONTALLY = true;
                    ChangesFragmentedDiffPanel.this.ensurePresentation();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(((ChangesFragmentedDiffPanel)ChangesFragmentedDiffPanel.this).myConfiguration.SHORT_DIFF_HORIZONTALLY ? AllIcons.General.Mdot : AllIcons.General.Mdot_empty);
                }
            };
            this.mySoftWrapsAction = new MyUseSoftWrapsAction();
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultActionGroup dag = new DefaultActionGroup();
            dag.add(this.myUsual);
            dag.add(this.myNumbered);
            dag.add((AnAction)new Separator());
            dag.add((AnAction)this.mySoftWrapsAction);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)dag, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            if (e.getInputEvent() instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }
    }

    private static class PresentationState {
        private final IgnoreSpaceEnum myIgnoreSpace;
        private final boolean myHorizontal;
        private final int myContextLines;
        private final boolean mySoftWraps;

        private PresentationState(@NotNull VcsConfiguration configuration, boolean currentHorizontal) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/openapi/vcs/changes/ChangesFragmentedDiffPanel$PresentationState", "<init>"));
            }
            this.myIgnoreSpace = configuration.SHORT_DIFF_IGNORE_SPACE;
            this.myHorizontal = currentHorizontal;
            this.myContextLines = configuration.SHORT_DIFF_EXTRA_LINES;
            this.mySoftWraps = configuration.SOFT_WRAPS_IN_SHORT_DIFF;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PresentationState that = (PresentationState)o;
            if (this.myContextLines != that.myContextLines) {
                return false;
            }
            if (this.myHorizontal != that.myHorizontal) {
                return false;
            }
            if (this.mySoftWraps != that.mySoftWraps) {
                return false;
            }
            return this.myIgnoreSpace == that.myIgnoreSpace;
        }

        public int hashCode() {
            int result2 = this.myIgnoreSpace != null ? this.myIgnoreSpace.hashCode() : 0;
            result2 = 31 * result2 + (this.myHorizontal ? 1 : 0);
            result2 = 31 * result2 + this.myContextLines;
            result2 = 31 * result2 + (this.mySoftWraps ? 1 : 0);
            return result2;
        }
    }
}

