/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserManyUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    @NonNls
    public static final String ROOT_NODE_VALUE = "root";
    public static final String LOCALLY_DELETED_NODE = VcsBundle.message((String)"changes.nodetitle.locally.deleted.files", (Object[])new Object[0]);
    private final Project myProject;
    private final boolean showFlatten;
    private DefaultTreeModel model;
    private final ChangesBrowserNode root;
    private boolean myPolicyInitialized;
    private ChangesGroupingPolicy myPolicy;
    private HashMap<String, ChangesBrowserNode> myFoldersCache;

    public TreeModelBuilder(Project project, boolean showFlatten) {
        this.myProject = project;
        this.showFlatten = showFlatten;
        this.root = ChangesBrowserNode.create(this.myProject, ROOT_NODE_VALUE);
        this.model = new DefaultTreeModel(this.root);
        this.myFoldersCache = new HashMap();
    }

    public DefaultTreeModel buildModel(List<Change> changes, final ChangeNodeDecorator changeNodeDecorator) {
        Collections.sort(changes, MyChangePathLengthComparator.getInstance());
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (final Change change : changes) {
            this.insertChangeNode(change, policy, this.root, new Computable<ChangesBrowserNode>(){

                public ChangesBrowserNode compute() {
                    return new ChangesBrowserChangeNode(TreeModelBuilder.this.myProject, change, changeNodeDecorator);
                }
            });
        }
        TreeModelBuilder.collapseDirectories(this.model, this.root);
        this.sortNodes();
        return this.model;
    }

    @Nullable
    private ChangesGroupingPolicy createGroupingPolicy() {
        if (!this.myPolicyInitialized) {
            this.myPolicyInitialized = true;
            ChangesGroupingPolicyFactory factory = ChangesGroupingPolicyFactory.getInstance(this.myProject);
            if (factory != null) {
                this.myPolicy = factory.createGroupingPolicy(this.model);
            }
        }
        return this.myPolicy;
    }

    public DefaultTreeModel buildModelFromFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModelFromFiles"));
        }
        this.buildVirtualFiles(files, null);
        TreeModelBuilder.collapseDirectories(this.model, this.root);
        this.sortNodes();
        return this.model;
    }

    public DefaultTreeModel buildModelFromFilePaths(Collection<FilePath> files) {
        this.buildFilePaths(files, this.root);
        TreeModelBuilder.collapseDirectories(this.model, this.root);
        this.sortNodes();
        return this.model;
    }

    public DefaultTreeModel buildModel(List<? extends ChangeList> changeLists, Trinity<List<VirtualFile>, Integer, Integer> unversionedFiles, List<LocallyDeletedChange> locallyDeletedFiles, List<VirtualFile> modifiedWithoutEditing, MultiMap<String, VirtualFile> switchedFiles, @Nullable Map<VirtualFile, String> switchedRoots, @Nullable List<VirtualFile> ignoredFiles, @Nullable List<VirtualFile> lockedFolders, @Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        boolean manyUnversioned;
        this.resetGrouping();
        this.buildModel(changeLists);
        if (!modifiedWithoutEditing.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        }
        boolean bl = manyUnversioned = (Integer)unversionedFiles.getSecond() > ((List)unversionedFiles.getFirst()).size();
        if (manyUnversioned || !((List)unversionedFiles.getFirst()).isEmpty()) {
            this.resetGrouping();
            if (manyUnversioned) {
                ChangesBrowserManyUnversionedFilesNode baseNode = new ChangesBrowserManyUnversionedFilesNode(this.myProject, (Integer)unversionedFiles.getSecond(), (Integer)unversionedFiles.getThird());
                this.model.insertNodeInto(baseNode, this.root, this.root.getChildCount());
            } else {
                this.buildVirtualFiles((List)unversionedFiles.getFirst(), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
            }
        }
        if (switchedRoots != null && !switchedRoots.isEmpty()) {
            this.resetGrouping();
            this.buildSwitchedRoots(switchedRoots);
        }
        if (!switchedFiles.isEmpty()) {
            this.resetGrouping();
            this.buildSwitchedFiles(switchedFiles);
        }
        if (ignoredFiles != null && !ignoredFiles.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(ignoredFiles, ChangesBrowserNode.IGNORED_FILES_TAG);
        }
        if (lockedFolders != null && !lockedFolders.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(lockedFolders, ChangesBrowserNode.LOCKED_FOLDERS_TAG);
        }
        if (logicallyLockedFiles != null && !logicallyLockedFiles.isEmpty()) {
            this.resetGrouping();
            this.buildLogicallyLockedFiles(logicallyLockedFiles);
        }
        if (!locallyDeletedFiles.isEmpty()) {
            this.resetGrouping();
            ChangesBrowserNode locallyDeletedNode = ChangesBrowserNode.create(this.myProject, LOCALLY_DELETED_NODE);
            this.model.insertNodeInto(locallyDeletedNode, this.root, this.root.getChildCount());
            this.buildLocallyDeletedPaths(locallyDeletedFiles, locallyDeletedNode);
        }
        TreeModelBuilder.collapseDirectories(this.model, this.root);
        this.sortNodes();
        return this.model;
    }

    private void resetGrouping() {
        this.myFoldersCache = new HashMap();
        this.myPolicyInitialized = false;
    }

    public DefaultTreeModel buildModel(@NotNull List<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        for (ChangeList changeList : changeLists) {
            ArrayList changes = new ArrayList(changeList.getChanges());
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
            this.model.insertNodeInto(listNode, this.root, 0);
            this.resetGrouping();
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            int i = 0;
            Collections.sort(changes, MyChangePathLengthComparator.getInstance());
            for (final Change change : changes) {
                final MyChangeNodeUnderChangeListDecorator decorator = new MyChangeNodeUnderChangeListDecorator(revisionsCache, new ChangeListRemoteState.Reporter(i, listRemoteState));
                this.insertChangeNode(change, policy, listNode, new Computable<ChangesBrowserNode>(){

                    public ChangesBrowserNode compute() {
                        return new ChangesBrowserChangeNode(TreeModelBuilder.this.myProject, change, decorator);
                    }
                });
                ++i;
            }
        }
        return this.model;
    }

    private void buildVirtualFiles(@NotNull List<VirtualFile> files, @Nullable Object tag) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildVirtualFiles"));
        }
        ChangesBrowserNode baseNode = this.createNode(tag);
        this.insertFilesIntoNode(files, baseNode);
    }

    private ChangesBrowserNode createNode(Object tag) {
        ChangesBrowserNode baseNode;
        if (tag != null) {
            baseNode = ChangesBrowserNode.create(this.myProject, tag);
            this.model.insertNodeInto(baseNode, this.root, this.root.getChildCount());
        } else {
            baseNode = this.root;
        }
        return baseNode;
    }

    private void insertFilesIntoNode(@NotNull List<VirtualFile> files, ChangesBrowserNode baseNode) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertFilesIntoNode"));
        }
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        Collections.sort(files, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file : files) {
            this.insertChangeNode(file, policy, baseNode, this.defaultNodeCreator(file));
        }
    }

    private void buildLocallyDeletedPaths(Collection<LocallyDeletedChange> locallyDeletedChanges, ChangesBrowserNode baseNode) {
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (LocallyDeletedChange change : locallyDeletedChanges) {
            StaticFilePath key = new StaticFilePath(false, change.getPresentableUrl(), change.getPath().getVirtualFile());
            ChangesBrowserNode oldNode = this.myFoldersCache.get(key.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(change);
            ChangesBrowserNode parent = this.getParentNodeFor(key, policy, baseNode);
            this.model.insertNodeInto(node, parent, parent.getChildCount());
            this.myFoldersCache.put(key.getKey(), node);
        }
    }

    private void buildFilePaths(Collection<FilePath> filePaths, ChangesBrowserNode baseNode) {
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (FilePath file : filePaths) {
            assert (file != null);
            String path = file.getPath();
            StaticFilePath pathKey = !FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path) ? new StaticFilePath(false, path, null) : new StaticFilePath(false, new File(file.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), file.getVirtualFile());
            ChangesBrowserNode oldNode = this.myFoldersCache.get(pathKey.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(this.myProject, file);
            ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, policy, baseNode);
            this.model.insertNodeInto(node, parentNode, 0);
            this.myFoldersCache.put(pathKey.getKey(), node);
        }
    }

    private void buildSwitchedRoots(Map<VirtualFile, String> switchedRoots) {
        ChangesBrowserNode rootsHeadNode = ChangesBrowserNode.create(this.myProject, ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        this.model.insertNodeInto(rootsHeadNode, this.root, this.root.getChildCount());
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(switchedRoots.keySet());
        Collections.sort(files, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            final Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, policy, rootsHeadNode, new Computable<ChangesBrowserNode>(){

                public ChangesBrowserNode compute() {
                    return new ChangesBrowserChangeNode(TreeModelBuilder.this.myProject, change, new ChangeNodeDecorator(){

                        @Override
                        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
                        }

                        @Override
                        public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
                            return null;
                        }

                        @Override
                        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                            renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                        }
                    });
                }
            });
        }
    }

    private void buildSwitchedFiles(MultiMap<String, VirtualFile> switchedFiles) {
        ChangesBrowserNode baseNode = ChangesBrowserNode.create(this.myProject, ChangesBrowserNode.SWITCHED_FILES_TAG);
        this.model.insertNodeInto(baseNode, this.root, this.root.getChildCount());
        for (String branchName : switchedFiles.keySet()) {
            ArrayList switchedFileList = new ArrayList(switchedFiles.get((Object)branchName));
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.create(this.myProject, branchName);
            this.model.insertNodeInto(branchNode, baseNode, baseNode.getChildCount());
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            Collections.sort(switchedFileList, VirtualFileHierarchicalComparator.getInstance());
            for (VirtualFile file : switchedFileList) {
                this.insertChangeNode(file, policy, branchNode, this.defaultNodeCreator(file));
            }
        }
    }

    private void buildLogicallyLockedFiles(Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        ChangesBrowserNode baseNode = this.createNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        ArrayList<VirtualFile> keys = new ArrayList<VirtualFile>(logicallyLockedFiles.keySet());
        Collections.sort(keys, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file);
            ChangesBrowserLogicallyLockedFile obj = new ChangesBrowserLogicallyLockedFile(this.myProject, file, lock);
            this.insertChangeNode(obj, policy, baseNode, this.defaultNodeCreator(obj));
        }
    }

    private Computable<ChangesBrowserNode> defaultNodeCreator(final Object change) {
        return new Computable<ChangesBrowserNode>(){

            public ChangesBrowserNode compute() {
                return ChangesBrowserNode.create(TreeModelBuilder.this.myProject, change);
            }
        };
    }

    private void insertChangeNode(Object change, ChangesGroupingPolicy policy, ChangesBrowserNode listNode, Computable<ChangesBrowserNode> nodeCreator) {
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode node = (ChangesBrowserNode)nodeCreator.compute();
        ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, policy, listNode);
        this.model.insertNodeInto(node, parentNode, this.model.getChildCount(parentNode));
        if (pathKey != null && pathKey.isDirectory()) {
            this.myFoldersCache.put(pathKey.getKey(), node);
        }
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.model, (Comparator)MyChangesBrowserNodeComparator.getInstance());
        this.model.nodeStructureChanged((TreeNode)this.model.getRoot());
    }

    private static void collapseDirectories(DefaultTreeModel model, ChangesBrowserNode node) {
        if (node.getUserObject() instanceof FilePath && node.getChildCount() == 1) {
            ChangesBrowserNode child = (ChangesBrowserNode)node.getChildAt(0);
            if (child.getUserObject() instanceof FilePath && !child.isLeaf()) {
                ChangesBrowserNode parent = (ChangesBrowserNode)node.getParent();
                int idx = parent.getIndex(node);
                model.removeNodeFromParent(node);
                model.removeNodeFromParent(child);
                model.insertNodeInto(child, parent, idx);
                TreeModelBuilder.collapseDirectories(model, parent);
            }
        } else {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)children.nextElement();
                TreeModelBuilder.collapseDirectories(model, child);
            }
        }
    }

    private static StaticFilePath getKey(Object o) {
        if (o instanceof Change) {
            return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
        }
        if (o instanceof VirtualFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)o);
        }
        if (o instanceof FilePath) {
            return TreeModelBuilder.staticFrom((FilePath)o);
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject());
        }
        if (o instanceof LocallyDeletedChange) {
            return TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
        }
        return null;
    }

    private static StaticFilePath staticFrom(FilePath fp) {
        String path = fp.getPath();
        if (fp.isNonLocal() && (!FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path))) {
            return new StaticFilePath(fp.isDirectory(), fp.getIOFile().getPath().replace('\\', '/'), fp.getVirtualFile());
        }
        return new StaticFilePath(fp.isDirectory(), new File(fp.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), fp.getVirtualFile());
    }

    private static StaticFilePath staticFrom(VirtualFile vf) {
        return new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
    }

    public static FilePath getPathForObject(Object o) {
        if (o instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)o));
        }
        if (o instanceof VirtualFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
        }
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject()));
        }
        if (o instanceof LocallyDeletedChange) {
            return ((LocallyDeletedChange)o).getPath();
        }
        return null;
    }

    private ChangesBrowserNode getParentNodeFor(StaticFilePath nodePath, @Nullable ChangesGroupingPolicy policy, ChangesBrowserNode rootNode) {
        ChangesBrowserNode nodeFromPolicy;
        if (this.showFlatten) {
            return rootNode;
        }
        if (policy != null && (nodeFromPolicy = policy.getParentNodeFor(nodePath, rootNode)) != null) {
            return nodeFromPolicy;
        }
        StaticFilePath parentPath = nodePath.getParent();
        if (parentPath == null) {
            return rootNode;
        }
        ChangesBrowserNode parentNode = this.myFoldersCache.get(parentPath.getKey());
        if (parentNode == null) {
            FilePath filePath = parentPath.getVf() == null ? VcsUtil.getFilePath((String)parentPath.getPath(), (boolean)true) : VcsUtil.getFilePath((VirtualFile)parentPath.getVf());
            parentNode = ChangesBrowserNode.create(this.myProject, filePath);
            ChangesBrowserNode grandPa = this.getParentNodeFor(parentPath, policy, rootNode);
            this.model.insertNodeInto(parentNode, grandPa, grandPa.getChildCount());
            this.myFoldersCache.put(parentPath.getKey(), parentNode);
        }
        return parentNode;
    }

    public DefaultTreeModel clearAndGetModel() {
        this.root.removeAllChildren();
        this.model = new DefaultTreeModel(this.root);
        this.myFoldersCache = new HashMap();
        this.myPolicyInitialized = false;
        return this.model;
    }

    public boolean isEmpty() {
        return this.model.getChildCount(this.root) == 0;
    }

    private static class MyChangesBrowserNodeComparator
    implements Comparator<ChangesBrowserNode> {
        private static final MyChangesBrowserNodeComparator ourInstance = new MyChangesBrowserNodeComparator();

        private MyChangesBrowserNodeComparator() {
        }

        public static MyChangesBrowserNodeComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ChangesBrowserNode node1, ChangesBrowserNode node2) {
            int classdiff = node1.getSortWeight() - node2.getSortWeight();
            if (classdiff != 0) {
                return classdiff;
            }
            if (node1 instanceof Comparable && node1.getClass().equals(node2.getClass())) {
                return ((Comparable)((Object)node1)).compareTo(node2);
            }
            return node1.compareUserObjects(node2.getUserObject());
        }
    }

    private static class MyChangePathLengthComparator
    implements Comparator<Change> {
        private static final MyChangePathLengthComparator ourInstance = new MyChangePathLengthComparator();

        private MyChangePathLengthComparator() {
        }

        public static MyChangePathLengthComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Change o1, Change o2) {
            FilePath fp1 = ChangesUtil.getFilePath((Change)o1);
            FilePath fp2 = ChangesUtil.getFilePath((Change)o2);
            int diff = fp1.getIOFile().getPath().length() - fp2.getIOFile().getPath().length();
            return diff == 0 ? 0 : (diff < 0 ? -1 : 1);
        }
    }

    private static class MyChangeNodeUnderChangeListDecorator
    extends RemoteStatusChangeNodeDecorator {
        private final ChangeListRemoteState.Reporter myReporter;

        private MyChangeNodeUnderChangeListDecorator(RemoteRevisionsCache remoteRevisionsCache, ChangeListRemoteState.Reporter reporter) {
            super(remoteRevisionsCache);
            this.myReporter = reporter;
        }

        @Override
        protected void reportState(boolean state) {
            this.myReporter.report(state);
        }

        @Override
        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }
    }
}

