/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.cyclicDependencies.ui.CyclicDependenciesPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class PackageNode
extends PackageDependenciesNode {
    private String myPackageName;
    private final String myPackageQName;
    private final PsiPackage myPackage;

    public PackageNode(PsiPackage aPackage, boolean showFQName) {
        super(aPackage.getProject());
        String packageQName;
        this.myPackage = aPackage;
        String string = this.myPackageName = showFQName ? aPackage.getQualifiedName() : aPackage.getName();
        if (this.myPackageName == null || this.myPackageName.length() == 0) {
            this.myPackageName = CyclicDependenciesPanel.DEFAULT_PACKAGE_ABBREVIATION;
        }
        if ((packageQName = aPackage.getQualifiedName()).length() == 0) {
            packageQName = null;
        }
        this.myPackageQName = packageQName;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            if (!(child instanceof FileNode) && !recursively) continue;
            child.fillFiles(set, true);
        }
    }

    @Override
    public String toString() {
        return this.myPackageName;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = packageName;
    }

    public String getPackageQName() {
        return this.myPackageQName;
    }

    @Override
    public PsiElement getPsiElement() {
        return this.myPackage;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageNode)) {
            return false;
        }
        PackageNode packageNode = (PackageNode)o;
        if (!this.myPackageName.equals(packageNode.myPackageName)) {
            return false;
        }
        return !(this.myPackageQName != null ? !this.myPackageQName.equals(packageNode.myPackageQName) : packageNode.myPackageQName != null);
    }

    public int hashCode() {
        int result2 = this.myPackageName.hashCode();
        result2 = 29 * result2 + (this.myPackageQName != null ? this.myPackageQName.hashCode() : 0);
        return result2;
    }

    @Override
    public Icon getIcon() {
        return PlatformIcons.PACKAGE_ICON;
    }

    @Override
    public boolean isValid() {
        return this.myPackage != null && this.myPackage.isValid();
    }

    @Override
    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        Set<PsiFile> files = deps.keySet();
        String packageName = this.myPackageQName;
        for (PsiFile file : files) {
            if (!(file instanceof PsiJavaFile) || !Comparing.equal((String)packageName, (String)((PsiJavaFile)file).getPackageName())) continue;
            return true;
        }
        return false;
    }
}

