/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiDiamondTypeImpl.class.getName()));
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @NotNull
    public String getPresentableText() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getPresentableText"));
        }
        return "";
    }

    @NotNull
    public String getCanonicalText() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getCanonicalText"));
        }
        return "";
    }

    @NotNull
    public String getInternalCanonicalText() {
        if ("Diamond Type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getInternalCanonicalText"));
        }
        return "Diamond Type";
    }

    public boolean isValid() {
        return false;
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiDiamondTypeImpl", "equalsToText"));
        }
        return text.isEmpty();
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiDiamondTypeImpl", "accept"));
        }
        return (A)visitor.visitDiamondType((PsiDiamondType)this);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)this.getResolveScope())};
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myTypeElement, PsiNewExpression.class);
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, (PsiElement)newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context) {
        PsiElement resolve;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)newExpression) && (resolve = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getChildOfType((PsiElement)newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context);
        if (anonymousClass != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)newExpression)) {
            InferredAnonymTypeVisitor anonymTypeVisitor = new InferredAnonymTypeVisitor(context);
            for (PsiType type : inferenceResult.getInferredTypes()) {
                Boolean accepted = (Boolean)type.accept((PsiTypeVisitor)anonymTypeVisitor);
                if (accepted == null || accepted.booleanValue()) continue;
                return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
            }
        }
        return inferenceResult;
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(final PsiNewExpression newExpression, final PsiElement context) {
        final Ref staticFactoryRef = new Ref();
        PsiSubstitutor inferredSubstitutor = (PsiSubstitutor)ourDiamondGuard.doPreventingRecursion((Object)context, false, (Computable)new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                MethodCandidateInfo staticFactoryCandidateInfo = context == newExpression ? (MethodCandidateInfo)CachedValuesManager.getCachedValue((PsiElement)context, (CachedValueProvider)new CachedValueProvider<MethodCandidateInfo>(){

                    @Nullable
                    public CachedValueProvider.Result<MethodCandidateInfo> compute() {
                        return new CachedValueProvider.Result((Object)PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, (PsiElement)newExpression), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                }) : PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, context);
                staticFactoryRef.set((Object)staticFactoryCandidateInfo);
                return staticFactoryCandidateInfo != null ? staticFactoryCandidateInfo.getSubstitutor() : null;
            }
        });
        if (inferredSubstitutor == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        MethodCandidateInfo staticFactoryInfo = (MethodCandidateInfo)staticFactoryRef.get();
        if (staticFactoryInfo == null) {
            LOG.error((Object)inferredSubstitutor);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiMethod staticFactory = staticFactoryInfo.getElement();
        PsiTypeParameter[] parameters = staticFactory.getTypeParameters();
        PsiElement staticFactoryContext = staticFactory.getContext();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)staticFactoryContext, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            LOG.error("failed for expression:" + newExpression);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result2 = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>");
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)staticFactory, (PsiSubstitutor)inferredSubstitutor)) {
            if (!JavaVersionService.getInstance().isAtLeast((PsiElement)newExpression, JavaSdkVersion.JDK_1_8) && PsiUtil.skipParenthesizedExprUp((PsiElement)newExpression.getParent()) instanceof PsiExpressionList) {
                for (PsiTypeParameter ignored : parameters) {
                    result2.addInferredType((PsiType)PsiType.getJavaLangObject((PsiManager)newExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)newExpression.getProject())));
                }
            }
            return result2;
        }
        block1: for (PsiTypeParameter parameter : parameters) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual((String)classParameter.getName(), (String)parameter.getName())) continue;
                result2.addInferredType(inferredSubstitutor.substitute(parameter));
                continue block1;
            }
        }
        return result2;
    }

    private static MethodCandidateInfo getStaticFactoryCandidateInfo(PsiNewExpression newExpression, PsiElement context) {
        Computable<Integer> computable;
        Integer applicability;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return null;
        }
        PsiMethod staticFactory = PsiDiamondTypeImpl.findConstructorStaticFactory(psiClass, newExpression);
        if (staticFactory == null) {
            return null;
        }
        final MethodCandidateInfo staticFactoryCandidateInfo = PsiDiamondTypeImpl.createMethodCandidate(staticFactory, context, false, argumentList);
        if (staticFactory.isVarArgs() && ((applicability = (Integer)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)newExpression, true, (Computable)(computable = new Computable<Integer>(){

            public Integer compute() {
                return staticFactoryCandidateInfo.getPertinentApplicabilityLevel();
            }
        }))) != null ? applicability.intValue() : staticFactoryCandidateInfo.getApplicabilityLevel()) < 3) {
            return PsiDiamondTypeImpl.createMethodCandidate(staticFactory, context, true, argumentList);
        }
        return staticFactoryCandidateInfo;
    }

    @Nullable
    private static PsiMethod findConstructorStaticFactory(final PsiClass containingClass, PsiNewExpression newExpression) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)newExpression);
        ArrayList conflicts = new ArrayList();
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{null};
        }
        PsiConflictResolver[] conflictResolvers = new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList, languageLevel)};
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor((PsiElement)argumentList, argumentList.getContainingFile(), conflictResolvers, conflicts){

            @Override
            protected boolean isAccepted(PsiMethod candidate) {
                return true;
            }

            @Override
            protected PsiClass getContainingClass(PsiMethod method) {
                return containingClass;
            }

            @Override
            protected boolean acceptVarargs() {
                return true;
            }
        };
        processor2.setArgumentList(argumentList);
        for (PsiMethod constructor : constructors) {
            PsiTypeParameter[] params = PsiDiamondTypeImpl.getAllTypeParams((PsiTypeParameterListOwner)constructor, containingClass);
            PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor, containingClass, params, newExpression.getClassReference());
            if (staticFactory == null) continue;
            processor2.add((PsiElement)staticFactory, PsiSubstitutor.EMPTY);
        }
        JavaResolveResult[] result2 = processor2.getResult();
        return result2.length == 1 ? (PsiMethod)result2[0].getElement() : null;
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
        if (classReference != null) {
            String text = classReference.getReferenceName();
            if (text != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference.getQualifier();
                String qualifier = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName = StringUtil.getQualifiedName((String)qualifier, (String)text);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName, (PsiElement)newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor, PsiClass containingClass, PsiTypeParameter[] params, PsiJavaCodeReferenceElement reference) {
        PsiElement qualifier;
        StringBuilder buf = new StringBuilder();
        String modifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)(constructor != null ? constructor.getModifierList() : containingClass.getModifierList()));
        if (!"packageLocal".equals(modifier)) {
            buf.append(modifier);
            buf.append(" ");
        }
        buf.append("static ");
        buf.append("<");
        buf.append(StringUtil.join((Object[])params, (Function)new Function<PsiTypeParameter, String>(){

            public String fun(PsiTypeParameter psiTypeParameter) {
                Object[] extendsListTypes;
                String extendsList = "";
                if (psiTypeParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && (extendsListTypes = psiTypeParameter.getExtendsListTypes()).length > 0) {
                    Function<PsiClassType, String> canonicalTypePresentationFun = new Function<PsiClassType, String>(){

                        public String fun(PsiClassType type) {
                            return type.getCanonicalText();
                        }
                    };
                    extendsList = " extends " + StringUtil.join((Object[])extendsListTypes, (Function)canonicalTypePresentationFun, (String)"&");
                }
                return psiTypeParameter.getName() + extendsList;
            }
        }, (String)", "));
        buf.append(">");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
        String qualifiedName = containingClass.getQualifiedName();
        PsiElement psiElement = qualifier = reference != null ? reference.getQualifier() : null;
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiClass) {
                String outerClassSubstitutedQName = elementFactory.createType((PsiClass)element, resolveResult.getSubstitutor()).getInternalCanonicalText();
                qualifiedName = outerClassSubstitutedQName + "." + containingClass.getName();
            }
        } else if (reference != null && qualifier == null && containingClass.getContainingClass() != null) {
            qualifiedName = null;
        }
        buf.append(qualifiedName != null ? qualifiedName : containingClass.getName());
        Object[] parameters = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join((Object[])parameters, (Function)new Function<PsiTypeParameter, String>(){

            public String fun(PsiTypeParameter psiTypeParameter) {
                return psiTypeParameter.getName();
            }
        }, (String)", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join((Object[])constructor.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){
                int myIdx = 0;

                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, (String)",")).append(")");
        }
        buf.append("{}");
        try {
            return elementFactory.createMethodFromText(buf.toString(), (PsiElement)(constructor != null ? constructor : containingClass));
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static PsiTypeParameter[] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        Collections.addAll(params, containingClass.getTypeParameters());
        return params.toArray(new PsiTypeParameter[params.size()]);
    }

    private static MethodCandidateInfo createMethodCandidate(@NotNull PsiMethod staticFactoryMethod, final PsiElement parent, final boolean varargs, final PsiExpressionList argumentList) {
        if (staticFactoryMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticFactoryMethod", "com/intellij/psi/PsiDiamondTypeImpl", "createMethodCandidate"));
        }
        return new MethodCandidateInfo((PsiElement)staticFactoryMethod, PsiSubstitutor.EMPTY, false, false, (PsiElement)argumentList, parent, null, null){
            private PsiType[] myExpressionTypes;

            public boolean isVarargs() {
                return varargs;
            }

            protected PsiElement getParent() {
                return parent;
            }

            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null) {
                    PsiType[] expressionTypes = argumentList.getExpressionTypes();
                    if (MethodCandidateInfo.isOverloadCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }

            protected PsiElement getMarkerList() {
                return parent instanceof PsiNewExpression ? ((PsiNewExpression)parent).getArgumentList() : super.getMarkerList();
            }
        };
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/PsiDiamondTypeImpl", "hasDefaultConstructor"));
        }
        for (PsiMethod method : constructors = psiClass.getConstructors()) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return constructors.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/PsiDiamondTypeImpl", "haveConstructorsGenericsParameters"));
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                Boolean accept = (Boolean)type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitClassType(PsiClassType classType) {
                        for (PsiType psiType : classType.getParameters()) {
                            Boolean typeParamFound;
                            if (psiType == null || (typeParamFound = (Boolean)psiType.accept((PsiTypeVisitor)this)) == null || !typeParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound == null) {
                            return false;
                        }
                        return (Boolean)bound.accept((PsiTypeVisitor)this);
                    }
                });
                if (accept == null || !accept.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static class InferredAnonymTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private final PsiElement myExpression;

        public InferredAnonymTypeVisitor(PsiElement expression) {
            this.myExpression = expression;
        }

        @Nullable
        public Boolean visitType(PsiType type) {
            return true;
        }

        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return false;
        }

        @Nullable
        public Boolean visitIntersectionType(PsiIntersectionType intersectionType) {
            return false;
        }

        @Nullable
        public Boolean visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                if (psiClass instanceof PsiTypeParameter && InferenceSession.isFreshVariable((PsiTypeParameter)psiClass)) {
                    return false;
                }
                if (!PsiUtil.isAccessible((PsiMember)psiClass, (PsiElement)this.myExpression, null)) {
                    return false;
                }
                for (PsiType psiType : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    Boolean accepted = (Boolean)psiType.accept((PsiTypeVisitor)this);
                    if (accepted == null || accepted.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

