/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import com.intellij.psi.scope.processor.ConflictFilterProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    private boolean myStaticScopeFlag;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext;

    public VariableResolverProcessor(@NotNull PsiJavaCodeReferenceElement place, @NotNull PsiFile placeFile) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "<init>"));
        }
        super(place.getReferenceName(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, (List<CandidateInfo>)new SmartList(), (PsiElement)place, placeFile);
        this.myStaticScopeFlag = false;
        this.myCurrentFileContext = null;
        PsiClass access = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier));
            PsiElement element = accessClass.getElement();
            if (element instanceof PsiTypeParameter) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)placeFile.getProject()).getElementFactory();
                PsiClassType type = factory.createType((PsiClass)((PsiTypeParameter)element));
                PsiType accessType = accessClass.getSubstitutor().substitute((PsiType)type);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)placeFile);
                    access = factory.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element instanceof PsiClass) {
                access = (PsiClass)element;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "handleEvent"));
        }
        super.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "add"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "add"));
        }
        boolean staticProblem = this.myStaticScopeFlag && !((PsiModifierListOwner)element).hasModifierProperty("static");
        this.add(new CandidateInfo(element, substitutor, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "execute"));
        }
        if (!(element instanceof PsiField) && (this.myName == null || PsiUtil.checkName((PsiElement)element, (String)this.myName, (PsiElement)this.myPlace))) {
            super.execute(element, state);
            return this.myResults.isEmpty();
        }
        return super.execute(element, state);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/resolve/VariableResolverProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

