/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceNode
extends AbstractTreeNode<SliceUsage>
implements DuplicateNodeRenderer.DuplicatableNode<SliceNode>,
MyColoredTreeCellRenderer {
    protected List<SliceNode> myCachedChildren;
    protected boolean dupNodeCalculated;
    protected SliceNode duplicate;
    protected final DuplicateMap targetEqualUsages;
    protected boolean changed;
    private int index;

    protected SliceNode(@NotNull Project project, SliceUsage sliceUsage, @NotNull DuplicateMap targetEqualUsages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceNode", "<init>"));
        }
        if (targetEqualUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetEqualUsages", "com/intellij/slicer/SliceNode", "<init>"));
        }
        super(project, (Object)sliceUsage);
        this.targetEqualUsages = targetEqualUsages;
    }

    @NotNull
    SliceNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceNode newNode = new SliceNode(this.getProject(), newUsage, this.targetEqualUsages);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        SliceNode sliceNode = newNode;
        if (sliceNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "copy"));
        }
        return sliceNode;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ProgressIndicator indicator;
        ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
        ProgressIndicator progressIndicator = indicator = current == null ? new ProgressIndicatorBase() : current;
        if (current == null) {
            indicator.start();
        }
        final Collection[] nodes = new Collection[1];
        ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                nodes[0] = SliceNode.this.getChildrenUnderProgress(ProgressManager.getInstance().getProgressIndicator());
            }
        }, indicator);
        if (current == null) {
            indicator.stop();
        }
        Collection collection = nodes[0];
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "getChildren"));
        }
        return collection;
    }

    SliceNode getNext(List parentChildren) {
        return this.index == parentChildren.size() - 1 ? null : (SliceNode)parentChildren.get(this.index + 1);
    }

    SliceNode getPrev(List parentChildren) {
        return this.index == 0 ? null : (SliceNode)parentChildren.get(this.index - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<? extends AbstractTreeNode> getChildrenUnderProgress(final @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/slicer/SliceNode", "getChildrenUnderProgress"));
        }
        if (this.isUpToDate()) {
            List<Object> list = this.myCachedChildren == null ? Collections.emptyList() : this.myCachedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "getChildrenUnderProgress"));
            }
            return list;
        }
        final ArrayList<SliceNode> children = new ArrayList<SliceNode>();
        SliceManager manager = SliceManager.getInstance(this.getProject());
        manager.runInterruptibly(progress, new Runnable(){

            @Override
            public void run() {
                SliceNode.this.changed = true;
            }
        }, new Runnable(){

            @Override
            public void run() {
                Processor<SliceUsage> processor2 = new Processor<SliceUsage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean process(SliceUsage sliceUsage) {
                        progress.checkCanceled();
                        SliceNode node = new SliceNode(SliceNode.this.myProject, sliceUsage, SliceNode.this.targetEqualUsages);
                        List list = children;
                        synchronized (list) {
                            node.index = children.size();
                            children.add(node);
                        }
                        return true;
                    }
                };
                ((SliceUsage)((Object)SliceNode.this.getValue())).processChildren(processor2);
            }
        });
        ArrayList<SliceNode> arrayList = children;
        synchronized (arrayList) {
            this.myCachedChildren = children;
        }
        ArrayList<SliceNode> arrayList2 = children;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "getChildrenUnderProgress"));
        }
        return arrayList2;
    }

    private boolean isUpToDate() {
        return this.myCachedChildren != null || !this.isValid();
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = new PresentationData(){

            @NotNull
            public Object[] getEqualityObjects() {
                Object[] objectArray = ArrayUtil.append((Object[])super.getEqualityObjects(), (Object)SliceNode.this.changed);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode$4", "getEqualityObjects"));
                }
                return objectArray;
            }
        };
        if (presentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "createPresentation"));
        }
        return presentationData;
    }

    protected void update(PresentationData presentation) {
        if (presentation != null) {
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    public void calculateDupNode() {
        if (!this.dupNodeCalculated) {
            if (!(this.getValue() instanceof SliceTooComplexDFAUsage)) {
                this.duplicate = this.targetEqualUsages.putNodeCheckDupe(this);
            }
            this.dupNodeCalculated = true;
        }
    }

    @Override
    public SliceNode getDuplicate() {
        return this.duplicate;
    }

    public void navigate(boolean requestFocus) {
        SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
        sliceUsage.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((SliceUsage)((Object)this.getValue())).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((SliceUsage)((Object)this.getValue())).canNavigateToSource();
    }

    public boolean isValid() {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ((SliceUsage)((Object)SliceNode.this.getValue())).isValid();
            }
        });
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/slicer/SliceNode", "customizeCellRenderer"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/slicer/SliceNode", "customizeCellRenderer"));
        }
        renderer.setIcon(this.getPresentation().getIcon(expanded));
        if (this.isValid()) {
            SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
            renderer.customizeCellRendererFor(sliceUsage);
            renderer.setToolTipText(sliceUsage.getPresentation().getTooltipText());
        } else {
            renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    @Nullable
    public SliceLanguageSupportProvider getProvider() {
        AbstractTreeNode element = this.getElement();
        if (element == null) {
            return null;
        }
        SliceUsage usage = (SliceUsage)((Object)element.getValue());
        if (usage == null) {
            return null;
        }
        PsiElement psiElement = usage.getElement();
        if (psiElement == null) {
            return null;
        }
        return LanguageSlicing.getProvider(psiElement);
    }

    public String toString() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return SliceNode.this.getValue() == null ? "<null>" : ((SliceUsage)((Object)SliceNode.this.getValue())).toString();
            }
        });
    }
}

