/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.EditableDictionaryLoader;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSpellChecker
implements SpellCheckerEngine {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.engine.BaseSpellChecker");
    private final Transformation transform = new Transformation();
    private final Set<EditableDictionary> dictionaries = new HashSet<EditableDictionary>();
    private final List<Dictionary> bundledDictionaries = ContainerUtil.createLockFreeCopyOnWriteList();
    private final AtomicBoolean myLoadingDictionaries = new AtomicBoolean(false);
    private final List<Pair<Loader, Consumer<Dictionary>>> myDictionariesToLoad = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;

    public BaseSpellChecker(Project project) {
        this.myProject = project;
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionary"));
        }
        if (loader instanceof EditableDictionaryLoader) {
            EditableDictionary dictionary = ((EditableDictionaryLoader)loader).getDictionary();
            if (dictionary != null) {
                this.addModifiableDictionary(dictionary);
            }
        } else {
            this.loadCompressedDictionary(loader);
        }
    }

    private void loadCompressedDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadCompressedDictionary"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            CompressedDictionary dictionary = CompressedDictionary.create(loader, this.transform);
            this.addCompressedFixedDictionary(dictionary);
        } else {
            this.loadDictionaryAsync(loader, new Consumer<Dictionary>(){

                public void consume(Dictionary dictionary) {
                    BaseSpellChecker.this.addCompressedFixedDictionary(dictionary);
                }
            });
        }
    }

    private void loadDictionaryAsync(@NotNull Loader loader, @NotNull Consumer<Dictionary> consumer) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionaryAsync"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionaryAsync"));
        }
        if (this.myLoadingDictionaries.compareAndSet(false, true)) {
            LOG.debug("Loading " + loader.getName());
            this._doLoadDictionaryAsync(loader, consumer);
        } else {
            this.queueDictionaryLoad(loader, consumer);
        }
    }

    private void _doLoadDictionaryAsync(final Loader loader, final Consumer<Dictionary> consumer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LOG.debug("Loading " + loader.getName());
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationManager.getApplication().isDisposed()) {
                            return;
                        }
                        CompressedDictionary dictionary = CompressedDictionary.create(loader, BaseSpellChecker.this.transform);
                        LOG.debug(loader.getName() + " loaded!");
                        consumer.consume((Object)dictionary);
                        while (!BaseSpellChecker.this.myDictionariesToLoad.isEmpty()) {
                            if (ApplicationManager.getApplication().isDisposed()) {
                                return;
                            }
                            Pair nextDictionary = (Pair)BaseSpellChecker.this.myDictionariesToLoad.remove(0);
                            Loader nextDictionaryLoader = (Loader)nextDictionary.getFirst();
                            CompressedDictionary dictionary1 = CompressedDictionary.create(nextDictionaryLoader, BaseSpellChecker.this.transform);
                            LOG.debug(nextDictionaryLoader.getName() + " loaded!");
                            ((Consumer)nextDictionary.getSecond()).consume((Object)dictionary1);
                        }
                        LOG.debug("Loading finished, restarting daemon...");
                        BaseSpellChecker.this.myLoadingDictionaries.set(false);
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ApplicationManager.getApplication().isDisposed()) {
                                    return;
                                }
                                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                                    DaemonCodeAnalyzer instance;
                                    if (!project.isInitialized() || !project.isOpen() || project.isDefault() || (instance = DaemonCodeAnalyzer.getInstance((Project)project)) == null) continue;
                                    instance.restart();
                                }
                            }
                        });
                    }
                });
            }
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
    }

    private void queueDictionaryLoad(Loader loader, Consumer<Dictionary> consumer) {
        LOG.debug("Queuing load for: " + loader.getName());
        this.myDictionariesToLoad.add((Pair<Loader, Consumer<Dictionary>>)Pair.create((Object)loader, consumer));
    }

    private void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "com/intellij/spellchecker/engine/BaseSpellChecker", "addModifiableDictionary"));
        }
        this.dictionaries.add(dictionary);
    }

    private void addCompressedFixedDictionary(@NotNull Dictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "com/intellij/spellchecker/engine/BaseSpellChecker", "addCompressedFixedDictionary"));
        }
        this.bundledDictionaries.add(dictionary);
    }

    @Override
    public Transformation getTransformation() {
        return this.transform;
    }

    private static void restore(char startFrom, int i, int j, Collection<? extends Dictionary> dictionaries, Collection<String> result2) {
        for (Dictionary dictionary : dictionaries) {
            BaseSpellChecker.restore(startFrom, i, j, dictionary, result2);
        }
    }

    private static void restore(final char first, final int i, final int j, Dictionary dictionary, final Collection<String> result2) {
        if (dictionary instanceof CompressedDictionary) {
            ((CompressedDictionary)dictionary).getWords(first, i, j, result2);
        } else {
            dictionary.traverse(new Consumer<String>(){

                public void consume(String s) {
                    if (!StringUtil.isEmpty((String)s) && s.charAt(0) == first && s.length() >= i && s.length() <= j) {
                        result2.add(s);
                    }
                }
            });
        }
    }

    private static int isCorrect(@NotNull String transformed, @Nullable Collection<? extends Dictionary> dictionaries) {
        if (transformed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformed", "com/intellij/spellchecker/engine/BaseSpellChecker", "isCorrect"));
        }
        if (dictionaries == null) {
            return -1;
        }
        int errors = 0;
        for (Dictionary dictionary : dictionaries) {
            if (dictionary == null) continue;
            Boolean contains = dictionary.contains(transformed);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return 0;
        }
        if (errors == dictionaries.size()) {
            return errors;
        }
        return -1;
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/engine/BaseSpellChecker", "isCorrect"));
        }
        String transformed = this.transform.transform(word);
        if (this.myLoadingDictionaries.get() || transformed == null) {
            return true;
        }
        int bundled = BaseSpellChecker.isCorrect(transformed, this.bundledDictionaries);
        int user = BaseSpellChecker.isCorrect(transformed, this.dictionaries);
        return bundled == 0 || user == 0 || bundled > 0 && user > 0;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int quality) {
        Suggestion suggestion;
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
        }
        String transformed = this.transform.transform(word);
        if (transformed == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
            }
            return list;
        }
        ArrayList<String> rawSuggestions = new ArrayList<String>();
        BaseSpellChecker.restore(transformed.charAt(0), 0, Integer.MAX_VALUE, this.bundledDictionaries, rawSuggestions);
        BaseSpellChecker.restore(word.charAt(0), 0, Integer.MAX_VALUE, this.dictionaries, rawSuggestions);
        if (rawSuggestions.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
            }
            return list;
        }
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(rawSuggestions.size());
        for (String rawSuggestion : rawSuggestions) {
            int distance = EditDistance.levenshtein((CharSequence)transformed, (CharSequence)rawSuggestion, (boolean)true);
            suggestions.add(new Suggestion(rawSuggestion, distance));
        }
        Collections.sort(suggestions);
        int limit = Math.min(maxSuggestions, suggestions.size());
        ArrayList<String> result2 = new ArrayList<String>(limit);
        int bestMetrics = ((Suggestion)suggestions.get(0)).getMetrics();
        for (int i = 0; i < limit && bestMetrics - (suggestion = (Suggestion)suggestions.get(i)).getMetrics() <= quality; ++i) {
            result2.add(i, suggestion.getWord());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spellchecker/engine/BaseSpellChecker", "getVariants"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getVariants"));
        }
        return list;
    }

    @Override
    public void reset() {
        this.bundledDictionaries.clear();
        this.dictionaries.clear();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "isDictionaryLoad"));
        }
        return this.getBundledDictionaryByName(name) != null;
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "removeDictionary"));
        }
        Dictionary dictionaryByName = this.getBundledDictionaryByName(name);
        if (dictionaryByName != null) {
            this.bundledDictionaries.remove(dictionaryByName);
        }
    }

    @Nullable
    public Dictionary getBundledDictionaryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "getBundledDictionaryByName"));
        }
        if (this.bundledDictionaries == null) {
            return null;
        }
        for (Dictionary dictionary : this.bundledDictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return dictionary;
        }
        return null;
    }
}

