/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.GCUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    public static final String PROFILE = "Configurable";
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static boolean ourHaveShutdownHook;
    private ThreadTracker myThreadTracker;
    private static int ourTestCount;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    @NotNull
    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        PsiManager psiManager = ourPsiManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getPsiManager"));
        }
        return psiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        IdeaTestApplication ideaTestApplication = ourApplication = IdeaTestApplication.getInstance();
        if (ideaTestApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "initApplication"));
        }
        return ideaTestApplication;
    }

    public static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)ourApplication);
                }
            });
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/LightPlatformTestCase", "resetClassFields"));
        }
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "initProject"));
        }
        ourProjectDescriptor = descriptor;
        AccessToken token = WriteAction.start();
        try {
            if (ourProject != null) {
                LightPlatformTestCase.closeAndDeleteProject();
            } else {
                LightPlatformTestCase.cleanPersistedVFSContent();
            }
        }
        finally {
            token.finish();
        }
        File projectFile = FileUtil.createTempFile((String)"light_temp_", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        ourProject = PlatformTestCase.createProject(projectFile, LIGHT_PROJECT_MARK + buffer);
        ourPathToKeep = projectFile.getPath();
        if (!ourHaveShutdownHook) {
            ourHaveShutdownHook = true;
            LightPlatformTestCase.registerShutdownHook();
        }
        ourPsiManager = null;
        ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

            @Override
            public void moduleCreated(@NotNull Module module) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightPlatformTestCase$2", "moduleCreated"));
                }
                ourModule = module;
            }

            @Override
            public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                if (sourceRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/testFramework/LightPlatformTestCase$2", "sourceRootCreated"));
                }
                ourSourceRoot = sourceRoot;
            }
        });
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).storePointers();
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        EdtTestUtil.runInEdtAndWait(new ThrowableRunnable<Throwable>(){

            public void run() throws Exception {
                LightPlatformTestCase.super.setUp();
                LightPlatformTestCase.initApplication();
                ApplicationInfoImpl.setInPerformanceTest(LightPlatformTestCase.this.isPerformanceTest());
                ourApplication.setDataProvider(LightPlatformTestCase.this);
                SimpleLightProjectDescriptor descriptor = new SimpleLightProjectDescriptor(LightPlatformTestCase.this.getModuleType(), LightPlatformTestCase.this.getProjectJDK());
                LightPlatformTestCase.doSetup(descriptor, LightPlatformTestCase.this.configureLocalInspectionTools(), LightPlatformTestCase.this.getTestRootDisposable());
                InjectedLanguageManagerImpl.pushInjectors(LightPlatformTestCase.getProject());
                LightPlatformTestCase.this.storeSettings();
                LightPlatformTestCase.this.myThreadTracker = new ThreadTracker();
                ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
                VirtualFilePointerManagerImpl filePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
                filePointerManager.storePointers();
            }
        });
    }

    public static void doSetup(@NotNull LightProjectDescriptor descriptor, @NotNull LocalInspectionTool[] localInspectionTools, @NotNull Disposable parentDisposable) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (localInspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInspectionTools", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean reusedProject = true;
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
            reusedProject = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        projectManagerEx.openTestProject(ourProject);
        if (reusedProject) {
            DumbService.getInstance((Project)ourProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(ourProject, false));
        }
        MessageBusConnection connection = ourProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase$4", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightPlatformTestCase$4", "moduleAdded"));
                }
                TestCase.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        CodeInsightTestFixtureImpl.configureInspections((InspectionProfileEntry[])localInspectionTools, LightPlatformTestCase.getProject(), Collections.<String>emptyList(), parentDisposable);
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx(LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
        final FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
            });
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTools"));
        }
        InspectionProfileEntry[] tools = new InspectionProfileEntry[classes.length];
        ArrayList eps = ContainerUtil.newArrayList();
        ContainerUtil.addAll((Collection)eps, (Object[])Extensions.getExtensions((ExtensionPointName)LocalInspectionEP.LOCAL_INSPECTION));
        ContainerUtil.addAll((Collection)eps, (Object[])Extensions.getExtensions((ExtensionPointName)InspectionEP.GLOBAL_INSPECTION));
        for (int i = 0; i < classes.length; ++i) {
            InspectionEP ep2;
            block3: {
                for (InspectionEP ep2 : eps) {
                    if (!classes[i].getName().equals(ep2.implementationClass)) continue;
                    break block3;
                }
                throw new IllegalArgumentException("Unable to find extension point for " + classes[i].getName());
            }
            tools[i] = ep2.instantiateTool();
        }
        this.enableInspectionTools(tools);
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTools"));
        }
        for (InspectionProfileEntry tool : tools) {
            this.enableInspectionTool(tool);
        }
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        LightPlatformTestCase.enableInspectionTool(LightPlatformTestCase.getProject(), toolWrapper);
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        InspectionToolWrapper toolWrapper = InspectionToolRegistrar.wrapTool(tool);
        LightPlatformTestCase.enableInspectionTool(LightPlatformTestCase.getProject(), toolWrapper);
    }

    public static void enableInspectionTool(final @NotNull Project project, final @NotNull InspectionToolWrapper toolWrapper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        final InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        final String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            HighlightDisplayKey.register((String)shortName, (String)toolWrapper.getDisplayName(), (String)toolWrapper.getID());
        }
        InspectionProfileImpl.initAndDo(new Computable(){

            public Object compute() {
                InspectionProfileImpl impl = (InspectionProfileImpl)profile;
                InspectionToolWrapper existingWrapper = impl.getInspectionTool(shortName, project);
                if (existingWrapper == null || existingWrapper.isInitialized() != toolWrapper.isInitialized() || toolWrapper.isInitialized() && toolWrapper.getTool() != existingWrapper.getTool()) {
                    impl.addTool(project, toolWrapper, (Map<String, List<String>>)new THashMap());
                }
                impl.enableTool(shortName, project);
                return null;
            }
        });
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "configureLocalInspectionTools"));
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        Project project = LightPlatformTestCase.getProject();
        CodeStyleSettingsManager.getInstance((Project)project).dropTemporarySettings();
        SmartList errors = new SmartList();
        try {
            this.checkForSettingsDamage((List<Throwable>)errors);
            LightPlatformTestCase.doTearDown(project, ourApplication, true, (List<Throwable>)errors);
        }
        catch (Throwable e) {
            errors.add(e);
        }
        try {
            super.tearDown();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        try {
            this.myThreadTracker.checkLeak();
            InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project);
            ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).assertPointersAreDisposed();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            CompoundRuntimeException.throwIfNotEmpty((List)errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTearDown(final @NotNull Project project, @NotNull IdeaTestApplication application, boolean checkForEditors, @NotNull List<Throwable> exceptions) throws Exception {
        PsiDocumentManagerImpl documentManager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        try {
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
            DocumentCommitThread.getInstance().clearQueue();
            CodeStyleSettingsManager.getInstance((Project)project).dropTemporarySettings();
            LightPlatformTestCase.checkAllTimersAreDisposed(exceptions);
            UsefulTestCase.doPostponedFormatting(project);
            LookupManager lookupManager = LookupManager.getInstance(project);
            if (lookupManager != null) {
                lookupManager.hideActiveLookup();
            }
            ((StartupManagerImpl)StartupManager.getInstance((Project)project)).prepareForNextTest();
            InspectionProfileManager.getInstance().deleteProfile(PROFILE);
            if (ProjectManager.getInstance() == null) {
                exceptions.add((Throwable)((Object)new AssertionError((Object)"Application components damaged")));
            }
            ContainerUtil.addIfNotNull(exceptions, (Object)new WriteCommandAction.Simple(project, new PsiFile[0]){

                protected void run() throws Throwable {
                    EncodingManager encodingManager;
                    if (ourSourceRoot != null) {
                        try {
                            VirtualFile[] children;
                            for (VirtualFile child : children = ourSourceRoot.getChildren()) {
                                child.delete((Object)this);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((encodingManager = EncodingManager.getInstance()) instanceof EncodingManagerImpl) {
                        ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
                    }
                    FileDocumentManager manager = FileDocumentManager.getInstance();
                    ApplicationManager.getApplication().runWriteAction(EmptyRunnable.getInstance());
                    manager.saveAllDocuments();
                    if (manager instanceof FileDocumentManagerImpl) {
                        ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                    }
                }
            }.execute().getThrowable());
            LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project).isDisposed());
            if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
            documentManager = LightPlatformTestCase.clearUncommittedDocuments(project);
            ((HintManagerImpl)HintManager.getInstance()).cleanup();
            DocumentCommitThread.getInstance().clearQueue();
            EdtTestUtil.runInEdtAndWait(new Runnable(){

                @Override
                public void run() {
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests();
                    ((UndoManagerImpl)UndoManager.getInstance((Project)project)).dropHistoryInTests();
                    UIUtil.dispatchAllInvocationEvents();
                }
            });
            TemplateDataLanguageMappings.getInstance(project).cleanupForNextTest();
        }
        finally {
            ProjectManagerEx.getInstanceEx().closeTestProject(project);
            application.setDataProvider(null);
            ourTestCase = null;
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).cleanupForNextTest();
            CompletionProgressIndicator.cleanupForNextTest();
        }
        if (checkForEditors) {
            LightPlatformTestCase.checkEditorsReleased(exceptions);
        }
        documentManager.clearUncommittedDocuments();
        if (ourTestCount++ % 100 == 0) {
            GCUtil.clearBeanInfoCache();
        }
    }

    public static PsiDocumentManagerImpl clearUncommittedDocuments(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "clearUncommittedDocuments"));
        }
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project);
        documentManager.clearUncommittedDocuments();
        ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
        return documentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEditorsReleased(@NotNull List<Throwable> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/testFramework/LightPlatformTestCase", "checkEditorsReleased"));
        }
        Editor[] allEditors = EditorFactory.getInstance().getAllEditors();
        if (allEditors.length == 0) {
            return;
        }
        for (Editor editor : allEditors) {
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            finally {
                EditorFactory.getInstance().releaseEditor(editor);
            }
        }
        try {
            ((EditorImpl)allEditors[0]).throwDisposalError("Unreleased editors: " + allEditors.length);
        }
        catch (Throwable e) {
            exceptions.add(e);
        }
    }

    @Override
    public final void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait(new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                try {
                    ourTestThread = Thread.currentThread();
                    LightPlatformTestCase.this.startRunAndTear();
                }
                finally {
                    ourTestThread = null;
                    try {
                        Application application = ApplicationManager.getApplication();
                        if (application instanceof ApplicationEx) {
                            PlatformTestCase.cleanupApplicationCaches(ourProject);
                        }
                        LightPlatformTestCase.this.resetAllFields();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String dataId) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getModuleType"));
        }
        return emptyModuleType;
    }

    @NotNull
    protected static PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        return psiFile;
    }

    @NotNull
    protected static PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        return psiFile;
    }

    @Override
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !UsefulTestCase.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void commitDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/testFramework/LightPlatformTestCase", "commitDocument"));
        }
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)LightPlatformTestCase.getProject());
    }

    protected static Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformTestCase", "getDocument"));
        }
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file);
    }

    public static synchronized void closeAndDeleteProject() {
        if (ourProject != null) {
            File parent;
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!ourProject.isDisposed()) {
                File ioFile = new File(ourProject.getProjectFilePath());
                Disposer.dispose((Disposable)ourProject);
                if (ioFile.exists()) {
                    File dir = ioFile.getParentFile();
                    if (dir.getName().startsWith("unitTest_")) {
                        FileUtil.delete((File)dir);
                    } else {
                        FileUtil.delete((File)ioFile);
                    }
                }
            }
            ProjectManagerEx.getInstanceEx().closeAndDispose(ourProject);
            if (ourPathToKeep != null && (parent = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
                parent.delete();
            }
            ourProject = null;
            ourPathToKeep = null;
        }
    }

    private static void registerShutdownHook() {
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                ShutDownTracker.invokeAndWait((boolean)true, (boolean)true, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                LightPlatformTestCase.closeAndDeleteProject();
                            }
                        });
                    }
                });
            }
        });
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            if (moduleType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor", "<init>"));
            }
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.myModuleType;
            if (moduleType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor", "getModuleType"));
            }
            return moduleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleType.equals((Object)that.myModuleType)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            Object[] myUrls = this.mySdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            Object[] newUrls = newSdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            return ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls));
        }
    }
}

