/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.javascript.debugger.NameMapperKt;
import gnu.trove.THashMap;
import java.util.Map;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011K)\u0011\u0001C\u0004\u0006\u0003\u0011!Q!\u0001E\u0007\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Aa\u0003\u0007\u0001!3I\u0012\u0001'\u0001\u001e\u00023\t+#C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001g\u0001\n\u0007!\u0015Q\"\u0001\r\u0004\u0013\rA9!D\u0001\u0019\tE\u001b\u0011\u0001#\u0003&\u0019\u0011Q\u0001\"C\u0007\u0006!')\"\u0001$\u0001\u0019\ra1\u0011d\u0001\u0005\u000b\u001b\u0005A*\"\n\u0005\t\u00175\u0011A\u0012\u0001\r\u00073\rA9\"D\u0001\u0019\u0019%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0002#\u000e\tQ\u0001A\u0015!\t\rc\u0002RB\u0007\t\u0013\tI\u0011\u0001\u0007\u0004\n\u0005%\t\u0001D\u0002G\u00011\u0017I\"\u0002C\u0003\u000e\u0011%\u0011\u0011\"\u0001\r\u0007\u0013\tI\u0011\u0001\u0007\u0004\r\u0002a-\u0001%I)\u0004\u000f\u0015\u0001QB\u0001\u0003\b\u0011\u001f\t\"\u0001\u0002\u0005\t\u0012%:A!\u0011\u0005\t\b5\t\u0001\u0004B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lcom/jetbrains/javascript/debugger/NameMapper;", "", "document", "Lcom/intellij/openapi/editor/Document;", "generatedDocument", "sourceMappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/debugger/sourcemap/MappingList;Lorg/jetbrains/debugger/sourcemap/SourceMap;)V", "<set-?>", "", "", "rawNameToSource", "getRawNameToSource", "()Ljava/util/Map;", "setRawNameToSource", "(Ljava/util/Map;)V", "extractName", "kotlin.jvm.PlatformType", "rawGeneratedName", "", "map", "identifierOrNamedElement", "Lcom/intellij/psi/PsiElement;", "Companion"}, moduleName="script-debugger-ui")
public class NameMapper {
    protected static final CharMatcher NAME_TRIMMER;
    @Nullable
    private Map<String, String> rawNameToSource;
    private final Document document;
    private final Document generatedDocument;
    private final MappingList sourceMappings;
    private final SourceMap sourceMap;
    public static final Companion Companion;

    static {
        Companion = com.jetbrains.javascript.debugger.NameMapper$Companion.INSTANCE;
        NAME_TRIMMER = CharMatcher.INVISIBLE.or(CharMatcher.anyOf((CharSequence)(NameMapperKt.access$getS1$p() + ".&:")));
    }

    @Nullable
    public final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    private final void setRawNameToSource(Map<String, String> map) {
        this.rawNameToSource = map;
    }

    @Nullable
    public final String map(@NotNull PsiElement identifierOrNamedElement) {
        Intrinsics.checkParameterIsNotNull((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        int offset = identifierOrNamedElement.getTextOffset();
        int line = this.document.getLineNumber(offset);
        int sourceEntryIndex = this.sourceMappings.indexOf(line, offset - this.document.getLineStartOffset(line));
        if (sourceEntryIndex == -1) {
            return null;
        }
        MappingEntry sourceEntry = this.sourceMappings.get(sourceEntryIndex);
        MappingEntry next = this.sourceMappings.getNextOnTheSameLine(sourceEntryIndex, false);
        if (next != null && this.sourceMappings.getColumn(next) == this.sourceMappings.getColumn(sourceEntry)) {
            NameMapperKt.warnSeveralMapping(identifierOrNamedElement);
            return null;
        }
        MappingEntry mappingEntry = sourceEntry;
        Intrinsics.checkExpressionValueIsNotNull((Object)mappingEntry, (String)"sourceEntry");
        String generatedName = this.extractName(NameMapperKt.access$getGeneratedName(this.generatedDocument, this.sourceMap, mappingEntry));
        if (StringsKt.isEmpty((String)generatedName)) {
            return null;
        }
        String sourceName = sourceEntry.getName();
        if (sourceName == null || Registry.is((String)"js.debugger.name.mappings.by.source.code", (boolean)false)) {
            Object object;
            Object object2;
            PsiElement psiElement = identifierOrNamedElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            if ((object2 = (PsiNamedElement)psiElement) == null || (object2 = object2.getName()) == null) {
                object2 = object = identifierOrNamedElement.getText();
            }
            if (object2 == null) {
                object = sourceName;
            }
            if (object == null) {
                return null;
            }
            sourceName = object;
        }
        if (this.rawNameToSource == null) {
            this.rawNameToSource = (Map)new THashMap();
        }
        Map<String, String> map = this.rawNameToSource;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        String string = generatedName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generatedName");
        map.put(string, sourceName);
        return generatedName;
    }

    protected String extractName(@NotNull CharSequence rawGeneratedName) {
        Intrinsics.checkParameterIsNotNull((Object)rawGeneratedName, (String)"rawGeneratedName");
        return Companion.getNAME_TRIMMER().trimFrom(rawGeneratedName);
    }

    public NameMapper(@NotNull Document document, @NotNull Document generatedDocument, @NotNull MappingList sourceMappings, @NotNull SourceMap sourceMap) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)generatedDocument, (String)"generatedDocument");
        Intrinsics.checkParameterIsNotNull((Object)sourceMappings, (String)"sourceMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        this.document = document;
        this.generatedDocument = generatedDocument;
        this.sourceMappings = sourceMappings;
        this.sourceMap = sourceMap;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005Aq!\u0002\u0001\u0006\u0003!5Q\u0001A\u0003\u0002\u0011\u0017!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u001f!!Q\"\u0002I\u0003+\ta\t\u0001'\u0003\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a5\u0011f\u0004\u0003C\u0011!\rQ\"\u0002I\u0003+\ta\t\u0001\u0007\u0002\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011Aa\u0001E\u0004"}, strings={"Lcom/jetbrains/javascript/debugger/NameMapper$Companion;", "", "()V", "NAME_TRIMMER", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "getNAME_TRIMMER", "()Lcom/google/common/base/CharMatcher;", "trimName", "", "rawGeneratedName", "", "isLastToken", ""}, moduleName="script-debugger-ui")
    public static final class Companion {
        public static final Companion INSTANCE;

        protected final CharMatcher getNAME_TRIMMER() {
            return NAME_TRIMMER;
        }

        public final String trimName(@NotNull CharSequence rawGeneratedName, boolean isLastToken) {
            Intrinsics.checkParameterIsNotNull((Object)rawGeneratedName, (String)"rawGeneratedName");
            return (isLastToken ? this.getNAME_TRIMMER() : NameMapperKt.access$getOPERATOR_TRIMMER$p()).trimFrom(rawGeneratedName);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

