/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.NetUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ\u0012\u0004\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014A\r\u0004\u0011\ti\u0011\u0001'\u0002U\u0007\ri\u0019\u0002c\u0002\u000e\u00051\u0005\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003U\u0007\ri\t\u0002C\u0003\u000e\u0003a\u0005\u0011d\u0001E\u0006\u001b\u0005A\u001a\u0001V\u0002\u0004"}, strings={"compareNameAndProjectBasePath", "", "projectName", "", "project", "Lcom/intellij/openapi/project/Project;", "BuiltInWebServerKt", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "isOwnHostName", "host"}, moduleName="built-in-server")
public final class BuiltInWebServerKt {
    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && CollectionsKt.length((CharSequence)basePath) > CollectionsKt.length((CharSequence)projectName) && StringsKt.endsWith$default((String)basePath, (String)projectName, (boolean)false, (int)2) && CollectionsKt.charAt((CharSequence)basePath, (int)(CollectionsKt.length((CharSequence)basePath) - CollectionsKt.length((CharSequence)projectName) - 1)) == '/';
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        VirtualFile[] children = basedir.getChildren();
        if (children == null || ArraysKt.isEmpty((Object[])children)) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        for (int i = 0; i < stringArray.length; ++i) {
            String indexNamePrefix = stringArray[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children.length; ++j) {
                VirtualFile child = children[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(CollectionsKt.length((CharSequence)host) - CollectionsKt.length((CharSequence)".local")), (boolean)true);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
    }
}

