/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import javax.swing.Icon;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.builtInWebServer.NetServiceKt;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\tMa\u0001!G\u0001\u0019\u0002u\u0005\u0011#)\u0007\u0005\u0006%\u0019\u0001\"A\u0007\u00021\u0007IA\u0001B\u0001\t\u00055\t\u0001TA)\u0004\u0003!\u0019Q\u0005\u0002\u0003\u0013\u0011\u001di\u0011\u0001g\u0004&\u0011\u0011Q\u0001\u0002C\u0007\u00021\u001fI2\u0001#\u0005\u000e\u0003aIQE\u0007\u0003\u000b\u0011'i\u0011\u0001g\u0004\u001a\r!QQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001'\u0006\u001a\u0007!YQ\"\u0001M\f3\rA9!D\u0001\u0019\ne1\u0001\u0002D\u0007\u0005\u0013\tI\u0011\u0001G\u0007\u0019\u001a\u0015jAQ\u0005E\u000e\u001b\ta\t\u0001'\u0003\u001a\u0007!\tQ\"\u0001M\u00023\rA1\"D\u0001\u0019\u0018\u0015\"Aa\u0003\u0005\u000f\u001b\u0005Az!\n\u0003\u0005\u0017!uQ\"\u0001\r\u0010K\u0011!!\u0003c\b\u000e\u0003a\u0001R\u0005\u0002\u0003\u0013\u0011Ci\u0011\u0001G\u0007*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%jAA\u0011\u0005\t\b5!\u0011BA\u0005\u00021\u0013AB!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\f%RAA\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001\u0003\u0007\u0011\u001b\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/NetService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "consoleManager", "Lorg/jetbrains/builtInWebServer/ConsoleManager;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/builtInWebServer/ConsoleManager;)V", "processHandler", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "Lcom/intellij/execution/process/OSProcessHandler;", "getProcessHandler", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "getProject", "()Lcom/intellij/openapi/project/Project;", "closeProcessConnections", "", "configureConsole", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "port", "", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "createProcessHandler", "dispose", "getConsoleToolWindowActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getConsoleToolWindowIcon", "Ljavax/swing/Icon;", "getConsoleToolWindowId", "MyProcessAdapter"}, moduleName="built-in-server")
public abstract class NetService
implements Disposable {
    @NotNull
    private final AsyncValueLoader<OSProcessHandler> processHandler;
    @NotNull
    private final Project project;
    private final ConsoleManager consoleManager;

    @NotNull
    protected final AsyncValueLoader<OSProcessHandler> getProcessHandler() {
        return this.processHandler;
    }

    @Nullable
    protected abstract OSProcessHandler createProcessHandler(@NotNull Project var1, int var2) throws ExecutionException;

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        promise.setResult((Object)processHandler2);
    }

    protected abstract void closeProcessConnections();

    public void dispose() {
        this.processHandler.reset();
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)consoleBuilder, (String)"consoleBuilder");
    }

    @NotNull
    protected abstract String getConsoleToolWindowId();

    @NotNull
    protected abstract Icon getConsoleToolWindowIcon();

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        return (ActionGroup)new DefaultActionGroup();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @JvmOverloads
    protected NetService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)consoleManager, (String)"consoleManager");
        this.project = project;
        this.consoleManager = consoleManager;
        this.processHandler = (AsyncValueLoader)new AsyncValueLoader<OSProcessHandler>(this){
            final /* synthetic */ NetService this$0;

            protected boolean isCancelOnReject() {
                return true;
            }

            private final OSProcessHandler doGetProcessHandler(int port) {
                try {
                    return this.this$0.createProcessHandler(this.this$0.getProject(), port);
                }
                catch (ExecutionException e) {
                    NetServiceKt.getLOG().error((Throwable)e);
                    return null;
                }
            }

            @NotNull
            protected Promise<OSProcessHandler> load(@NotNull AsyncPromise<OSProcessHandler> promise) {
                Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
                int port = NetUtils.findAvailableSocketPort();
                OSProcessHandler processHandler2 = this.doGetProcessHandler(port);
                if (processHandler2 == null) {
                    promise.setError("rejected");
                    return (Promise)promise;
                }
                promise.rejected((Consumer)new Consumer<Throwable>(processHandler2){
                    final /* synthetic */ OSProcessHandler $processHandler;

                    public final void consume(Throwable it) {
                        this.$processHandler.destroyProcess();
                        Promise.logError((Logger)NetServiceKt.getLOG(), (Throwable)it);
                    }
                    {
                        this.$processHandler = oSProcessHandler;
                    }
                });
                MyProcessAdapter processListener = this.this$0.new MyProcessAdapter();
                processHandler2.addProcessListener((ProcessListener)processListener);
                processHandler2.startNotify();
                if (PromiseKt.isRejected((Promise)promise)) {
                    return (Promise)promise;
                }
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, promise, port, processHandler2, processListener){
                    final /* synthetic */ processHandler.1 this$0;
                    final /* synthetic */ AsyncPromise $promise;
                    final /* synthetic */ int $port;
                    final /* synthetic */ OSProcessHandler $processHandler;
                    final /* synthetic */ MyProcessAdapter $processListener;

                    public final void run() {
                        block3: {
                            if (!PromiseKt.isRejected((Promise)this.$promise)) {
                                try {
                                    this.this$0.this$0.connectToProcess((AsyncPromise<OSProcessHandler>)this.$promise, this.$port, this.$processHandler, (Consumer<String>)((Consumer)this.$processListener));
                                }
                                catch (Throwable e) {
                                    if (this.$promise.setError(e)) break block3;
                                    NetServiceKt.getLOG().error(e);
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$promise = asyncPromise;
                        this.$port = n;
                        this.$processHandler = oSProcessHandler;
                        this.$processListener = myProcessAdapter;
                    }
                });
                return (Promise)promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void disposeResult(@NotNull OSProcessHandler processHandler2) {
                Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
                try {
                    this.this$0.closeProcessConnections();
                }
                finally {
                    processHandler2.destroyProcess();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @JvmOverloads
    protected /* synthetic */ NetService(Project project, ConsoleManager consoleManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            consoleManager = new ConsoleManager();
        }
        this(project, consoleManager);
    }

    @JvmOverloads
    protected NetService(@NotNull Project project) {
        this(project, null, 2, null);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005A\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\t\u0005\u0013A\u0002A\r\u00021\u0003IB!\u0003\u0002\n\u0003a\r\u0001$AQ\u0003#\u000e\t\u0001BA\u0013\t\t-A)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0007)c\u0002B\u0006\t\t5\t\u0001dA\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u000b!-QbA\u0005\u0002\t\u0007Ab!\n\u0007\u0005\u0003!5Q\"\u0001\r\u00043\rAq!D\u0001\u0019\u0004e\u0019\u0001rB\u0007\u00021!)\u0003\u0002B\u0006\t\u00125\t\u0001dA\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/builtInWebServer/NetService$MyProcessAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "Lcom/intellij/util/Consumer;", "", "(Lorg/jetbrains/builtInWebServer/NetService;)V", "consume", "", "message", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "processTerminated"}, moduleName="built-in-server")
    private final class MyProcessAdapter
    extends ProcessAdapter
    implements Consumer<String> {
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
            String string = event.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.getText()");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(outputType);
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026nsoleViewType(outputType)");
            this.print(string, consoleViewContentType);
        }

        private final void print(String text, ConsoleViewContentType contentType) {
            NetService.this.consoleManager.getConsole(NetService.this).print(text, contentType);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            NetService.this.getProcessHandler().reset();
            String string = NetService.this.getConsoleToolWindowId() + " terminated" + "\n";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print(string, consoleViewContentType);
        }

        public void consume(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
            this.print(message, consoleViewContentType);
        }
    }
}

