/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000e\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0011\tA\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)\u0003\u0002B\u0001\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003&9\u0011Y\u0001\u0012B\u0007\u00021\rI2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0002\t\u000f5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!IQ\"\u0001M\n3\rA!\"D\u0001\u0019\u0007\u0015bB!\u0001E\u000b\u001b\u0005A2\"G\u0002\t\u00185\t\u0001\u0004B\r\u0004\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021'I2\u0001\u0003\u0006\u000e\u0003a\u0019\u0011\u0006\u0003\u0003B9!\rQB\u0001G\u00011\t\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "hasAccess", "", "result", "Ljava/io/File;", "process", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "isCustomHost", "processSsi", "", "file"}, moduleName="built-in-server")
public final class StaticFileHandler
extends WebServerFileHandler {
    private SsiProcessor ssiProcessor;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, boolean isCustomHost) {
        block12: {
            File file;
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                if (pathInfo.getIoFile() != null) break block11;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block12;
            }
            if ((file = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                file = new File(virtualFile.getPath());
            }
            File ioFile = file;
            String nameSequence = pathInfo.getName();
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm")) {
                this.processSsi(ioFile, canonicalRequestPath, project, request, channel, isCustomHost);
                return true;
            }
            if (this.hasAccess(ioFile)) {
                FileResponses.sendFile((HttpRequest)request, channel, ioFile);
                return true;
            }
            Responses.sendStatus(HttpResponseStatus.FORBIDDEN, channel, (HttpRequest)request);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file = virtualFile;
        HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file.getTimeStamp(), file.getPath());
        if (httpResponse == null) return true;
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file.getInputStream()));
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return true;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(File file, CharSequence canonicalRequestPath, Project project, FullHttpRequest request, Channel channel, boolean isCustomHost) {
        boolean keepAlive;
        String path = PathUtilRt.getParentPath((String)((Object)canonicalRequestPath).toString());
        if (!isCustomHost) {
            path = StringsKt.substring((String)path, (int)(StringsKt.indexOf$default((String)path, (char)'/', (int)1, (boolean)false, (int)4) + 1));
        }
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            long lastModified;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file.getParentFile()), FileUtil.loadFile((File)file), file.lastModified(), new ByteBufUtf8Writer(buffer)), file.getPath()) == null) {
                return;
            }
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final boolean hasAccess(File result2) {
        return !result2.isDirectory() && result2.canRead() && !result2.isHidden() && !StringsKt.startsWith$default((String)result2.getName(), (String)".ht", (boolean)false, (int)2);
    }
}

