/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeBase;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueManager;

public final class ObjectScope
extends ScopeBase
implements Scope {
    private final ObjectValue value;

    public ObjectScope(@NotNull Scope.Type type, @NotNull ObjectValue value) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/debugger/ObjectScope", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/ObjectScope", "<init>"));
        }
        super(type, value.getValueString());
        this.value = value;
    }

    @NotNull
    public VariablesHost getVariablesHost() {
        VariablesHost<ValueManager<Vm>> variablesHost = this.value.getVariablesHost();
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ObjectScope", "getVariablesHost"));
        }
        return variablesHost;
    }
}

