/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharSequenceBackedByArray;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

public class JsonRpcServer
implements MessageServer {
    protected static final Logger LOG = Logger.getInstance(JsonRpcServer.class);
    private static final TypeAdapterFactory INT_LIST_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){
        private IntArrayListTypeAdapter<TIntArrayList> typeAdapter;

        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getType() != TIntArrayList.class) {
                return null;
            }
            if (this.typeAdapter == null) {
                this.typeAdapter = new IntArrayListTypeAdapter();
            }
            return this.typeAdapter;
        }
    };
    private final AtomicInteger messageIdCounter;
    private final ClientManager clientManager;
    private final Gson gson;
    private final Map<String, NotNullLazyValue> domains;

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        if (clientManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientManager", "org/jetbrains/io/jsonRpc/JsonRpcServer", "<init>"));
        }
        this.messageIdCounter = new AtomicInteger();
        this.domains = new THashMap();
        this.clientManager = clientManager;
        this.gson = new GsonBuilder().registerTypeAdapter(CharSequenceBackedByArray.class, (Object)new JsonSerializer<CharSequenceBackedByArray>(){

            public JsonElement serialize(CharSequenceBackedByArray src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }).registerTypeAdapterFactory(INT_LIST_TYPE_ADAPTER_FACTORY).disableHtmlEscaping().create();
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        this.registerDomain(name, commands, false);
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands, boolean overridable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (this.domains.containsKey(name)) {
            if (overridable) {
                return;
            }
            throw new IllegalArgumentException(name + " is already registered");
        }
        this.domains.put(name, commands);
    }

    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message, boolean isBinary) throws IOException {
        Object[] parameters;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "messageReceived"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/JsonRpcServer", "messageReceived"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        if (!isBinary) {
            reader.beginArray();
        }
        int messageId = reader.peek() == JsonToken.NUMBER ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise == null) {
                    LOG.error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise.setResult(JsonUtil.nextAny(reader));
            } else {
                promise.setError("error");
            }
            return;
        }
        NotNullLazyValue domainHolder = this.domains.get(domainName);
        if (domainHolder == null) {
            LOG.error("Cannot find domain " + domainName);
            return;
        }
        Object domain = domainHolder.getValue();
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId);
            return;
        }
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody(reader, list);
            parameters = ArrayUtil.toObjectArray((Collection)list);
        } else {
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        if (!isBinary) {
            reader.endArray();
        }
        try {
            boolean isStatic = domain instanceof Class;
            Method[] methods = isStatic ? ((Class)domain).getDeclaredMethods() : domain.getClass().getMethods();
            for (Method method : methods) {
                if (!method.getName().equals(command)) continue;
                method.setAccessible(true);
                Object result2 = method.invoke(isStatic ? null : domain, parameters);
                if (messageId != -1) {
                    client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, null, null, null, new Object[]{result2}));
                }
                return;
            }
            throw new NoSuchMethodException(command);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void sendResponse(int messageId, @NotNull Client client, @Nullable ByteBuf rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendResponse"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, null, null, rawMessage, ArrayUtil.EMPTY_OBJECT_ARRAY));
    }

    public void sendErrorResponse(int messageId, @NotNull Client client, @Nullable CharSequence rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendErrorResponse"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, "e", null, null, new Object[]{rawMessage}));
    }

    public void sendToClients(@NotNull String domain, @NotNull String name) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        this.sendToClients(domain, name, null, new Object[0]);
    }

    public <T> void sendToClients(@NotNull String domain, @NotNull String command, @Nullable List<AsyncPromise<Pair<Client, T>>> results, Object ... params) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (this.clientManager.hasClients()) {
            this.sendToClients(results == null ? -1 : this.messageIdCounter.getAndIncrement(), domain, command, results, params);
        }
    }

    private <T> void sendToClients(int messageId, @Nullable String domain, @Nullable String command, @Nullable List<AsyncPromise<Pair<Client, T>>> results, Object[] params) {
        this.clientManager.send(messageId, this.encodeMessage(ByteBufAllocator.DEFAULT, messageId, domain, command, null, params), results);
    }

    public boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @Nullable ByteBuf rawMessage, Object ... params) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), -1, domain, command, rawMessage, params));
        return true;
    }

    public void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        this.sendWithRawPart(client, domain, command, null, params);
    }

    @NotNull
    public <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        ByteBuf message;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        int messageId = this.messageIdCounter.getAndIncrement();
        AsyncPromise result2 = client.send(messageId, message = this.encodeMessage(client.getByteBufAllocator(), messageId, domain, command, null, params));
        LOG.assertTrue(result2 != null);
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        return asyncPromise;
    }

    @NotNull
    private ByteBuf encodeMessage(@NotNull ByteBufAllocator byteBufAllocator, int messageId, @Nullable String domain, @Nullable String command, @Nullable ByteBuf rawData, @Nullable Object[] params) {
        ByteBuf byteBuf;
        if (byteBufAllocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteBufAllocator", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeMessage"));
        }
        ByteBuf buffer = byteBufAllocator.ioBuffer();
        boolean success = false;
        try {
            Object[] notNullParams = params == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : params;
            buffer = this.doEncodeMessage(byteBufAllocator, buffer, messageId, domain, command, notNullParams, rawData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("OUT " + domain + '.' + command + (notNullParams.length == 0 ? "" : " " + Arrays.toString(params)) + (rawData == null ? "" : " " + rawData.toString(CharsetToolkit.UTF8_CHARSET)));
            }
            success = true;
            ByteBuf byteBuf2 = buffer;
            byteBuf = byteBuf2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        if (byteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeMessage"));
        }
        return byteBuf;
    }

    @NotNull
    private ByteBuf doEncodeMessage(@NotNull ByteBufAllocator byteBufAllocator, @NotNull ByteBuf buffer, int id, @Nullable String domain, @Nullable String command, @NotNull Object[] params, @Nullable ByteBuf rawData) throws IOException {
        if (byteBufAllocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteBufAllocator", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        buffer.writeByte(91);
        ByteBuf effectiveBuffer = buffer;
        boolean hasPrev = false;
        StringBuilder sb = null;
        if (id != -1) {
            sb = new StringBuilder();
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)sb.append(id));
            sb.setLength(0);
            hasPrev = true;
        }
        if (domain != null) {
            if (hasPrev) {
                buffer.writeByte(44);
            }
            buffer.writeByte(34);
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)domain);
            buffer.writeByte(34).writeByte(44).writeByte(34);
            if (command == null) {
                if (rawData != null) {
                    effectiveBuffer = byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
                    buffer = byteBufAllocator.ioBuffer();
                }
                buffer.writeByte(34);
                ByteBuf byteBuf = JsonRpcServer.addBuffer(effectiveBuffer, buffer);
                if (byteBuf == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
                }
                return byteBuf;
            }
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)command);
            buffer.writeByte(34);
        }
        this.encodeParameters(buffer, params, rawData, sb);
        if (rawData != null) {
            if (params.length > 0) {
                buffer.writeByte(44);
            }
            effectiveBuffer = byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
            buffer = byteBufAllocator.ioBuffer();
        }
        buffer.writeByte(93);
        buffer.writeByte(93);
        ByteBuf byteBuf = JsonRpcServer.addBuffer(effectiveBuffer, buffer);
        if (byteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        return byteBuf;
    }

    @NotNull
    private static ByteBuf addBuffer(@NotNull ByteBuf buffer, @NotNull ByteBuf lastComponent) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/jsonRpc/JsonRpcServer", "addBuffer"));
        }
        if (lastComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastComponent", "org/jetbrains/io/jsonRpc/JsonRpcServer", "addBuffer"));
        }
        if (buffer != lastComponent) {
            ((CompositeByteBuf)buffer).addComponent(lastComponent);
            buffer.writerIndex(buffer.capacity());
        }
        ByteBuf byteBuf = buffer;
        if (byteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "addBuffer"));
        }
        return byteBuf;
    }

    private void encodeParameters(@NotNull ByteBuf buffer, @NotNull Object[] params, @Nullable ByteBuf rawData, @Nullable StringBuilder sb) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeParameters"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeParameters"));
        }
        JsonWriter writer = null;
        buffer.writeByte(44).writeByte(91);
        boolean hasPrev = false;
        for (Object param : params) {
            if (hasPrev) {
                buffer.writeByte(44);
            } else {
                hasPrev = true;
            }
            if (param instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, buffer);
                continue;
            }
            if (param == null) {
                ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)"null");
                continue;
            }
            if (param instanceof Boolean) {
                ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)param.toString());
                continue;
            }
            if (param instanceof Number) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (param instanceof Integer) {
                    sb.append((Integer)param);
                } else if (param instanceof Long) {
                    sb.append((Long)param);
                } else if (param instanceof Float) {
                    sb.append(((Float)param).floatValue());
                } else if (param instanceof Double) {
                    sb.append((Double)param);
                } else {
                    sb.append(param.toString());
                }
                ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)sb);
                sb.setLength(0);
                continue;
            }
            if (param instanceof Consumer) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                ((Consumer)param).consume((Object)sb);
                ByteBufUtilEx.writeUtf8(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter((Writer)new ByteBufUtf8Writer(buffer));
            }
            this.gson.getAdapter(param.getClass()).write(writer, param);
        }
    }

    private static class IntArrayListTypeAdapter<T>
    extends TypeAdapter<T> {
        private IntArrayListTypeAdapter() {
        }

        public void write(final JsonWriter out, T value) throws IOException {
            final Ref error = new Ref();
            out.beginArray();
            ((TIntArrayList)value).forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        out.value((long)value);
                    }
                    catch (IOException e) {
                        error.set((Object)e);
                    }
                    return error.isNull();
                }
            });
            if (!error.isNull()) {
                throw (IOException)error.get();
            }
            out.endArray();
        }

        public T read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

