/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.RequestCallback;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\t\t\u0015\tA!\u0002\u0007\u0001+\t!\u0001\u0001#\u0001\u0016\u0005\u0011\u0005\u0001\"A\u000b\u0005\t\u0005A\u0019!F\u0001\u0019\u0005U\u0011A1\u0001E\u00033\u0005A2!(A\u000fCKIq\u0002c\u0002\u000e\u001b%\u0011\u0011\"\u0001\u000f\u0001\u0013\tI\u0011\u0001(\u0001\n\u0005%\tA$A\u0005\u0003\u0013\u0005a\u001a\u0001\u0007\u0003R\u0007\u0005AI!J\u0002\t\u00105\t\u0001\u0004C\u0013\t\t\u0005A\t\"D\u0001\u0019\u0011e\u0019\u0001\"C\u0007\u00021')#\u0002\u0003\u0006\u000e\t%\u0011\u0011\"\u0001O\u00021\u0019I2\u0001#\u0006\u000e\u0003aMQ5\u0003\u0005\f\u001b\u0005A\u0002\"G\u0002\t\u00185\tA\u0014A)\u0004\u0003!aQ\u0015\u0005E\r\u001b\u0005A\u0002\"G\u0002\t\u001b5\tA\u0004A\r\u0007\u00117iA!\u0003\u0002\n\u0003q\r\u0001DB)\u0004\u0003!q\u0011V\u0006\u0003B\u0011!)Q\u0012E\u0005\r\u0013-I!!C\u0001\u001d\u0004A5Q#B\u0005\u0003\u0013\u0005a\u001a\u0001$\u0001\u0019\ra1\u00014B)\u0004\u0003\u00119\u0011kA\u0001\u0006\u0001%\u001aB!\u0011\u0005\t\b5i\u0011BA\u0005\u00029\u0001I!!C\u0001\u001d\u0002%\u0011\u0011\"\u0001\u000f\u0002\u0013\tI\u0011\u0001h\u0001\u0019\tE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/rpc/MessageManager;", "REQUEST", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "Lorg/jetbrains/rpc/MessageManagerBase;", "handler", "Lorg/jetbrains/rpc/MessageManager$Handler;", "(Lorg/jetbrains/rpc/MessageManager$Handler;)V", "callbackMap", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/rpc/RequestCallback;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cancelWaitingRequests", "", "failedToSend", "sequence", "", "getCallbackAndRemove", "id", "processIncoming", "incomingParsed", "(Ljava/lang/Object;)V", "send", "message", "callback", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "Handler"}, moduleName="script-debugger-backend")
public final class MessageManager<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS>
extends MessageManagerBase {
    private final ConcurrentIntObjectMap<RequestCallback<SUCCESS>> callbackMap;
    private final Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(REQUEST message, @NotNull RequestCallback<SUCCESS> callback) {
        boolean success;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.rejectIfClosed(callback)) {
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message);
        this.callbackMap.put(sequence, callback);
        try {
            success = this.handler.write(message);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                CommandProcessorKt.getLOG().error("Failed to send", e);
            }
            return;
        }
        if (!success) {
            this.failedToSend(sequence);
        }
    }

    private final void failedToSend(int sequence) {
        Unit unit;
        RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(sequence);
        if (requestCallback != null) {
            requestCallback.onError("Failed to send");
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public final void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.getClosed()) {
                CommandProcessorKt.getLOG().info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        RequestCallback<SUCCESS> callback = this.getCallbackAndRemove(this.handler.getSequence(commandResponse));
        if (this.rejectIfClosed(callback)) {
            return;
        }
        try {
            this.handler.call(commandResponse, callback);
        }
        catch (Throwable e) {
            callback.onError(e);
            CommandProcessorKt.getLOG().error("Failed to dispatch response to callback", e);
        }
    }

    @NotNull
    public final RequestCallback<SUCCESS> getCallbackAndRemove(int id) {
        RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(id);
        if (requestCallback == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return requestCallback;
    }

    public final void cancelWaitingRequests() {
        ConcurrentIntObjectMap<RequestCallback<SUCCESS>> map = this.callbackMap;
        int[] keys = map.keys();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Unit unit;
            int key = keys[i];
            RequestCallback requestCallback = (RequestCallback)map.get(key);
            if (requestCallback != null) {
                MessageManagerBaseKt.reject(requestCallback);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    public MessageManager(@NotNull Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler2) {
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        this.handler = handler2;
        this.callbackMap = ContainerUtil.createConcurrentIntObjectMap();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0011)\u0011\u0001b\u0002\u0006\u0003!-Q\u0001\u0001\u00034\u0019\u0001)\"\u0001\u0002\u0002\t\u0002U\u0011AQ\u0001\u0005\u0002+\u0011!1\u0001c\u0001\u0016\u0003a\u0011QC\u0001C\u0004\u0011\u000bI\u0012\u0001\u0007\u0002&\u0016\u0011\u0019\u0002bA\u0007\u00021\u000fI2\u0001\u0003\u0003\u000e\u0003q\u0015\u0011kA\u0001\t\n\u0015\u000eBa\u0005\u0005\u0006\u001b\u0005A:!G\u0002\t\f5\tAdA\r\u0007\u0011\u0019iA!\u0003\u0002\n\u0003q\u001d\u0001TB)\u0004\u0003!9QU\u0003\u0003\u0014\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!EQ\"\u0001\u000f\u0004#\u000e\t\u0001\"CS\u000b\tMA\u0019\"D\u0001\u0019\u0011e\u0019\u0001BC\u0007\u00029\t\t6!\u0001\u0005\nK/!1\u0003#\u0006\u000e\u00051\u0005AdA\r\u0004\u0011\u0011i\u0011\u0001(\u0002R\u0007\u0005A1\"*\u0006\u0005(!]Q\"\u0001\r\r3\rA!\"D\u0001\u001d\u0005E\u001b\u0011\u0001#\u0007"}, strings={"Lorg/jetbrains/rpc/MessageManager$Handler;", "OUTGOING", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "acceptNonSequence", "", "incoming", "(Ljava/lang/Object;)V", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "getSequence", "", "incomingWithSeq", "(Ljava/lang/Object;)I", "getUpdatedSequence", "message", "readIfHasSequence", "(Ljava/lang/Object;)Ljava/lang/Object;", "write", "", "(Ljava/lang/Object;)Z"}, moduleName="script-debugger-backend")
    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> {
        public int getUpdatedSequence(OUTGOING var1);

        public boolean write(OUTGOING var1) throws IOException;

        @Nullable
        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        public int getSequence(@NotNull INCOMING_WITH_SEQ var1);

        public void acceptNonSequence(INCOMING var1);

        public void call(@NotNull INCOMING_WITH_SEQ var1, @NotNull RequestCallback<SUCCESS> var2);
    }
}

