/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexedRootsProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class IndexableSetContributor
implements IndexedRootsProvider {
    protected static final Set<VirtualFile> EMPTY_FILE_SET = Collections.emptySet();

    @Override
    public final Set<String> getRootsToIndex() {
        return ContainerUtil.map2Set(this.getAdditionalRootsToIndex(), (Function)new NotNullFunction<VirtualFile, String>(){

            @NotNull
            public String fun(VirtualFile virtualFile) {
                String string = virtualFile.getUrl();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor$1", "fun"));
                }
                return string;
            }
        });
    }

    @NotNull
    public static Set<VirtualFile> getProjectRootsToIndex(IndexedRootsProvider provider, Project project) {
        if (provider instanceof IndexableSetContributor) {
            Set<VirtualFile> set = ((IndexableSetContributor)provider).getAdditionalProjectRootsToIndex(project);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
            }
            return set;
        }
        Set<VirtualFile> set = EMPTY_FILE_SET;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
        }
        return set;
    }

    public static Set<VirtualFile> getRootsToIndex(IndexedRootsProvider provider) {
        if (provider instanceof IndexableSetContributor) {
            return ((IndexableSetContributor)provider).getAdditionalRootsToIndex();
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (String url : provider.getRootsToIndex()) {
            ContainerUtil.addIfNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(url), result);
        }
        return result;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        Set<VirtualFile> set = EMPTY_FILE_SET;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public abstract Set<VirtualFile> getAdditionalRootsToIndex();
}

