/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.LinkedList;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.MessageCredits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferingProtocol.class);
    private final int maxBufferSize;
    private final LinkedList<Message> queue = new LinkedList();
    private ProtocolContext<Message> context;
    private int remainingOutgoingCredits;
    private int remainingIncomingCredits;
    private boolean stopping;

    public BufferingProtocol(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public void start(ProtocolContext<Message> context) {
        this.context = context;
        context.dispatchOutgoing(new MessageCredits(this.maxBufferSize));
        this.remainingIncomingCredits = this.maxBufferSize;
    }

    @Override
    public void handleIncoming(Message message) {
        --this.remainingIncomingCredits;
        if (this.remainingOutgoingCredits == 0) {
            this.queue.add(message);
        } else {
            --this.remainingOutgoingCredits;
            this.context.dispatchIncoming(message);
        }
        this.maybeGrantIncomingCredits();
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof MessageCredits) {
            MessageCredits credits = (MessageCredits)message;
            this.remainingOutgoingCredits += credits.getCredits();
            while (!this.queue.isEmpty() && this.remainingOutgoingCredits > 0) {
                --this.remainingOutgoingCredits;
                this.context.dispatchIncoming(this.queue.removeFirst());
            }
            if (this.stopping && this.queue.isEmpty()) {
                this.context.stopped();
                return;
            }
            this.maybeGrantIncomingCredits();
        } else {
            this.context.dispatchOutgoing(message);
        }
    }

    private void maybeGrantIncomingCredits() {
        int minBatchSize = this.maxBufferSize / 2;
        int grantablePermits = this.maxBufferSize - this.queue.size() - this.remainingIncomingCredits + this.remainingOutgoingCredits;
        if (grantablePermits >= minBatchSize) {
            this.context.dispatchOutgoing(new MessageCredits(grantablePermits));
            this.remainingIncomingCredits += grantablePermits;
        }
    }

    @Override
    public void stopRequested() {
        this.stopping = true;
        if (this.queue.isEmpty()) {
            this.context.stopped();
        } else {
            LOGGER.debug("Waiting for queue to empty. Stopping later.");
            this.context.stopLater();
        }
    }
}

