/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.build.GeneratedFile;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt$sam$FileFilter$23290363;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.incremental.ChangesInfo;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A)#B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005A\u0019#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t%\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011A\u0002\u0001I\"3\u0005A\n!h\u0001\"D\t\n+!U\u0002\u0002\u0011\u0005)#\u0004B\u0006\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u00063%AY!D\u0004\n\u0005%\t\u0001TB\u0005\u0003\u0013\u0005Ar\u0001\u0007\u0004\u001a\u0007!=Q\"\u0001\r\tK%!1\u0002#\u0005\u000e\u0003aI\u0011\u0004\u0002E\u0004\u001b\ta\t\u0001\u0007\u0003&\u0011\u0011Y\u00012C\u0007\u00021%I2\u0001c\u0002\u000e\u0003a!Q\u0005\n\u0003\u0002\u0011)i!\u0001$\u0001\u0019\u0016e\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001C\u0006\u000e\u0003a]\u0011d\u0001\u0005\r\u001b\u0005AJ\"\u0007\u0006\t\u001b5A\u0011BA\u0005\u000219I!!C\u0001\u0019\u001e1\u0005\u00014D\r\u0004\u0011=i\u0011\u0001g\b\u001a\u0007!\u0001R\"\u0001M\u0011KQ\"\u0011\u0001C\t\u000e\u00051\u0005\u0001TC\r\u0007\u0011GiA!\u0003\u0002\n\u0003a\u0015\u0002DE\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!YQ\"\u0001M\f3\rA9!D\u0001\u0019\teI\u00012B\u0007\b\u0013\tI\u0011\u0001'\u0004\n\u0005%\t\u0001d\u0002\r\u00073\rAA\"D\u0001\u0019\u001aeI\u0001bE\u0007\b\u0013\tI\u0011\u0001G\u0004\n\u0005%\t\u0001T\u0005M\u00143\rAq\"D\u0001\u0019 \u0015bA!\u0001\u0005\u0015\u001b\u0005A\u0012\"G\u0002\t\n5\t\u0001$B\r\u0004\u0011Ai\u0011\u0001'\t&-\u0011\t\u0001\u0012F\u0007\u000213I\u0012\u0002C\u0007\u000e\u000f%\u0011\u0011\"\u0001\r\b\u0013\tI\u0011\u0001'\b\u0019+e\u0019\u00012F\u0007\u00021YI2\u0001c\u0002\u000e\u0003a!QE\b\u0003\u0002\u0011[i\u0011\u0001G\u0002\u001a\u0007!%Q\"\u0001\r\u00063\rA9!D\u0001\u0019\teI\u00012B\u0007\b\u0013\tI\u0011\u0001'\u0004\n\u0005%\t\u0001d\u0002\r\u00073\rAq\"D\u0001\u0019 e\u0019\u0001rB\u0007\u00021!)#\u0019\u0001\u0003\u0002\u0011]i!\u0001$\u0001\u0019\u0016e1\u00012E\u0007\u0005\u0013\tI\u0011\u0001'\n\u0019%e\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001C\u0006\u000e\u0003a]\u0011d\u0001E\u0004\u001b\u0005AB!G\u0005\t\f59\u0011BA\u0005\u00021\u001bI!!C\u0001\u0019\u000fa1\u0011d\u0001\u0005\r\u001b\u0005AJ\"G\u0005\t'59\u0011BA\u0005\u00021\u001dI!!C\u0001\u0019&a\u001d\u0012$\u0003\u0005\u000e\u001b\u001dI!!C\u0001\u0019\u000f%\u0011\u0011\"\u0001M\u00181UI2\u0001C\b\u000e\u0003a}\u0011d\u0001\u0005\u0011\u001b\u0005A\n#J\u0004\u0005\u0017!AR\u0002B\u0005\u0003\u0013\u0005A\u0012\u0004'\r&\u001f\u0011\t\u00012G\u0007\u0005\u0013\tI\u0011\u0001'\u000e\u00195e\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001C\u000e\u000e\u0003aUQ\u0005\u0002\u0003\f\u0011oi\u0011\u0001G\r&\u001f\u0011\t\u0001\u0002H\u0007\u00021%I2\u0001c\u0004\u000e\u0003aA\u0011D\u0002E\u001d\u001b\u0011I!!C\u0001\u00196aQRe\u000b\u0003\u0002\u0011ui\u0011\u0001G\u0005\u001a\u0007!%Q\"\u0001\r\u00063\rAY$D\u0001\u0019=e\u0019\u0001rA\u0007\u00021\u0011I\u0012\u0002c\u0003\u000e\u000f%\u0011\u0011\"\u0001M\u0007\u0013\tI\u0011\u0001G\u0004\u0019\reI\u0001bE\u0007\b\u0013\tI\u0011\u0001G\u0004\n\u0005%\t\u0001T\u0005M\u00143\u0019Ai$\u0004\u0003\n\u0005%\t\u0001d\b\r\u001bKu!\u0011\u0001c\u0010\u000e\u0003a\u0001\u0013d\u0001E\u001e\u001b\u0005Ab$G\u0005\t\u001b59\u0011BA\u0005\u00021\u001dI!!C\u0001\u00190a)\u0012D\u0002E\u001d\u001b\u0011I!!C\u0001\u00196aQ\u0012d\u0001E\u0005\u001b\u0005AR!\n\u0004\u0005\u0003!\u0005S\"\u0001\r\u001f+\u0005A*#K\u0004\u0005\u0003\"A\u0019!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "", "buildStarted", "compileToJs", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/modules/TargetId;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "compileToJvm", "allCompiledFiles", "", "Ljava/io/File;", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "copyJsLibraryFilesIfNeeded", "createCompileEnvironment", "", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "doBuild", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/jps/build/GeneratedFile;", "outputItemCollector", "getPresentableName", "registerOutputItems", "generatedFiles", "updateJavaMappings", "compilationErrors", "", "generatedClasses", "Lorg/jetbrains/kotlin/jps/build/GeneratedJvmClass;", "updateKotlinIncrementalCache", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "isModuleMappingFile", "ChangesProcessor", "Companion", "MessageCollectorAdapter"}, moduleName="jps-plugin")
public final class KotlinBuilder
extends ModuleLevelBuilder {
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    public static final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> LOOKUP_TRACKER;
    public static final Logger LOG;
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.jps.build.KotlinBuilder$Companion.INSTANCE;
        KOTLIN_BUILDER_NAME = KOTLIN_BUILDER_NAME;
        JpsElementChildRoleBase jpsElementChildRoleBase = JpsElementChildRoleBase.create((String)"lookup tracker");
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsElementChildRoleBase, (String)"JpsElementChildRoleBase.create(\"lookup tracker\")");
        LOOKUP_TRACKER = jpsElementChildRoleBase;
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @NotNull
    public String getPresentableName() {
        return Companion.getKOTLIN_BUILDER_NAME();
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Companion.getLOG().debug("==========================================");
        Companion.getLOG().info("is Kotlin incremental compilation enabled: " + IncrementalCompilation.isEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            Companion.getLOG().info("Label in local history: " + historyLabel);
        }
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        Companion.getLOG().debug("------------------------------------------");
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        try {
            return this.doBuild(chunk, context, dirtyFilesHolder, messageCollector, outputConsumer);
        }
        catch (StopBuildException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            String string = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OutputMessageUtil.renderException(e)");
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, string, CompilerMessageLocation.Companion.getNO_LOCATION());
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ChangesInfo changesInfo;
        Object info;
        Collection destination;
        void $receiver;
        void $receiver2;
        Object object;
        JpsSimpleElement jpsSimpleElement;
        JpsProject project;
        block24: {
            block23: {
                void value;
                void $receiver3;
                boolean bl;
                Object it;
                Object element2;
                Iterable $receiver4;
                BuildDataManager dataManager;
                ProjectDescriptor projectDescriptor;
                block22: {
                    if (!((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue() && !JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
                        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", CompilerMessageLocation.Companion.getNO_LOCATION());
                        return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                    }
                    projectDescriptor = context.getProjectDescriptor();
                    dataManager = projectDescriptor.dataManager;
                    Iterable iterable = chunk.getTargets();
                    for (Object element2 : $receiver4) {
                        it = (ModuleBuildTarget)element2;
                        BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                        BuildTarget buildTarget = (BuildTarget)it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                        if (!IncrementalCacheImplKt.getKotlinCacheVersion(buildDataPaths, buildTarget).isIncompatible()) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
                if (bl) {
                    List list;
                    void destination2;
                    Iterator $receiver5;
                    $receiver4 = chunk.getTargets();
                    StringBuilder stringBuilder = new StringBuilder().append("Clearing caches for ");
                    Logger logger = Companion.getLOG();
                    Iterable iterable = $receiver4;
                    element2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
                    it = $receiver5.iterator();
                    while (it.hasNext()) {
                        void it2;
                        Object item = it.next();
                        ModuleBuildTarget $i$f$any = (ModuleBuildTarget)item;
                        list = destination2;
                        String string = it2.getPresentableName();
                        list.add(string);
                    }
                    list = (List)destination2;
                    logger.info(stringBuilder.append(StringsKt.join$default((Iterable)list, null, null, null, (int)0, null, (int)31)).toString());
                    $receiver4 = chunk.getTargets();
                    for (Object element2 : $receiver4) {
                        Object object2 = it = (ModuleBuildTarget)element2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                        IncrementalCacheImplKt.getKotlinCache(dataManager, (ModuleBuildTarget)object2).clean();
                    }
                    return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                }
                if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles() || !KotlinBuilderKt.access$hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin version " + "1.0.0-beta-1103-IJ143-27", CompilerMessageLocation.Companion.getNO_LOCATION());
                project = projectDescriptor.getProject();
                jpsSimpleElement = (JpsSimpleElement)project.getContainer().getChild((JpsElementChildRole)Companion.getLOOKUP_TRACKER());
                if (jpsSimpleElement == null) break block23;
                element2 = jpsSimpleElement;
                it = (JpsSimpleElement)$receiver3;
                boolean $i$a$3 = StringsKt.equals((String)"true", (String)System.getProperty("kotlin.jps.tests"), (boolean)true);
                if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                    String message = "LOOKUP_TRACKER allowed only for jps tests";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                jpsSimpleElement = (LookupTracker)it.getData();
                if (jpsSimpleElement != null) break block24;
            }
            jpsSimpleElement = LookupTracker.Companion.getDO_NOTHING();
        }
        JpsSimpleElement lookupTracker = jpsSimpleElement;
        Map<ModuleBuildTarget, IncrementalCacheImpl> incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
        CompilerEnvironment environment = this.createCompileEnvironment(incrementalCaches, (LookupTracker)lookupTracker, context);
        if (!environment.success()) {
            environment.reportErrorsTo(messageCollector);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        CommonCompilerArguments commonArguments = JpsKotlinCompilerSettings.getCommonCompilerArguments(project);
        commonArguments.verbose = true;
        Set<File> allCompiledFiles = KotlinBuilderKt.access$getAllCompiledFilesContainer(context);
        MultiMap<ModuleBuildTarget, File> filesToCompile = KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder);
        long start = System.nanoTime();
        CommonCompilerArguments commonCompilerArguments = commonArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"commonArguments");
        MultiMap<ModuleBuildTarget, File> multiMap = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"filesToCompile");
        JpsProject jpsProject = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        OutputItemsCollectorImpl outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, commonCompilerArguments, context, dirtyFilesHolder, environment, multiMap, incrementalCaches, messageCollector, jpsProject);
        this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
        if (outputItemCollector == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Boolean compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
        if (compilationErrors.booleanValue()) {
            Companion.getLOG().info("Compiled with errors");
        } else {
            Companion.getLOG().info("Compiled successfully");
        }
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles(chunk, outputItemCollector);
        this.registerOutputItems(outputConsumer, generatedFiles);
        context.checkCanceled();
        boolean isJsModule = JpsUtils.isJsKotlinModule(chunk.representativeTarget());
        if (isJsModule) {
            object = ChangesInfo.Companion.getNO_CHANGES();
        } else {
            Iterable iterable = generatedFiles;
            void var24_31 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                if (!(element instanceof GeneratedJvmClass)) continue;
                destination.add(element);
            }
            List generatedClasses = (List)destination;
            info = this.updateKotlinIncrementalCache(compilationErrors, incrementalCaches, generatedFiles, chunk);
            boolean bl = compilationErrors;
            MultiMap<ModuleBuildTarget, File> multiMap2 = filesToCompile;
            Intrinsics.checkExpressionValueIsNotNull(multiMap2, (String)"filesToCompile");
            this.updateJavaMappings(chunk, bl, context, dirtyFilesHolder, multiMap2, generatedClasses);
            object = changesInfo = info;
        }
        if (compilationErrors.booleanValue()) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (isJsModule) {
            JpsProject jpsProject2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject2, (String)"project");
            this.copyJsLibraryFilesIfNeeded(chunk, jpsProject2);
        }
        if (!IncrementalCompilation.isEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        info = filesToCompile.keySet();
        $receiver = $receiver2;
        destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            IncrementalCacheImpl incrementalCacheImpl;
            void it;
            ModuleBuildTarget $i$f$filterIsInstanceTo = (ModuleBuildTarget)item;
            Collection collection = destination;
            if (incrementalCaches.get(it) == null) {
                Intrinsics.throwNpe();
            }
            collection.add(incrementalCacheImpl);
        }
        List caches2 = (List)destination;
        ChangesProcessor marker = new ChangesProcessor(context, chunk, allCompiledFiles, caches2);
        marker.processChanges(changesInfo);
        return ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl doCompileModuleChunk(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            void destination;
            void $receiver;
            Iterable $receiver2;
            Collection collection = filesToCompile.values();
            Object object = new StringBuilder().append("Compiling to JS ");
            StringBuilder stringBuilder = new StringBuilder();
            Logger logger = Companion.getLOG();
            int n = $receiver2.size();
            $receiver2 = filesToCompile.keySet();
            stringBuilder = stringBuilder.append(((StringBuilder)object).append(n).append(" files in ").toString());
            Iterable $i$f$size = $receiver2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
                object = destination;
                String string = it.getPresentableName();
                object.add(string);
            }
            object = (List)destination;
            logger.debug(stringBuilder.append(StringsKt.join$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (int)31)).toString());
            return this.compileToJs(chunk, commonArguments, environment, null, messageCollector, project);
        }
        if (IncrementalCompilation.isEnabled()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalCacheImpl cache;
                List list;
                void destination;
                void $receiver;
                void $receiver3;
                if (incrementalCaches.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Iterable item = dirtyFilesHolder.getRemovedFiles((BuildTarget)target);
                Collection collection = filesToCompile.get((Object)target);
                void it = $receiver3;
                Collection $i$a$1 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
                for (Object item2 : $receiver) {
                    void it2;
                    String string = (String)item2;
                    list = destination;
                    File file = new File((String)it2);
                    list.add(file);
                }
                list = (List)destination;
                List removedAndDirtyFiles = CollectionsKt.plus((Collection)collection, (Iterable)list);
                cache.markOutputClassesDirty(removedAndDirtyFiles);
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.2 concatenate$ = doCompileModuleChunk.2.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.pluginOptions;
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.pluginOptions = concatenate$.invoke(stringArray, argumentProvider.getExtraArguments(moduleBuildTarget, context));
            String[] stringArray2 = commonArguments.pluginClasspaths;
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            commonArguments.pluginClasspaths = concatenate$.invoke(stringArray2, argumentProvider.getClasspath(moduleBuildTarget2, context));
            messageCollector.report(CompilerMessageSeverity.INFO, "Plugin loaded: " + argumentProvider.getClass().getSimpleName(), CompilerMessageLocation.Companion.getNO_LOCATION());
        }
        return this.compileToJvm(allCompiledFiles, chunk, commonArguments, context, dirtyFilesHolder, environment, filesToCompile, messageCollector);
    }

    private final CompilerEnvironment createCompileEnvironment(Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches, LookupTracker lookupTracker, CompileContext context) {
        Services compilerServices2 = new Services.Builder().register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches, lookupTracker)).register(CompilationCanceledStatus.class, new CompilationCanceledStatus(context){
            final /* synthetic */ CompileContext $context;

            public void checkCanceled() {
                if (this.$context.getCancelStatus().isCanceled()) {
                    throw (Throwable)((Object)new CompilationCanceledException());
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        }).build();
        CompilerEnvironment compilerEnvironment = CompilerEnvironment.getEnvironmentFor(PathUtil.getKotlinPathsForJpsPluginOrJpsTests(), createCompileEnvironment.1.INSTANCE, compilerServices2);
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerEnvironment, (String)"CompilerEnvironment.getE\u2026ompilerServices\n        )");
        return compilerEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeneratedFile> getGeneratedFiles(ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $receiver;
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        Collection collection = chunk.getTargets();
        if ($receiver.size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (File file : KotlinSourceFileCollector.getAllKotlinSourceFiles(target)) {
                    sourceToTarget.put(file, target);
                }
            }
        }
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        for (SimpleOutputItem outputItem : outputItemCollector.getOutputs()) {
            File target;
            File file;
            File file2;
            File outputFile;
            Collection<File> sourceFiles;
            block13: {
                void destination;
                void $receiver2;
                Object it;
                Iterable $receiver3;
                block12: {
                    sourceFiles = outputItem.getSourceFiles();
                    outputFile = outputItem.getOutputFile();
                    file2 = (File)CollectionsKt.firstOrNull((Iterable)sourceFiles);
                    if (file2 == null) break block12;
                    File file3 = file2;
                    it = (File)((Object)$receiver3);
                    file2 = (ModuleBuildTarget)sourceToTarget.get(it);
                    if (file2 != null) break block13;
                }
                $receiver3 = chunk.getTargets();
                it = $receiver3;
                Collection $i$a$1 = new ArrayList();
                for (Object element : $receiver2) {
                    boolean bl;
                    ModuleBuildTarget it2 = (ModuleBuildTarget)element;
                    if (it2.getOutputDir() != null) {
                        void $receiver4;
                        File it3;
                        File file4 = it3 = (File)$receiver4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
                        bl = FilesKt.startsWith((File)outputFile, (File)file4);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination.add(element);
                }
                file2 = file = (ModuleBuildTarget)CollectionsKt.singleOrNull((List)((List)destination));
            }
            if (file2 == null) {
                file = target = representativeTarget;
            }
            if (StringsKt.endsWith$default((String)outputFile.getName(), (String)".class", (boolean)false, (int)2)) {
                File file5 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"target");
                Collection<File> collection2 = sourceFiles;
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"sourceFiles");
                File file6 = outputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"outputFile");
                result.add(new GeneratedJvmClass((ModuleBuildTarget)file5, collection2, file6));
                continue;
            }
            File file7 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"target");
            Collection<File> collection3 = sourceFiles;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"sourceFiles");
            File file8 = outputFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"outputFile");
            result.add(new GeneratedFile((ModuleBuildTarget)file7, collection3, file8));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(ModuleChunk chunk, boolean compilationErrors, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile, List<? extends GeneratedJvmClass> generatedClasses) {
        Collection collection;
        Function2<GeneratedJvmClass, Mappings, Collection<? extends File>> getOldSourceFiles$ = new Function2<GeneratedJvmClass, Mappings, Collection<? extends File>>(filesToCompile, dirtyFilesHolder){
            final /* synthetic */ MultiMap $filesToCompile;
            final /* synthetic */ DirtyFilesHolder $dirtyFilesHolder;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<File> invoke(@NotNull GeneratedJvmClass generatedClass, @NotNull Mappings previousMappings) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
                Intrinsics.checkParameterIsNotNull((Object)previousMappings, (String)"previousMappings");
                if (!StringsKt.endsWith$default((String)generatedClass.getOutputFile().getName(), (String)("Package" + ".class"), (boolean)false, (int)2)) {
                    return SetsKt.emptySet();
                }
                LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
                if (!KotlinClassHeaderKt.isCompatiblePackageFacadeKind((KotlinClassHeader)kotlinClass.getClassHeader())) {
                    return SetsKt.emptySet();
                }
                String classInternalName = JvmClassName.byClassId((ClassId)kotlinClass.getClassId()).getInternalName();
                Collection oldClassSources = previousMappings.getClassSources(previousMappings.getName(classInternalName));
                if (oldClassSources == null) {
                    return SetsKt.emptySet();
                }
                THashSet sources = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                sources.addAll(oldClassSources);
                Collection collection = this.$filesToCompile.get((Object)generatedClass.getTarget());
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile[generatedClass.target]");
                sources.removeAll(collection);
                Iterable iterable = this.$dirtyFilesHolder.getRemovedFiles((BuildTarget)generatedClass.getTarget());
                THashSet tHashSet = sources;
                void var8_9 = $receiver2;
                Collection collection2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (T item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                tHashSet.removeAll((Collection)list);
                return (Collection)sources;
            }
            {
                this.$filesToCompile = multiMap;
                this.$dirtyFilesHolder = dirtyFilesHolder;
                super(2);
            }
        };
        if (!IncrementalCompilation.isEnabled()) {
            return;
        }
        Mappings previousMappings = context.getProjectDescriptor().dataManager.getMappings();
        Mappings delta = previousMappings.createDelta();
        Callbacks.Backend callback = delta.getCallback();
        for (GeneratedJvmClass generatedJvmClass : generatedClasses) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            File outputFile = generatedJvmClass.getOutputFile();
            LocalFileKotlinClass outputClass = generatedJvmClass.getOutputClass();
            Mappings mappings = previousMappings;
            Intrinsics.checkExpressionValueIsNotNull((Object)mappings, (String)"previousMappings");
            List allSourcesIncludingOld = CollectionsKt.plus(getOldSourceFiles$.invoke(generatedJvmClass, mappings), (Iterable)generatedJvmClass.getSourceFiles());
            Iterable iterable = allSourcesIncludingOld;
            String string = FileUtil.toSystemIndependentName((String)outputFile.getAbsolutePath());
            Callbacks.Backend backend = callback;
            void var17_18 = $receiver2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file = (File)item;
                list = destination;
                String string2 = FileUtil.toSystemIndependentName((String)it.getAbsolutePath());
                list.add(string2);
            }
            list = (List)destination;
            backend.associate(string, (Collection)list, new ClassReader(outputClass.getFileContents()));
        }
        Collection collection3 = filesToCompile.values();
        if (compilationErrors) {
            collection = CollectionsKt.listOf();
        } else {
            Collection collection4 = collection3;
            collection = collection4;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"allCompiled");
        }
        Collection compiledInThisRound = collection;
        JavaBuilderUtil.updateMappings((CompileContext)context, (Mappings)delta, dirtyFilesHolder, (ModuleChunk)chunk, (Collection)collection3, (Collection)compiledInThisRound);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, List<? extends GeneratedFile> generatedFiles) {
        for (GeneratedFile generatedFile : generatedFiles) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)generatedFile.getTarget();
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            void var6_6 = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file2 = (File)item;
                list = destination;
                String string = it.getPath();
                list.add(string);
            }
            list = (List)destination;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ChangesInfo updateKotlinIncrementalCache(boolean compilationErrors, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, List<? extends GeneratedFile> generatedFiles, ModuleChunk chunk) {
        void changesInfo;
        Ref.ObjectRef $receiver;
        if (!IncrementalCompilation.isEnabled()) {
            return ChangesInfo.Companion.getNO_CHANGES();
        }
        Iterable iterable = chunk.getTargets();
        for (Object element : $receiver) {
            ModuleBuildTarget it = (ModuleBuildTarget)element;
            IncrementalCacheImpl incrementalCacheImpl = incrementalCaches.get(it);
            if (incrementalCacheImpl == null) {
                Intrinsics.throwNpe();
            }
            incrementalCacheImpl.saveCacheFormatVersion();
        }
        $receiver = new Ref.ObjectRef();
        $receiver.element = ChangesInfo.Companion.getNO_CHANGES();
        for (GeneratedFile generatedFile : generatedFiles) {
            ChangesInfo changesInfo2;
            IncrementalCacheImpl ic;
            if (incrementalCaches.get(generatedFile.getTarget()) == null) {
                Intrinsics.throwNpe();
            }
            if (generatedFile instanceof GeneratedJvmClass) {
                changesInfo2 = ic.saveFileToCache((GeneratedJvmClass)generatedFile);
            } else {
                if (!this.isModuleMappingFile(generatedFile.getOutputFile())) continue;
                changesInfo2 = ic.saveModuleMappingToCache(generatedFile.getSourceFiles(), generatedFile.getOutputFile());
            }
            ChangesInfo newChangesInfo = changesInfo2;
            changesInfo.element = ((ChangesInfo)changesInfo.element).plus(newChangesInfo);
        }
        if (!compilationErrors) {
            Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> map = incrementalCaches;
            Iterable iterable2 = map.values();
            for (Object element : iterable2) {
                IncrementalCacheImpl it = (IncrementalCacheImpl)element;
                ChangesInfo newChangesInfo = it.clearCacheForRemovedClasses();
                changesInfo.element = ((ChangesInfo)changesInfo.element).plus(newChangesInfo);
            }
        }
        return (ChangesInfo)changesInfo.element;
    }

    private final boolean isModuleMappingFile(File $receiver) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$receiver), (Object)ModuleMapping.Companion.getMAPPING_FILE_EXT()) && Intrinsics.areEqual((Object)$receiver.getParentFile().getName(), (Object)"META-INF");
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJs(ModuleChunk chunk, CommonCompilerArguments commonArguments, CompilerEnvironment environment, Map<TargetId, IncrementalCache> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        K2JSCompilerArguments k2JsArguments;
        Iterable $receiver;
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Collection collection = chunk.getModules();
        if ($receiver.size() > 1) {
            List list;
            void destination;
            void $receiver2;
            $receiver = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are not supported. The following JS modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
            MessageCollectorAdapter messageCollectorAdapter = messageCollector;
            Iterable $i$f$size = $receiver;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10));
            for (Object item : $receiver2) {
                void it;
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            messageCollectorAdapter.report(compilerMessageSeverity, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin is not compiled for these modules").toString(), CompilerMessageLocation.Companion.getNO_LOCATION());
            return null;
        }
        List<File> sourceFiles = KotlinSourceFileCollector.getAllKotlinSourceFiles(representativeTarget);
        if (sourceFiles.isEmpty()) {
            return null;
        }
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        String moduleName = representativeTarget.getModule().getName();
        File file = outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        String string = moduleName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
        File outputFile = JpsJsModuleUtils.getOutputFile(file, string);
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        List<String> libraryFiles = JpsJsModuleUtils.INSTANCE.getLibraryFilesAndDependencies(moduleBuildTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        K2JSCompilerArguments k2JSCompilerArguments = k2JsArguments = JpsKotlinCompilerSettings.getK2JsCompilerArguments(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JSCompilerArguments, (String)"k2JsArguments");
        CompilerSettings compilerSettings2 = compilerSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerSettings2, (String)"compilerSettings");
        MessageCollector messageCollector2 = messageCollector;
        OutputItemsCollector outputItemsCollector = outputItemCollector;
        Collection collection3 = sourceFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"sourceFiles");
        KotlinCompilerRunner.INSTANCE.runK2JsCompiler(commonArguments, k2JSCompilerArguments, compilerSettings2, messageCollector2, environment, outputItemsCollector, collection3, libraryFiles, outputFile);
        return outputItemCollector;
    }

    private final void copyJsLibraryFilesIfNeeded(ModuleChunk chunk, JpsProject project) {
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        if (compilerSettings.getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(outputDir, compilerSettings.getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            ArrayList libraryFilesToCopy = CollectionsKt.arrayListOf((Object[])new String[0]);
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            JpsJsModuleUtils.INSTANCE.getLibraryFiles(moduleBuildTarget, libraryFilesToCopy);
            List list = libraryFilesToCopy;
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            LibraryUtils.copyJsFilesFromLibraries(list, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJvm(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, MessageCollectorAdapter messageCollector) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        Collection $receiver3;
        List<File> removedFilesInTarget;
        Collection it;
        Object object;
        MessageCollectorAdapter messageCollectorAdapter;
        Object object2;
        Object object3;
        Iterable $receiver4;
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        Collection collection = chunk.getModules();
        if ($receiver4.size() > 1) {
            void destination2;
            void $receiver5;
            $receiver4 = chunk.getModules();
            object3 = new StringBuilder().append("Circular dependencies are only partially supported. The following modules depend on each other: ");
            object2 = CompilerMessageSeverity.WARNING;
            messageCollectorAdapter = messageCollector;
            Iterable $i$f$size = $receiver4;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
            for (Object item : $receiver5) {
                JpsModule jpsModule = (JpsModule)item;
                object = destination2;
                String string = it.getName();
                object.add(string);
            }
            object = (List)destination2;
            messageCollectorAdapter.report((CompilerMessageSeverity)((Object)object2), ((StringBuilder)object3).append(CollectionsKt.joinToString$default((Iterable)((Iterable)object), (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin will compile them, but some strange effect may happen").toString(), CompilerMessageLocation.Companion.getNO_LOCATION());
        }
        Collection collection3 = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection3);
        Set<ModuleBuildTarget> processedTargetsWithRemoved = KotlinBuilderKt.access$getProcessedTargetsWithRemovedFilesContainer(context);
        int totalRemovedFiles = 0;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            removedFilesInTarget = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, target);
            if (removedFilesInTarget.isEmpty()) continue;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            if (!processedTargetsWithRemoved.add(moduleBuildTarget)) continue;
            it = removedFilesInTarget;
            int n = totalRemovedFiles;
            int n2 = $receiver3.size();
            totalRemovedFiles = n + n2;
        }
        File moduleFile = KotlinBuilderModuleScriptGenerator.generateModuleDescription(context, chunk, filesToCompile, totalRemovedFiles != 0);
        if (moduleFile == null) {
            void destination3;
            void $receiver6;
            void $receiver7;
            Iterable iterable = filesToCompile.keySet();
            object2 = new StringBuilder().append("Not compiling, because no files affected: ");
            messageCollectorAdapter = Companion.getLOG();
            removedFilesInTarget = $receiver7;
            $receiver3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver7, (int)10));
            for (Object item : $receiver6) {
                void it2;
                ModuleBuildTarget $i$f$map = (ModuleBuildTarget)item;
                object3 = destination3;
                object = it2.getPresentableName();
                object3.add(object);
            }
            object3 = (List)destination3;
            messageCollectorAdapter.debug(((StringBuilder)object2).append(StringsKt.join$default((Iterable)((Iterable)object3), null, null, null, (int)0, null, (int)31)).toString());
            return null;
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        K2JVMCompilerArguments k2JvmArguments = JpsKotlinCompilerSettings.getK2JvmCompilerArguments(project);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        Collection $i$f$size = filesToCompile.values();
        object3 = new StringBuilder().append("Compiling to JVM ");
        object2 = new StringBuilder();
        messageCollectorAdapter = Companion.getLOG();
        int n = $receiver2.size();
        $receiver2 = filesToCompile.keySet();
        object2 = ((StringBuilder)object2).append(((StringBuilder)object3).append(n).append(" files").toString()).append(totalRemovedFiles == 0 ? "" : " (" + totalRemovedFiles + " removed files)").append(" in ");
        Iterable $i$f$size2 = $receiver2;
        Collection it2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it3;
            ModuleBuildTarget $i$f$map = (ModuleBuildTarget)item;
            object3 = destination;
            String string = it3.getPresentableName();
            object3.add(string);
        }
        object3 = (List)destination;
        messageCollectorAdapter.debug(((StringBuilder)object2).append(StringsKt.join$default((Iterable)((Iterable)object3), null, null, null, (int)0, null, (int)31)).toString());
        K2JVMCompilerArguments k2JVMCompilerArguments = k2JvmArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JVMCompilerArguments, (String)"k2JvmArguments");
        CompilerSettings compilerSettings2 = compilerSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerSettings2, (String)"compilerSettings");
        KotlinCompilerRunner.INSTANCE.runK2JvmCompiler(commonArguments, k2JVMCompilerArguments, compilerSettings2, messageCollector, environment, moduleFile, outputItemCollector);
        moduleFile.delete();
        return outputItemCollector;
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002S/!1\tS\u0001\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!K\b\u0005\u0007\"A9!D\u0003\u0011\nU\u0011A\u0012\u0001\r\u00051\u0011\t6!B\u0003\u0002\u0019\u0003i!\u0001B\u0003\t\f%\u0012Ba\u0011\u0005\t\r5A\u0011BB\u0005\u0006\u0013\r!\t!C\u0001\u0019\u0010a9\u0001TB)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t!A\t\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "KOTLIN_BUILDER_NAME", "", "getKOTLIN_BUILDER_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOOKUP_TRACKER", "Lorg/jetbrains/jps/model/ex/JpsElementChildRoleBase;", "Lorg/jetbrains/jps/model/JpsSimpleElement;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "getLOOKUP_TRACKER", "()Lorg/jetbrains/jps/model/ex/JpsElementChildRoleBase;"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getKOTLIN_BUILDER_NAME() {
            return KOTLIN_BUILDER_NAME;
        }

        @NotNull
        public final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> getLOOKUP_TRACKER() {
            return LOOKUP_TRACKER;
        }

        public final Logger getLOG() {
            return LOG;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003\u0011)Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tA\u0002A\r\u00021\u0003\t\u000b$C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\r!\u0019Q\u0002B\u0005\u0003\u0013\u0005AB\u0001g\u0002\n\r!%Q\u0002B\u0005\u0003\u0013\u0005AZ\u0001G\u0003R\u0007\u0005Aa!J\u0004\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001\u0007\u0007&\t\u0011\t\u0001\u0012D\u0007\u00021-)c\u0001B\u0001\t\u001b5\t\u0001dC\u000b\u000211IS\u0002B\"\t\u0011\riA!\u0003\u0002\n\u0003a!\u0001tA)\u0004\t\u0015\u0001QB\u0001C\u0007\u0011\u001dIS\u0002B\"\t\u0011\u0013iA!\u0003\u0002\n\u0003a-\u0001$B)\u0004\t\u0015\u0001QB\u0001C\b\u0011!I#\u0002B\"\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0012!I\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t'A!\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$ChangesProcessor;", "", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "allCompiledFiles", "", "Ljava/io/File;", "caches", "", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;Ljava/util/Set;Ljava/util/List;)V", "getAllCompiledFiles", "()Ljava/util/Set;", "getCaches", "()Ljava/util/List;", "getChunk", "()Lorg/jetbrains/jps/ModuleChunk;", "getContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "processChanges", "", "changesInfo", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "recompileInlined", "doProcessChanges"}, moduleName="jps-plugin")
    public static final class ChangesProcessor {
        @NotNull
        private final CompileContext context;
        @NotNull
        private final ModuleChunk chunk;
        @NotNull
        private final Set<File> allCompiledFiles;
        @NotNull
        private final List<? extends IncrementalCacheImpl> caches;

        public final void processChanges(@NotNull ChangesInfo changesInfo) {
            Intrinsics.checkParameterIsNotNull((Object)changesInfo, (String)"changesInfo");
            this.doProcessChanges(changesInfo);
        }

        private final void doProcessChanges(ChangesInfo $receiver) {
            doProcessChanges.1 isKotlin$ = doProcessChanges.1.INSTANCE;
            Function1<File, Boolean> isNotCompiled$ = new Function1<File, Boolean>(this){
                final /* synthetic */ ChangesProcessor this$0;

                public final boolean invoke(@NotNull File file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    return this.this$0.getAllCompiledFiles().contains(file) ^ true;
                }
                {
                    this.this$0 = changesProcessor;
                    super(1);
                }
            };
            if ($receiver.getInlineAdded()) {
                this.allCompiledFiles.clear();
                Function1 function1 = (Function1)Reflection.function((FunctionReference)doProcessChanges.3.INSTANCE);
                FSOperations.markDirtyRecursively((CompileContext)this.context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)((FileFilter)(function1 == null ? null : new KotlinBuilderKt$sam$FileFilter$23290363(function1))));
                return;
            }
            if ($receiver.getConstantsChanged()) {
                Function1 function1 = (Function1)Reflection.function((FunctionReference)new Function1<File, Boolean>(isNotCompiled$){
                    final /* synthetic */ doProcessChanges.2 $isNotCompiled;

                    public final boolean invoke(@NotNull File p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return this.$isNotCompiled.invoke(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return null;
                    }

                    public final String getName() {
                        return "isNotCompiled";
                    }

                    public final String getSignature() {
                        return "invoke(Ljava/io/File;)Z";
                    }
                    {
                        this.$isNotCompiled = var1_1;
                        super(1);
                    }
                });
                FSOperations.markDirtyRecursively((CompileContext)this.context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)((FileFilter)(function1 == null ? null : new KotlinBuilderKt$sam$FileFilter$23290363(function1))));
                return;
            }
            if ($receiver.getProtoChanged()) {
                FSOperations.markDirty((CompileContext)this.context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)new FileFilter(isNotCompiled$){
                    final /* synthetic */ doProcessChanges.2 $isNotCompiled;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean accept(File it) {
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        if (!doProcessChanges.1.INSTANCE.invoke(file)) return false;
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        if (!this.$isNotCompiled.invoke(file2)) return false;
                        return true;
                    }
                    {
                        this.$isNotCompiled = var1_1;
                    }
                });
            }
            if ($receiver.getInlineChanged()) {
                this.recompileInlined();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void recompileInlined() {
            for (IncrementalCacheImpl incrementalCacheImpl : this.caches) {
                void $receiver;
                Collection<File> filesToReinline = incrementalCacheImpl.getFilesToReinline();
                Iterable iterable = filesToReinline;
                for (Object element : $receiver) {
                    File it = (File)element;
                    FSOperations.markDirty((CompileContext)this.getContext(), (CompilationRound)CompilationRound.NEXT, (File)it);
                }
            }
        }

        @NotNull
        public final CompileContext getContext() {
            return this.context;
        }

        @NotNull
        public final ModuleChunk getChunk() {
            return this.chunk;
        }

        @NotNull
        public final Set<File> getAllCompiledFiles() {
            return this.allCompiledFiles;
        }

        @NotNull
        public final List<IncrementalCacheImpl> getCaches() {
            return this.caches;
        }

        public ChangesProcessor(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull Set<File> allCompiledFiles, @NotNull List<? extends IncrementalCacheImpl> caches2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            Intrinsics.checkParameterIsNotNull(allCompiledFiles, (String)"allCompiledFiles");
            Intrinsics.checkParameterIsNotNull(caches2, (String)"caches");
            this.context = context;
            this.chunk = chunk;
            this.allCompiledFiles = allCompiledFiles;
            this.caches = caches2;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K!!\u0011\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0005\u0005\u0003!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\r\u0015\u0002Ba\u0003E\u0007\u001b\u0005Ar!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u001fi\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0007S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "kind", "Lorg/jetbrains/jps/incremental/messages/BuildMessage$Kind;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "renderLocationIfNeeded", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "report", "", "message"}, moduleName="jps-plugin")
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        private final CompileContext context;

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            String prefix = "";
            if (Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                prefix = "[Internal Error] ";
            }
            this.context.processMessage((BuildMessage)new CompilerMessage("Kotlin", this.kind(severity), prefix + message + this.renderLocationIfNeeded(location), location.getPath(), (long)(-1), (long)(-1), (long)(-1), (long)location.getLine(), (long)location.getColumn()));
        }

        private final String renderLocationIfNeeded(CompilerMessageLocation location) {
            if (Intrinsics.areEqual((Object)location, (Object)CompilerMessageLocation.Companion.getNO_LOCATION())) {
                return "";
            }
            String pathname = "" + location.getPath();
            return new File(pathname).exists() ? "" : " (" + location + ")";
        }

        private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            CompilerMessageSeverity compilerMessageSeverity = severity;
            if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.INFO))) {
                kind = BuildMessage.Kind.INFO;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.ERROR)) || Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                kind = BuildMessage.Kind.ERROR;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.WARNING))) {
                kind = BuildMessage.Kind.WARNING;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.LOGGING))) {
                kind = BuildMessage.Kind.PROGRESS;
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
            }
            return kind;
        }

        public MessageCollectorAdapter(@NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }
}

