/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Collection;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001B1\u0002\u0019\u0001Ir!C\u0003\n\t%\u0011\u0011\"\u0001M\u00021\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001\u0003\u0002&\u0017\u0011Y\u0001RA\u0007\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003e\u0019\u0001bA\u0007\u00021\u000f)s\u0002B\u0006\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\r!1Q\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/PathCollectionExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value"}, moduleName="jps-plugin")
public final class PathCollectionExternalizer
implements DataExternalizer<Collection<? extends String>> {
    public static final PathCollectionExternalizer INSTANCE;
    public static final PathCollectionExternalizer INSTANCE$;

    public void save(@NotNull DataOutput out, @NotNull Collection<? extends String> value) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        for (String string : value) {
            IOUtil.writeUTF((DataOutput)out, (String)string);
        }
    }

    @NotNull
    public Collection<String> read(@NotNull DataInput in) {
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        DataInput dataInput = in;
        if (dataInput == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.DataInputStream");
        }
        DataInputStream stream = (DataInputStream)dataInput;
        while (stream.available() > 0) {
            String str = IOUtil.readUTF((DataInput)stream);
            result.add((Object)str);
        }
        return (Collection)result;
    }

    static {
        new PathCollectionExternalizer();
    }

    private PathCollectionExternalizer() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

