/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import java.util.List;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.ArrayInitializer;
import lombok.ast.ClassDeclaration;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.DanglingNodes;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.ImportDeclaration;
import lombok.ast.InstanceInitializer;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.StaticInitializer;
import lombok.ast.TypeBody;
import lombok.ast.TypeReference;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;
import lombok.ast.grammar.TemporaryNode;

public class StructuresActions
extends SourceActions {
    public StructuresActions(Source source) {
        super(source);
    }

    public Node createMethodArguments(Node head, List<Node> tail) {
        TemporaryNode.MethodArguments ma = new TemporaryNode.MethodArguments();
        if (head != null) {
            ma.arguments.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                ma.arguments.add(n);
            }
        }
        return this.posify(ma);
    }

    public Node createKeywordModifier(String text) {
        return this.posify(new KeywordModifier().astName(text));
    }

    public Node createMethodDeclaration(Node modifiers, Node typeParameters, Node resultType, Node name, Node params, List<org.parboiled.Node<Node>> dims, Node throwsHead, List<Node> throwsTail, Node body) {
        MethodDeclaration decl = new MethodDeclaration();
        if (params instanceof TemporaryNode.MethodParameters) {
            for (Node param : ((TemporaryNode.MethodParameters)params).parameters) {
                decl.rawParameters().addToEnd(param);
            }
        } else {
            DanglingNodes.addDanglingNode(decl, params);
        }
        decl.astMethodName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        int extraDims = dims == null ? 0 : dims.size();
        Node returnType = resultType;
        if (extraDims > 0 && returnType instanceof TypeReference) {
            ((TypeReference)returnType).astArrayDimensions(((TypeReference)returnType).astArrayDimensions() + extraDims);
        }
        decl.rawReturnTypeReference(returnType);
        if (typeParameters instanceof TemporaryNode.OrphanedTypeVariables) {
            TemporaryNode.OrphanedTypeVariables otv = (TemporaryNode.OrphanedTypeVariables)typeParameters;
            if (otv.variables != null) {
                for (Node typeParameter : otv.variables) {
                    if (typeParameter == null) continue;
                    decl.rawTypeVariables().addToEnd(typeParameter);
                }
            }
        }
        for (org.parboiled.Node<Node> dim : dims) {
            for (org.parboiled.Node dimSub : dim.getChildren()) {
                this.source.registerStructure(decl, (org.parboiled.Node<Node>)dimSub);
            }
        }
        if (throwsHead != null) {
            decl.rawThrownTypeReferences().addToEnd(throwsHead);
        }
        if (throwsTail != null) {
            for (Node n : throwsTail) {
                if (n == null) continue;
                decl.rawThrownTypeReferences().addToEnd(n);
            }
        }
        return this.posify(decl);
    }

    public Node createConstructorDeclaration(Node modifiers, Node typeParameters, Node name, Node params, Node throwsHead, List<Node> throwsTail, Node body) {
        ConstructorDeclaration decl = new ConstructorDeclaration().astTypeName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        if (typeParameters instanceof TemporaryNode.OrphanedTypeVariables) {
            for (Node typeParameter : ((TemporaryNode.OrphanedTypeVariables)typeParameters).variables) {
                decl.rawTypeVariables().addToEnd(typeParameter);
            }
        }
        if (params instanceof TemporaryNode.MethodParameters) {
            for (Node param : ((TemporaryNode.MethodParameters)params).parameters) {
                decl.rawParameters().addToEnd(param);
            }
        } else {
            DanglingNodes.addDanglingNode(decl, params);
        }
        if (throwsHead != null) {
            decl.rawThrownTypeReferences().addToEnd(throwsHead);
        }
        if (throwsTail != null) {
            for (Node n : throwsTail) {
                if (n == null) continue;
                decl.rawThrownTypeReferences().addToEnd(n);
            }
        }
        return this.posify(decl);
    }

    public Node createModifiers(List<Node> values) {
        Modifiers result = new Modifiers();
        if (values != null) {
            for (Node n : values) {
                if (n instanceof Annotation) {
                    result.rawAnnotations().addToEnd(n);
                }
                if (!(n instanceof KeywordModifier)) continue;
                result.rawKeywords().addToEnd(n);
            }
        }
        return this.posify(result);
    }

    public Node createMethodParameter(Node modifiers, Node type, String varargs, Node name, List<org.parboiled.Node<Node>> dimOpen, List<org.parboiled.Node<Node>> dimClosed) {
        VariableDefinitionEntry e = new VariableDefinitionEntry().astName(this.createIdentifierIfNeeded(name, this.currentPos())).astArrayDimensions(dimOpen == null ? 0 : dimOpen.size());
        if (dimOpen != null) {
            for (org.parboiled.Node<Node> pNode : dimOpen) {
                this.source.registerStructure(e, pNode);
            }
        }
        if (dimClosed != null) {
            for (org.parboiled.Node<Node> pNode : dimClosed) {
                this.source.registerStructure(e, pNode);
            }
        }
        if (name != null) {
            e.setPosition(new Position(name.getPosition().getStart(), this.currentPos()));
        }
        VariableDefinition decl = new VariableDefinition().rawTypeReference(type);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        if (varargs != null && !varargs.trim().isEmpty()) {
            decl.astVarargs(true);
        }
        decl.rawVariables().addToEnd(e);
        return this.posify(decl);
    }

    public Node createInstanceInitializer(Node body) {
        return this.posify(new InstanceInitializer().rawBody(body));
    }

    public Node createStaticInitializer(Node body) {
        return this.posify(new StaticInitializer().rawBody(body));
    }

    public Node createFieldDeclaration(Node variableDefinition, Node modifiers) {
        if (modifiers != null && variableDefinition instanceof VariableDefinition) {
            ((VariableDefinition)variableDefinition).astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        return this.posify(new VariableDeclaration().rawDefinition(variableDefinition));
    }

    public Node createVariableDefinitionPart(Node varName, List<String> dims, Node initializer) {
        return this.posify(new VariableDefinitionEntry().astName(this.createIdentifierIfNeeded(varName, this.currentPos())).rawInitializer(initializer).astArrayDimensions(dims == null ? 0 : dims.size()));
    }

    public Node createVariableDefinition(Node type, Node head, List<Node> tail) {
        VariableDefinition result = new VariableDefinition().rawTypeReference(type);
        if (head != null) {
            result.rawVariables().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.rawVariables().addToEnd(n);
            }
        }
        return this.posify(result);
    }

    public Node createAnnotationElementValueArrayInitializer(Node head, List<Node> tail) {
        ArrayInitializer result = new ArrayInitializer();
        if (head != null) {
            result.rawExpressions().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.rawExpressions().addToEnd(n);
            }
        }
        return this.posify(result);
    }

    public Node createAnnotationElement(Node name, Node value) {
        return this.posify(new AnnotationElement().astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawValue(value));
    }

    public Node createAnnotationFromElements(Node head, List<Node> tail) {
        Annotation result = new Annotation();
        if (head != null) {
            result.rawElements().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.rawElements().addToEnd(n);
            }
        }
        return this.posify(result);
    }

    public Node createAnnotationFromElement(Node value) {
        Annotation result = new Annotation();
        if (value != null) {
            result.rawElements().addToEnd(this.posify(new AnnotationElement().rawValue(value)));
        }
        return this.posify(result);
    }

    public Node createAnnotation(Node type, Node annotation) {
        if (annotation instanceof Annotation) {
            return this.posify(((Annotation)annotation).rawAnnotationTypeReference(type));
        }
        return this.posify(new Annotation().rawAnnotationTypeReference(type));
    }

    public Node createExtendsClause(Node head, List<Node> tail) {
        TemporaryNode.ExtendsClause result = new TemporaryNode.ExtendsClause();
        if (head != null) {
            result.superTypes.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.superTypes.add(n);
            }
        }
        return this.posify(result);
    }

    public Node createImplementsClause(Node head, List<Node> tail) {
        TemporaryNode.ImplementsClause result = new TemporaryNode.ImplementsClause();
        if (head != null) {
            result.superInterfaces.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.superInterfaces.add(n);
            }
        }
        return this.posify(result);
    }

    public Node createInterfaceDeclaration(Node modifiers, Node name, Node params, Node body, List<Node> addons) {
        InterfaceDeclaration decl = new InterfaceDeclaration().astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        if (params instanceof TemporaryNode.OrphanedTypeVariables) {
            TemporaryNode.OrphanedTypeVariables otv = (TemporaryNode.OrphanedTypeVariables)params;
            if (otv.variables != null) {
                for (Node typeParameter : otv.variables) {
                    if (typeParameter == null) continue;
                    decl.rawTypeVariables().addToEnd(typeParameter);
                }
            }
        }
        if (addons != null) {
            for (Node n : addons) {
                List<Node> superClasses;
                if (!(n instanceof TemporaryNode.ExtendsClause) || (superClasses = ((TemporaryNode.ExtendsClause)n).superTypes) == null) continue;
                for (Node superClass : superClasses) {
                    if (superClass == null) continue;
                    decl.rawExtending().addToEnd(superClass);
                }
            }
        }
        return this.posify(decl);
    }

    public Node createTypeDeclaration(String kind, Node modifiers, Node name, Node params, Node body, List<Node> addons) {
        if (kind.equals("interface")) {
            return this.createInterfaceDeclaration(modifiers, name, params, body, addons);
        }
        ClassDeclaration decl = new ClassDeclaration().astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        if (params instanceof TemporaryNode.OrphanedTypeVariables) {
            TemporaryNode.OrphanedTypeVariables otv = (TemporaryNode.OrphanedTypeVariables)params;
            if (otv.variables != null) {
                for (Node typeParameter : otv.variables) {
                    if (typeParameter == null) continue;
                    decl.rawTypeVariables().addToEnd(typeParameter);
                }
            }
        }
        if (addons != null) {
            for (Node n : addons) {
                List<Node> interfaces;
                List<Node> superClasses;
                if (n instanceof TemporaryNode.ExtendsClause && (superClasses = ((TemporaryNode.ExtendsClause)n).superTypes) != null && superClasses.size() > 0) {
                    decl.rawExtending(superClasses.get(0));
                }
                if (!(n instanceof TemporaryNode.ImplementsClause) || (interfaces = ((TemporaryNode.ImplementsClause)n).superInterfaces) == null) continue;
                for (Node i : interfaces) {
                    decl.rawImplementing().addToEnd(i);
                }
            }
        }
        return this.posify(decl);
    }

    public Node createNormalTypeBody(List<Node> values) {
        NormalTypeBody body = new NormalTypeBody();
        if (values != null) {
            for (Node n : values) {
                body.rawMembers().addToEnd(n);
            }
        }
        return this.posify(body);
    }

    public Node createEnumConstant(List<Node> annotations, Node name, Node arguments, Node body) {
        EnumConstant result = new EnumConstant().astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (annotations != null) {
            for (Node n : annotations) {
                if (n == null) continue;
                result.rawAnnotations().addToEnd(n);
            }
        }
        if (arguments instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)arguments).arguments) {
                result.rawArguments().addToEnd(arg);
            }
        }
        return this.posify(result);
    }

    public Node createEnumBody(Node head, List<Node> tail, Node typeBody) {
        EnumTypeBody body = new EnumTypeBody();
        if (head != null) {
            body.rawConstants().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                body.rawConstants().addToEnd(n);
            }
        }
        if (typeBody instanceof TypeBody) {
            body.rawMembers().migrateAllFrom(((TypeBody)typeBody).rawMembers());
        }
        return this.posify(body);
    }

    public Node createEnumDeclaration(Node modifiers, Node name, Node body, List<Node> addons) {
        EnumDeclaration decl = new EnumDeclaration();
        decl.astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(body);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        if (addons != null) {
            for (Node n : addons) {
                List<Node> interfaces;
                if (!(n instanceof TemporaryNode.ImplementsClause) || (interfaces = ((TemporaryNode.ImplementsClause)n).superInterfaces) == null) continue;
                for (Node i : interfaces) {
                    decl.rawImplementing().addToEnd(i);
                }
            }
        }
        return this.posify(decl);
    }

    public Node createAnnotationDeclaration(Node modifiers, Node name, List<Node> members, org.parboiled.Node<Node> typeOpen, org.parboiled.Node<Node> typeClose) {
        Node typeBody = this.createNormalTypeBody(members);
        if (typeOpen != null && typeClose != null) {
            typeBody.setPosition(new Position(typeOpen.getStartIndex(), typeClose.getEndIndex()));
        }
        AnnotationDeclaration decl = new AnnotationDeclaration().astName(this.createIdentifierIfNeeded(name, this.currentPos())).rawBody(typeBody);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        return this.posify(decl);
    }

    public Node createAnnotationMethodDeclaration(Node modifiers, Node typeReference, Node name, List<org.parboiled.Node<Node>> dims, Node defaultValue) {
        AnnotationMethodDeclaration decl = new AnnotationMethodDeclaration().astMethodName(this.createIdentifierIfNeeded(name, this.currentPos())).rawDefaultValue(defaultValue);
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        int extraDims = dims == null ? 0 : dims.size();
        Node returnType = typeReference;
        if (extraDims > 0 && returnType instanceof TypeReference) {
            ((TypeReference)returnType).astArrayDimensions(((TypeReference)returnType).astArrayDimensions() + extraDims);
        }
        decl.rawReturnTypeReference(returnType);
        return this.posify(decl);
    }

    public Node createPackageDeclaration(List<Node> annotations, Node head, List<Node> tail) {
        PackageDeclaration decl = new PackageDeclaration();
        if (annotations != null) {
            for (Node n : annotations) {
                if (n == null) continue;
                decl.rawAnnotations().addToEnd(n);
            }
        }
        if (head != null) {
            decl.rawParts().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                decl.rawParts().addToEnd(n);
            }
        }
        return this.posify(decl);
    }

    public Node createImportDeclaration(String staticKeyword, Node head, List<Node> tail, String dotStar) {
        ImportDeclaration decl = new ImportDeclaration();
        if (head != null) {
            decl.rawParts().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                decl.rawParts().addToEnd(n);
            }
        }
        if (staticKeyword != null && staticKeyword.length() > 0) {
            decl.astStaticImport(true);
        }
        if (dotStar != null && dotStar.length() > 0) {
            decl.astStarImport(true);
        }
        return this.posify(decl);
    }

    public Node createCompilationUnit(Node packageDeclaration, List<Node> importDeclarations, List<Node> typeDeclarations) {
        CompilationUnit unit = new CompilationUnit().rawPackageDeclaration(packageDeclaration);
        if (importDeclarations != null) {
            for (Node n : importDeclarations) {
                if (n == null) continue;
                unit.rawImportDeclarations().addToEnd(n);
            }
        }
        if (typeDeclarations != null) {
            for (Node n : typeDeclarations) {
                if (n == null) continue;
                unit.rawTypeDeclarations().addToEnd(n);
            }
        }
        return this.posify(unit);
    }

    public Node createMethodParameters(Node head, List<Node> tail) {
        TemporaryNode.MethodParameters params = new TemporaryNode.MethodParameters();
        if (head != null) {
            params.parameters.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                params.parameters.add(n);
            }
        }
        return params;
    }

    public Node createEmptyDeclaration() {
        return this.posify(new EmptyDeclaration());
    }
}

