/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JvmName(name="SpecialBuiltinMembers")
public final class SpecialBuiltinMembers {
    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmName(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (BuiltinMethodsWithDifferentJvmName.INSTANCE.getORIGINAL_SHORT_NAMES().contains($receiver.getName()) ^ true && BuiltinSpecialProperties.INSTANCE.getSHORT_NAMES$kotlin_core().contains(SpecialBuiltinMembers.getPropertyIfAccessor($receiver).getName()) ^ true) {
            return (T)((CallableMemberDescriptor)null);
        }
        T t = $receiver;
        return (T)(t instanceof PropertyDescriptor || t instanceof PropertyAccessorDescriptor ? SpecialBuiltinMembers.firstOverridden($receiver, getOverriddenBuiltinWithDifferentJvmName.1.INSTANCE) : SpecialBuiltinMembers.firstOverridden($receiver, getOverriddenBuiltinWithDifferentJvmName.2.INSTANCE));
    }

    public static final boolean doesOverrideBuiltinWithDifferentJvmName(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver) != null;
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmDescriptor(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        T t = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver);
        if (t != null) {
            T $receiver2 = t;
            T it = $receiver2;
            return it;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters($receiver.getName())) {
            return (T)((CallableMemberDescriptor)null);
        }
        CallableMemberDescriptor callableMemberDescriptor = SpecialBuiltinMembers.firstOverridden($receiver, getOverriddenBuiltinWithDifferentJvmDescriptor.2.INSTANCE);
        return (T)(callableMemberDescriptor != null ? callableMemberDescriptor.getOriginal() : null);
    }

    @Nullable
    public static final String getJvmMethodNameIfSpecial(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        String string;
        CallableMemberDescriptor builtinOverridden;
        CallableMemberDescriptor callableMemberDescriptor2;
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (Intrinsics.areEqual(SpecialBuiltinMembers.getPropertyIfAccessor(callableMemberDescriptor).getName(), DescriptorUtils.ENUM_VALUES)) {
            DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
            if (callableMemberDescriptor instanceof PropertyAccessorDescriptor && containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.ENUM_CLASS)) {
                return DescriptorUtils.ENUM_VALUES.asString();
            }
        }
        if ((callableMemberDescriptor2 = SpecialBuiltinMembers.getBuiltinOverriddenThatAffectsJvmName(callableMemberDescriptor)) == null || (callableMemberDescriptor2 = SpecialBuiltinMembers.getPropertyIfAccessor(callableMemberDescriptor2)) == null) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor3 = builtinOverridden = callableMemberDescriptor2;
        if (callableMemberDescriptor3 instanceof PropertyDescriptor) {
            string = BuiltinSpecialProperties.INSTANCE.getBuiltinSpecialPropertyGetterName(builtinOverridden);
        } else {
            Name name = BuiltinMethodsWithDifferentJvmName.INSTANCE.getJvmName(builtinOverridden);
            string = name != null ? name.asString() : null;
        }
        return string;
    }

    private static final CallableMemberDescriptor getBuiltinOverriddenThatAffectsJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor overriddenBuiltin = callableMemberDescriptor2;
        if (SpecialBuiltinMembers.isFromJavaOrBuiltins(callableMemberDescriptor)) {
            return overriddenBuiltin;
        }
        return null;
    }

    private static final boolean isFromJava(CallableMemberDescriptor $receiver) {
        return SpecialBuiltinMembers.getPropertyIfAccessor($receiver) instanceof JavaCallableMemberDescriptor && SpecialBuiltinMembers.getPropertyIfAccessor($receiver).getContainingDeclaration() instanceof JavaClassDescriptor;
    }

    private static final boolean isFromBuiltins(CallableMemberDescriptor $receiver) {
        FqName fqName2 = SpecialBuiltinMembers.fqNameOrNull(SpecialBuiltinMembers.getPropertyIfAccessor($receiver));
        if (!(fqName2 != null ? fqName2.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME) : false)) {
            return false;
        }
        return Intrinsics.areEqual(DescriptorUtilsKt.getBuiltIns($receiver).getBuiltInsModule(), DescriptorUtilsKt.getModule($receiver));
    }

    private static final CallableMemberDescriptor getPropertyIfAccessor(CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        if ($receiver instanceof PropertyAccessorDescriptor) {
            CallableMemberDescriptor callableMemberDescriptor2 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            callableMemberDescriptor = callableMemberDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "correspondingProperty");
        } else {
            callableMemberDescriptor = $receiver;
        }
        return callableMemberDescriptor;
    }

    private static final FqName fqNameOrNull(CallableDescriptor $receiver) {
        FqNameUnsafe fqNameUnsafe = AddToStdlibKt.check(DescriptorUtilsKt.getFqNameUnsafe($receiver), fqNameOrNull.1.INSTANCE);
        return fqNameUnsafe != null ? fqNameUnsafe.toSafe() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final CallableMemberDescriptor firstOverridden(CallableMemberDescriptor $receiver, Function1<? super CallableMemberDescriptor, ? extends Boolean> predicate) {
        void result;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        return (CallableMemberDescriptor)DFS.dfs((Collection)CollectionsKt.listOf($receiver), new DFS.Neighbors<CallableMemberDescriptor>(){

            @NotNull
            public Iterable<CallableMemberDescriptor> getNeighbors(@Nullable CallableMemberDescriptor current) {
                Object object = current;
                if (object == null || (object = object.getOverriddenDescriptors()) == null) {
                    object = CollectionsKt.emptyList();
                }
                return (Iterable)object;
            }
        }, new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef)result, predicate){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $predicate;

            public boolean beforeChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                return (CallableMemberDescriptor)this.$result.element == null;
            }

            public void afterChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if ((CallableMemberDescriptor)this.$result.element == null && ((Boolean)this.$predicate.invoke(current)).booleanValue()) {
                    this.$result.element = current;
                }
            }

            @Nullable
            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
            {
                this.$result = $captured_local_variable$0;
                this.$predicate = $captured_local_variable$1;
            }
        });
    }

    public static final boolean isFromJavaOrBuiltins(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SpecialBuiltinMembers.isFromJava($receiver) || SpecialBuiltinMembers.isFromBuiltins($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, List<? extends Name>> getInversedShortNamesMap(Map<FqName, ? extends Name> $receiver) {
        void var3_3;
        Object list;
        Collection $receiver2;
        Name key;
        Object $receiver3;
        Object $receiver4 = $receiver;
        $receiver4 = $receiver4.entrySet();
        Object $i$f$entrySet = $receiver4;
        Map map2 = new LinkedHashMap();
        Iterator<Object> iterator2 = $receiver3.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element = iterator2.next();
            Map.Entry it = (Map.Entry)element;
            key = (Name)it.getValue();
            Map map3 = map2;
            Object value2 = $receiver2.get(key);
            if (value2 == null && !$receiver2.containsKey(key)) {
                ArrayList answer = new ArrayList();
                $receiver2.put(key, answer);
                object = answer;
            } else {
                object = value2;
            }
            list = (List)object;
            list.add(element);
        }
        $receiver4 = map2;
        $receiver3 = $receiver4;
        Map destination = new LinkedHashMap($receiver4.size());
        iterator2 = MapsKt.iterator($receiver3);
        while (iterator2.hasNext()) {
            void destination2;
            void $receiver5;
            void $receiver6;
            Map.Entry e;
            Map.Entry entry = e = (Map.Entry)iterator2.next();
            Iterable $i$a$1 = (Iterable)entry.getValue();
            key = $receiver6;
            $receiver2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver6, 10));
            for (Object item : $receiver5) {
                void it;
                list = (Map.Entry)item;
                void var13_13 = destination2;
                Name name = ((FqName)it.getKey()).shortName();
                var13_13.add(name);
            }
            List newValue = (List)destination2;
            destination.put(e.getKey(), newValue);
        }
        return var3_3;
    }

    @Nullable
    public static final /* synthetic */ FqName access$fqNameOrNull(CallableDescriptor $receiver) {
        return SpecialBuiltinMembers.fqNameOrNull($receiver);
    }

    public static final /* synthetic */ boolean access$isFromBuiltins(CallableMemberDescriptor $receiver) {
        return SpecialBuiltinMembers.isFromBuiltins($receiver);
    }

    @Nullable
    public static final /* synthetic */ CallableMemberDescriptor access$firstOverridden(CallableMemberDescriptor $receiver, @NotNull Function1<? super CallableMemberDescriptor, ? extends Boolean> predicate) {
        return SpecialBuiltinMembers.firstOverridden($receiver, predicate);
    }

    @NotNull
    public static final /* synthetic */ CallableMemberDescriptor access$getPropertyIfAccessor$p(CallableMemberDescriptor $receiver) {
        return SpecialBuiltinMembers.getPropertyIfAccessor($receiver);
    }

    @NotNull
    public static final /* synthetic */ Map<Name, List<? extends Name>> access$getInversedShortNamesMap(Map<FqName, ? extends Name> $receiver) {
        return SpecialBuiltinMembers.getInversedShortNamesMap($receiver);
    }
}

