/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\t\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AA#B\u0001\u0005\u00031\u0001\u0011$\u0001M\u0001CCI1\u0001C\u0001\u000e\u0003a\u0005\u0011\"\u0003E\u0002\u001b\u001dI!!C\u0001\u0019\u0006%\u0011\u0011\"\u0001\r\u00041\t\t6!\u0001E\u0004K%!1\u0002\u0003\u0003\u000e\u00051\u0005\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001'\u0002&\u0013\u0011Y\u00012B\u0007\u0003\u0019\u0003AJ!G\u0002\t\u000b5\t\u0001TA\u0013\b\t-Aa!\u0004\u0003\n\u0005%\t\u0001d\u0002M\u0007K\u001d!1\u0002c\u0004\u000e\t%\u0011\u0011\"\u0001\r\b1\u001b)C\u0001B\u0006\t\u00115\t\u0001dAS\b\t-#\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001'\u0003\u0019\u0013\u0015BA!\u0001E\n\u001b\u0005A2!G\u0002\t\u00155\t\u0001\u0014B\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0003\t6!A\u0003\u0001S5!\u0011\t\u0003E\u0002\u001b\u001dI!!C\u0001\u0019\u0006%\u0011\u0011\"\u0001\r\u00041\t\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "delegate", "fqNameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lkotlin/jvm/functions/Function1;)V", "findAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "fqName", "findExternalAnnotation", "getAllAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationWithTarget;", "getUseSiteTargetedAnnotations", "isEmpty", "iterator", "", "shouldBeReturned", "annotation"}, moduleName="kotlin-compiler")
public final class FilteredAnnotations
implements Annotations {
    private final Annotations delegate;
    private final Function1<? super FqName, ? extends Boolean> fqNameFilter;

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    @Override
    @Nullable
    public AnnotationDescriptor findExternalAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findExternalAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getUseSiteTargetedAnnotations() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate.getUseSiteTargetedAnnotations();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationWithTarget it = (AnnotationWithTarget)element;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getAllAnnotations() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate.getAllAnnotations();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationWithTarget it = (AnnotationWithTarget)element;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationDescriptor it = (AnnotationDescriptor)element;
            if (!this.shouldBeReturned(it)) continue;
            destination.add(element);
        }
        return ((List)var3_3).iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeReturned(AnnotationDescriptor annotation2) {
        ClassifierDescriptor descriptor2 = annotation2.getType().getConstructor().getDeclarationDescriptor();
        if (descriptor2 == null) return false;
        FqNameUnsafe $receiver = DescriptorUtils.getFqName(descriptor2);
        FqNameUnsafe fqName2 = $receiver;
        if (!fqName2.isSafe()) return false;
        Function1<FqName, Boolean> function1 = this.fqNameFilter;
        FqName fqName3 = fqName2.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.toSafe()");
        if (function1.invoke(fqName3) == false) return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public FilteredAnnotations(@NotNull Annotations delegate2, @NotNull Function1<? super FqName, ? extends Boolean> fqNameFilter) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        Intrinsics.checkParameterIsNotNull(fqNameFilter, "fqNameFilter");
        this.delegate = delegate2;
        this.fqNameFilter = fqNameFilter;
    }

    @Override
    public boolean hasAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return Annotations.DefaultImpls.hasAnnotation(this, fqName2);
    }
}

