/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.CollectionsKt;
import kotlin.Deprecated;
import kotlin.StringsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0011A)\u0001!B\u0001\t\u001f\u0015\tAAA\u0003\u0002\u0011\u0011!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0011\u0011\r\u0001RA\u0007\u00021\tI2\u0001C\u0002\u000e\u0003a\u0011Q\u0005\u0003C\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0006K1!9\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ab!G\u0002\t\n5\t\u0001dB\u0013\r\t\u000fAy!D\u0001\u0019\re\u0019\u0001\u0002C\u0007\u00021\u0019I2\u0001#\u0003\u000e\u0003a9Q\u0005\u0003C\u0004\u0011#i\u0011\u0001\u0007\u0002\u001a\u0007!IQ\"\u0001\r\u0003K9!9\u0001c\u0005\u000e\t%\u0011\u0011\"\u0001\r\u00061)Ib\u0001#\u0006\u000e\t%\u0011\u0011\"\u0001\r\u00061-)C\u0002b\u0002\t\u00185\t\u0001DB\r\u0004\u0011\u001bi\u0011\u0001\u0007\u0004\u001a\u0007!IQ\"\u0001\r\u0003K!!9\u0001c\u0006\u000e\u0003a1\u0011d\u0001E\u0005\u001b\u0005AR!\n\u0005\u0005\b!aQ\"\u0001\r\u00033\rAI!D\u0001\u0019\u000b\u0015BAq\u0001E\r\u001b\u0005A\"!G\u0002\t\u00075\t\u0001DA\u0013\t\t\u000fAQ\"D\u0001\u0019\u001ce\u0019\u0001\u0012B\u0007\u00021\u001dI{\u0001B!I\u0003!\rQ\"\u0001\r\u0003#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "capitalizeAsJavaClassName", "str", "fileHasTopLevelCallables", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDefaultFileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultPartFqName", "facadeClassFqName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "files", "", "getPackagePartFqName", "getPackagePartInternalName", "getPartClassName", "getPathHashCode", ""}, moduleName="kotlin-compiler")
public final class PackagePartClassUtils {
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";
    public static final PackagePartClassUtils INSTANCE;
    public static final PackagePartClassUtils INSTANCE$;

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return StringsKt.toLowerCase(file.getPath()).hashCode();
    }

    @JvmStatic
    @NotNull
    public static final String getPartClassName(@NotNull String str) {
        String string;
        Intrinsics.checkParameterIsNotNull(str, "str");
        if (StringsKt.isEmpty(str)) {
            string = "_" + PART_CLASS_NAME_SUFFIX;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = JvmAbi.sanitizeAsJavaIdentifier(str);
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmAbi.sanitizeAsJavaIdentifier(str)");
            string = stringBuilder.append(PackagePartClassUtils.capitalizeAsJavaClassName(string2)).append(PART_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(CollectionsKt.charAt(str, 0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = StringsKt.substring(str, 0, 1);
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            string = stringBuilder.append(StringsKt.toUpperCase(string2, locale)).append(StringsKt.substring(str, 1)).toString();
        } else {
            string = "_" + str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultFileClassFqName(@NotNull FqName packageFqName, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(packageFqName, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(facadeClassFqName, "facadeClassFqName");
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "facadeClassFqName.parent()");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    @Deprecated(message="Migrate to JvmFileClassesProvider")
    @JvmStatic
    @NotNull
    public static final String getPackagePartInternalName(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = JvmClassName.byFqNameWithoutInnerClasses(PackagePartClassUtils.getPackagePartFqName(file)).getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byFqNameWit\u2026qName(file)).internalName");
        return string;
    }

    @Deprecated(message="Migrate to JvmFileClassesProvider")
    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = file.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "file.packageFqName");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files) {
        void var3_3;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(files, "files");
        Iterable $receiver2 = files;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            KtFile it = (KtFile)element;
            if (!PackagePartClassUtils.fileHasTopLevelCallables(it)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @JvmStatic
    public static final boolean fileHasTopLevelCallables(@NotNull KtFile file) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Iterable $receiver = file.getDeclarations();
            for (Object element : $receiver) {
                KtDeclaration it = (KtDeclaration)element;
                if (!(it instanceof KtProperty || it instanceof KtNamedFunction)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String string = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.getNameWithoutExtension(fileName)");
        return PackagePartClassUtils.getPartClassName(string);
    }

    static {
        new PackagePartClassUtils();
    }

    private PackagePartClassUtils() {
        INSTANCE = this;
        INSTANCE$ = this;
        PART_CLASS_NAME_SUFFIX = PART_CLASS_NAME_SUFFIX;
    }
}

