/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.JsPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.JvmPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"9\u0015\u0001Q!\u0001\u0005\u0013\u000b\u0005Aq!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\u0011Q!\u0001E\u0006\u000b\u0005!)!B\u0001\t\u00035E\u0001\u0002B\u0007\u00021\u0013I2\u0001C\u0003\u000e\u0003a-Aka\u0002\u000e\u001a!1Q\"\u0001M\u00053\rAQ!D\u0001\u0019\fe\u0019\u0001RB\u0007\u00021\u001d!6qAG\r\u0011\u001fi\u0011\u0001'\u0003\u001a\u0007!AQ\"\u0001\r\u00023\rAQ!D\u0001\u0019\fQ\u001b9!$\u0004\t\u00125\t\u0001$A\u000b\u00021\u0005!6qA\u0007\r\u0011%i\u0011\u0001g\u0005\u0016\u0003a-\u0011\u0014\u0002\u0005\u000b\u001b\u0005A\u0012\u0001UB\u0001)\u000e\u001dQ2\u0005E\u000b\u001b\u0005AZ!F\u0001\u0019\fe%\u0001bC\u0007\u00021\u0017\u00016\u0011AM\u0005\u0011/i\u0011\u0001g\u0003Q\u0007\u0005!6qAG\u0007\u00111i\u0011\u0001'\u0007\u0016\u0003a-Aka\u0002\u0012*\u0011\u0019\u0005\u0002\u0003\u0001\u000e\u0015%\u0011\u0011\"\u0001\r\u0002\u0013\u0015IA!\u0003\u0002\n\u0003a\u0011\u00014\u0001M\u0001#\u000e!Q\u0001A\u0007\u0003\t\u000bA1\u0001VB\u0004"}, strings={"profileEvaluators", "", "", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "getProfileEvaluators", "()Ljava/util/Map;", "PreprocessorKt", "createJsProfile", "Lorg/jetbrains/kotlin/preprocessor/Profile;", "targetRoot", "Ljava/io/File;", "createJvmProfile", "version", "", "createProfile", "name", "convertLineSeparators", "isTextEqualTo", "", "content", "makeRelativeTo", "from", "to", "mkdirsOrFail", ""}, moduleName="kotlin-compiler")
public final class PreprocessorKt {
    @NotNull
    private static final Map<String, ? extends Function0<? extends Evaluator>> profileEvaluators;

    @NotNull
    public static final Profile createJvmProfile(@NotNull File targetRoot, int version) {
        Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
        return new Profile("JVM" + version, new JvmPlatformEvaluator(version), new File(targetRoot, "jvm" + version));
    }

    @NotNull
    public static final Profile createJsProfile(@NotNull File targetRoot) {
        Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
        return new Profile("JS", new JsPlatformEvaluator(0, 1, null), new File(targetRoot, "js"));
    }

    @NotNull
    public static final Map<String, Function0<? extends Evaluator>> getProfileEvaluators() {
        return profileEvaluators;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Profile createProfile(@NotNull String name, @NotNull File targetRoot) {
        void evaluator;
        void profileName;
        Object v0;
        Object $receiver;
        block2: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
            Map<String, ? extends Function0<? extends Evaluator>> map2 = profileEvaluators;
            $receiver = $receiver.entrySet();
            Iterator $i$f$entrySet = $receiver.iterator();
            while ($i$f$entrySet.hasNext()) {
                Object element = $i$f$entrySet.next();
                Map.Entry it = (Map.Entry)element;
                if (!StringsKt.equals((String)it.getKey(), name, true)) continue;
                v0 = element;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw (Throwable)new IllegalArgumentException("Profile with name '" + name + "' is not supported");
        }
        Map.Entry entry2 = entry;
        $receiver = entry2;
        String string = (String)$receiver.getKey();
        $receiver = entry2;
        Function0 function0 = (Function0)$receiver.getValue();
        entry2 = null;
        return new Profile((String)profileName, (Evaluator)evaluator.invoke(), targetRoot);
    }

    @NotNull
    public static final String convertLineSeparators(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = StringUtil.convertLineSeparators($receiver);
        Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.convertLineSeparators(this)");
        return string;
    }

    public static final boolean isTextEqualTo(File $receiver, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(content, "content");
        return Intrinsics.areEqual(StringsKt.lines(FilesKt.readText$default($receiver, null, 1)), StringsKt.lines(content));
    }

    @NotNull
    public static final File makeRelativeTo(File $receiver, @NotNull File from, @NotNull File to) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        return new File(to, FilesKt.relativeTo($receiver, from));
    }

    public static final void mkdirsOrFail(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.mkdirs() && !$receiver.exists()) {
            throw (Throwable)new IOException("Failed to create directory " + $receiver + ".");
        }
    }

    static {
        Iterable $receiver = CollectionsKt.listOf(6, 7, 8);
        float capacity = (float)CollectionsKt.collectionSizeOrDefault($receiver, 10) / 0.75f + 1.0f;
        LinkedHashMap<String, Function0> result2 = new LinkedHashMap<String, Function0>(Math.max((int)capacity, 16));
        for (Object element : $receiver) {
            int version;
            int n = ((Number)element).intValue();
            LinkedHashMap<String, Function0> linkedHashMap = result2;
            String string = "JVM" + version;
            version = ((Number)element).intValue();
            Function0 function0 = new Function0<JvmPlatformEvaluator>(version){
                final /* synthetic */ int $version;

                @NotNull
                public final JvmPlatformEvaluator invoke() {
                    return new JvmPlatformEvaluator(this.$version);
                }
                {
                    this.$version = n;
                    super(0);
                }
            };
            linkedHashMap.put(string, function0);
        }
        profileEvaluators = MapsKt.plus((Map)result2, TuplesKt.to("JS", profileEvaluators.3.INSTANCE));
    }
}

