/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclarationName;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0007\u0011\u0019B\u0002A\r\t\u0013\u0019IQ!C\u0002\u0005\u0002%\t\u0001\u0004\u0001\r\u00021\u0003I\u0012\u0001g\u0001\u001a\u0003a\u0011\u0011u\u0002\u0003\f\u0013\rA)!D\u0001\u0019\u0007E\u001b\u0011\u0001c\u0002\"(\u0011Y\u0011b\u0002\u0005\u0005\u001b\u0015I1\u0001\"\u0001\n\u0003a\u0001\u0001$A\u0005\b\u0011\u0013iQ!C\u0001\u0005\u0004%\tA1\u0001\r\u0006#\u000e\t\u00012B\u0013\b\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\u0007K1Ay!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u001bIB\u0001\u0003\u0005\u000e\u00051\u0005\u0001\u0014C\u0013\r\u0011%i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\u00073\u0011A\u0001\"\u0004\u0002\r\u0002aEQe\u0002E\n\u001b\u0005A\"\"G\u0002\t\u00165\t\u0001DC\u0013\u0005\t-A1\"D\u0001\u0019\u0018\u00152\u0001\u0002D\u0007\u0005\u0013\tI\u0011\u0001G\u0007\u0019\u001a\u0015\"\u00012D\u0007\u0003\u0019\u0003Ab\"J\u0006\u0005\u0017!uQ\u0002C\u0005\u0007\u0013\u0015\u0001r\"\u0006\u0002\r\u0002a5\u0001T\u0002M\rK\u0011Ay\"\u0004\u0002\r\u0002a\u0001Re\u0002\u0003\f\u0011CiA!\u0003\u0002\n\u0003aQ\u0001\u0014D\u0013\u0005\u0011Ei!\u0001$\u0001\u0019$\u0015\u001a\u0001BE\u0007\u000219)S\u0001B\u0006\t&5\u0011A\u0012\u0001\r\u0014K\u0011A9#\u0004\u0002\r\u0002a!R\u0005\u0002E\u0015\u001b\ta\t\u0001G\u000b&\t!-RB\u0001G\u00011Y)c\u0001#\f\u000e\t%\u0011\u0011\"\u0001\r\u001813)c\u0001c\f\u000e\t%\u0011\u0011\"\u0001\r\u001913)3\u0001#\r\u000e\u0003aIRe\u0001E\u001a\u001b\u0005A\u0012$\n\u0003\u0005\u0003!QR\"\u0001\r\u001aK\rA)$D\u0001\u00193\u0015\u001a\u0001bG\u0007\u00021e)3\u0001c\u000e\u000e\u0003aIRe\u0002\u0005\u001d\u001b\u0005A:\"G\u0002\t\u00165\t\u0001D\u0003"}, strings={"Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwnerStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassOrObjectStub;", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "nodeType", "Lcom/intellij/psi/stubs/IStubElementType;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassOrObjectStub;Lcom/intellij/psi/stubs/IStubElementType;)V", "addDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "addDeclarationAfter", "anchor", "Lcom/intellij/psi/PsiElement;", "addDeclarationBefore", "addDelegationSpecifier", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifier;", "delegationSpecifier", "delete", "", "getAnonymousInitializers", "", "Lorg/jetbrains/kotlin/psi/KtClassInitializer;", "getBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "getDeclarations", "kotlin.jvm.PlatformType", "getDelegationSpecifierList", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifierList;", "getDelegationSpecifiers", "getNameAsDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclarationName;", "getOrCreateBody", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "getPrimaryConstructorModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "getPrimaryConstructorParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "getPrimaryConstructorParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getSecondaryConstructors", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "hasExplicitPrimaryConstructor", "", "hasPrimaryConstructor", "hasSecondaryConstructors", "isAnnotation", "isLocal", "isTopLevel", "removeDelegationSpecifier"}, moduleName="kotlin-compiler")
public abstract class KtClassOrObject
extends KtTypeParameterListOwnerStub<KotlinClassOrObjectStub<? extends KtClassOrObject>>
implements KtDeclarationContainer,
KtNamedDeclaration {
    @Nullable
    public final KtDelegationSpecifierList getDelegationSpecifierList() {
        return (KtDelegationSpecifierList)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.DELEGATION_SPECIFIER_LIST);
    }

    @NotNull
    public List<KtDelegationSpecifier> getDelegationSpecifiers() {
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        return CollectionsKt.orEmpty(ktDelegationSpecifierList != null ? ktDelegationSpecifierList.getDelegationSpecifiers() : null);
    }

    @NotNull
    public final KtDelegationSpecifier addDelegationSpecifier(@NotNull KtDelegationSpecifier delegationSpecifier) {
        Intrinsics.checkParameterIsNotNull(delegationSpecifier, "delegationSpecifier");
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        if (ktDelegationSpecifierList != null) {
            KtDelegationSpecifierList $receiver = ktDelegationSpecifierList;
            KtDelegationSpecifierList it = $receiver;
            return (KtDelegationSpecifier)EditCommaSeparatedListHelper.INSTANCE.addItem(it, this.getDelegationSpecifiers(), (KtElement)delegationSpecifier);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(this);
        PsiElement specifierListToAdd = psiFactory.createDelegatorToSuperCall("A()").replace(delegationSpecifier).getParent();
        PsiElement colon = this.addBefore(psiFactory.createColon(), this.getBody());
        PsiElement psiElement2 = this.addAfter(specifierListToAdd, colon);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDelegationSpecifierList");
        }
        KtDelegationSpecifier ktDelegationSpecifier = CollectionsKt.first(((KtDelegationSpecifierList)psiElement2).getDelegationSpecifiers());
        Intrinsics.checkExpressionValueIsNotNull(ktDelegationSpecifier, "(addAfter(specifierListT\u2026ationSpecifiers().first()");
        return ktDelegationSpecifier;
    }

    public final void removeDelegationSpecifier(@NotNull KtDelegationSpecifier delegationSpecifier) {
        Intrinsics.checkParameterIsNotNull(delegationSpecifier, "delegationSpecifier");
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        if (ktDelegationSpecifierList == null) {
            return;
        }
        KtDelegationSpecifierList specifierList = ktDelegationSpecifierList;
        PreconditionsKt.assert(delegationSpecifier.getParent() == specifierList);
        Collection $receiver = specifierList.getDelegationSpecifiers();
        if ($receiver.size() > 1) {
            EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)delegationSpecifier);
        } else {
            Object object = this.findChildByType(KtTokens.COLON);
            if (object == null) {
                object = specifierList;
            }
            this.deleteChildRange((PsiElement)object, specifierList);
        }
    }

    @NotNull
    public final List<KtClassInitializer> getAnonymousInitializers() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getAnonymousInitializers() : null);
    }

    @Nullable
    public final KtObjectDeclarationName getNameAsDeclaration() {
        return (KtObjectDeclarationName)this.findChildByType(KtNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Nullable
    public final KtClassBody getBody() {
        return (KtClassBody)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.CLASS_BODY);
    }

    @NotNull
    public final KtClassBody getOrCreateBody() {
        KtClassBody ktClassBody = this.getBody();
        if (ktClassBody == null) {
            PsiElement psiElement2 = this.add(KtPsiFactoryKt.KtPsiFactory(this).createEmptyClassBody());
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
            }
            ktClassBody = (KtClassBody)psiElement2;
        }
        return ktClassBody;
    }

    @NotNull
    public final KtDeclaration addDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        KtClassBody body = this.getOrCreateBody();
        PsiElement psiElement2 = body.getRBrace();
        if (psiElement2 == null && (psiElement2 = body.getLastChild()) == null) {
            Intrinsics.throwNpe();
        }
        PsiElement anchor2 = PsiTreeUtil.skipSiblingsBackward(psiElement2, PsiWhiteSpace.class);
        PsiElement psiElement3 = body.addAfter(declaration, anchor2);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    @NotNull
    public final KtDeclaration addDeclarationAfter(@NotNull KtDeclaration declaration, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiElement psiElement2 = anchor2;
        if (psiElement2 == null) {
            psiElement2 = CollectionsKt.lastOrNull(this.getDeclarations());
        }
        if (psiElement2 == null) {
            return this.addDeclaration(declaration);
        }
        PsiElement anchorBefore = psiElement2;
        PsiElement psiElement3 = this.getOrCreateBody().addAfter(declaration, anchorBefore);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    @NotNull
    public final KtDeclaration addDeclarationBefore(@NotNull KtDeclaration declaration, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiElement psiElement2 = anchor2;
        if (psiElement2 == null) {
            psiElement2 = CollectionsKt.firstOrNull(this.getDeclarations());
        }
        if (psiElement2 == null) {
            return this.addDeclaration(declaration);
        }
        PsiElement anchorAfter = psiElement2;
        PsiElement psiElement3 = this.getOrCreateBody().addBefore(declaration, anchorAfter);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    public final boolean isTopLevel() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        return kotlinClassOrObjectStub != null ? kotlinClassOrObjectStub.isTopLevel() : this.getParent() instanceof KtFile;
    }

    public final boolean isLocal() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        return kotlinClassOrObjectStub != null ? kotlinClassOrObjectStub.isLocal() : KtPsiUtil.isLocal(this);
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getDeclarations() : null);
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Nullable
    public final KtPrimaryConstructor getPrimaryConstructor() {
        return (KtPrimaryConstructor)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.PRIMARY_CONSTRUCTOR);
    }

    @Nullable
    public final KtModifierList getPrimaryConstructorModifierList() {
        KtPrimaryConstructor ktPrimaryConstructor = this.getPrimaryConstructor();
        return ktPrimaryConstructor != null ? ktPrimaryConstructor.getModifierList() : null;
    }

    @Nullable
    public final KtParameterList getPrimaryConstructorParameterList() {
        KtPrimaryConstructor ktPrimaryConstructor = this.getPrimaryConstructor();
        return ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameterList() : null;
    }

    @NotNull
    public final List<KtParameter> getPrimaryConstructorParameters() {
        KtParameterList ktParameterList = this.getPrimaryConstructorParameterList();
        return CollectionsKt.orEmpty(ktParameterList != null ? ktParameterList.getParameters() : null);
    }

    public final boolean hasExplicitPrimaryConstructor() {
        return this.getPrimaryConstructor() != null;
    }

    public final boolean hasPrimaryConstructor() {
        return this.hasExplicitPrimaryConstructor() || !this.hasSecondaryConstructors();
    }

    private final boolean hasSecondaryConstructors() {
        return !this.getSecondaryConstructors().isEmpty();
    }

    @NotNull
    public final List<KtSecondaryConstructor> getSecondaryConstructors() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getSecondaryConstructors() : null);
    }

    public final boolean isAnnotation() {
        return this.hasModifier(KtTokens.ANNOTATION_KEYWORD);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete() {
        CheckUtil.checkWritable(this);
        KtFile file = this.getContainingJetFile();
        if (this.isTopLevel()) {
            Collection $receiver = file.getDeclarations();
            if ($receiver.size() <= 1) {
                file.delete();
                return;
            }
        }
        CodeEditUtil.removeChild(this.getParent().getNode(), this.getNode());
    }

    public KtClassOrObject(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtClassOrObject(@NotNull KotlinClassOrObjectStub<? extends KtClassOrObject> stub, @NotNull IStubElementType<?, ?> nodeType) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(nodeType, "nodeType");
        super((KotlinStubWithFqName)stub, nodeType);
    }
}

