/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.RangesKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\t\u0001bD\u0003\u0001\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!!\u0001\u0004\u0001\u0016\t\u0011\u0001\u0001\u0012A\u000b\u00021\u0005)B\u0001\"\u0001\t\u0004U\tA\u0015A\r\u00021\ti\n1DQ\u0019\u0013\rA)!D\u0001\u0019\u0007%\u0019\u0001rA\u0007\u00021\u0011I\u0011\u0002#\u0003\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001g\u0003\u0019\u000b%\u0019\u0001BB\u0007\u00021\u001b\t6!\u0001\u0005\bKAA1\"D\u0001\u0019\u0018ea\u0001\u0002D\u0007\u000b\u0013!Iq!C\u0003\n\t%\u0011\u0011\"\u0001\u000f\u00011\u0017A\u0012\u0002'\u0005&\t\u0011\t\u0001\u0012D\u0007\u00021/)C\u0002C\u0007\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005a\u0002!\u0003\u0002\n\u0003q\u0005\u0001T\u0003\r\u000bS\u001d!\u0011\t\u0003E\u0004\u001b\u0005AB!U\u0002\u0002\u000b\u0001I3\u0003B!\t\u0011\u001fiQ\"C\u0006\n\u0015%A\u0011bB\u0005\u0006\u0013\u0011I!!C\u0001\u001d\u0001a-\u0001$\u0003M\t1!\t6!A\u0003\u0001SE!\u0011\t\bE\n\u001b-I\u0001\"C\u0004\n\u0005%\tA\u0004A\u0005\u0003\u0013\u0005a\n\u0001'\u0006\r\u0002aQ\u0011kA\u0001\u0006\u0001%jA!\u0011\u0005\t\n59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\fa)\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!1Q\"\u0001M\u0007#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTaskHolder;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "F", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "basicCallResolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "priorityProvider", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTaskHolder$PriorityProvider;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTaskHolder$PriorityProvider;Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;)V", "candidatesList", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "internalTasks", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask;", "addCandidates", "", "lazyCandidates", "assertNotFinished", "getTasks", "PriorityProvider"}, moduleName="kotlin-compiler")
public final class ResolutionTaskHolder<D extends CallableDescriptor, F extends D> {
    private final ArrayList<Function0<? extends Collection<? extends ResolutionCandidate<D>>>> candidatesList;
    private List<? extends ResolutionTask<D, F>> internalTasks;
    private final StorageManager storageManager;
    private final BasicCallResolutionContext basicCallResolutionContext;
    private final PriorityProvider<ResolutionCandidate<D>> priorityProvider;
    private final TracingStrategy tracing;

    public final void addCandidates(@NotNull Function0<? extends Collection<? extends ResolutionCandidate<D>>> lazyCandidates2) {
        Intrinsics.checkParameterIsNotNull(lazyCandidates2, "lazyCandidates");
        this.assertNotFinished();
        this.candidatesList.add(this.storageManager.createLazyValue(new Function0<List<? extends ResolutionCandidate<D>>>(lazyCandidates2){
            final /* synthetic */ Function0 $lazyCandidates;

            @NotNull
            public final List<ResolutionCandidate<D>> invoke() {
                return CollectionsKt.toReadOnlyList((Collection)this.$lazyCandidates.invoke());
            }
            {
                this.$lazyCandidates = function0;
                super(0);
            }
        }));
    }

    private final void assertNotFinished() {
        boolean value2 = this.internalTasks == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Can't add candidates after the resulting tasks were computed.";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolutionTask<D, F>> getTasks() {
        if (this.internalTasks == null) {
            ArrayList tasks = new ArrayList();
            IntProgression intProgression = RangesKt.reversed(new IntRange(0, this.priorityProvider.getMaxPriority()));
            int n = ((Number)intProgression.getStart()).intValue();
            int n2 = ((Number)intProgression.getEnd()).intValue();
            int n3 = ((Number)intProgression.getIncrement()).intValue();
            int n4 = ProgressionUtilKt.getProgressionFinalElement(n, n2, n3);
            int n5 = n;
            int n6 = n2;
            if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void priority;
                    int n7;
                    IntRange intRange = kotlin.CollectionsKt.getIndices((Collection)this.candidatesList);
                    int n8 = ((Number)intRange.getStart()).intValue();
                    if (n8 <= (n7 = ((Number)intRange.getEnd()).intValue())) {
                        while (true) {
                            void candidateIndex;
                            Function0 lazyCandidates2 = new Function0<List<? extends ResolutionCandidate<D>>>(this, (int)candidateIndex, (int)priority){
                                final /* synthetic */ ResolutionTaskHolder this$0;
                                final /* synthetic */ int $candidateIndex;
                                final /* synthetic */ int $priority;

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final List<ResolutionCandidate<D>> invoke() {
                                    void var3_3;
                                    void $receiver;
                                    Iterable $receiver2 = ResolutionTaskHolder.access$getCandidatesList$p(this.this$0).get(this.$candidateIndex).invoke();
                                    Iterable iterable = $receiver2;
                                    Collection destination = new ArrayList<E>();
                                    for (T element : $receiver) {
                                        ResolutionCandidate it = (ResolutionCandidate)element;
                                        if (!(ResolutionTaskHolder.access$getPriorityProvider$p(this.this$0).getPriority(it) == this.$priority)) continue;
                                        destination.add(element);
                                    }
                                    return CollectionsKt.toReadOnlyList((List)var3_3);
                                }
                                {
                                    this.this$0 = resolutionTaskHolder;
                                    this.$candidateIndex = n;
                                    this.$priority = n2;
                                    super(0);
                                }
                            };
                            tasks.add(new ResolutionTask(this.basicCallResolutionContext, this.tracing, lazyCandidates2));
                            if (candidateIndex == n7) break;
                            ++candidateIndex;
                        }
                    }
                    if (priority == n4) break;
                    n = priority + n3;
                }
            }
            this.internalTasks = tasks;
        }
        List<ResolutionTask<D, F>> list = this.internalTasks;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    public ResolutionTaskHolder(@NotNull StorageManager storageManager, @NotNull BasicCallResolutionContext basicCallResolutionContext, @NotNull PriorityProvider<ResolutionCandidate<D>> priorityProvider, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(basicCallResolutionContext, "basicCallResolutionContext");
        Intrinsics.checkParameterIsNotNull(priorityProvider, "priorityProvider");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        this.storageManager = storageManager;
        this.basicCallResolutionContext = basicCallResolutionContext;
        this.priorityProvider = priorityProvider;
        this.tracing = tracing;
        this.candidatesList = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ ArrayList<Function0<? extends Collection<? extends ResolutionCandidate<D>>>> access$getCandidatesList$p(ResolutionTaskHolder<D, F> $this) {
        return $this.candidatesList;
    }

    @NotNull
    public static final /* synthetic */ PriorityProvider<ResolutionCandidate<D>> access$getPriorityProvider$p(ResolutionTaskHolder<D, F> $this) {
        return $this.priorityProvider;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!\u0002\u0001\u0006\u0003!!Q!\u0001C\u0002\tMb\u0001!\u0006\u0002\u0005\u0003!\u0005\u0011$\u0001\r\u0002K\u0011!1\u0003c\u0001\u000e\u0003a\u0011QU\u0003\u0003\u0014\u0011\u000bi\u0011\u0001\u0007\u0002\u001a\u0007!\u0019Q\"\u0001\u000f\u0002#\u000e\t\u0001r\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTaskHolder$PriorityProvider;", "D", "", "getMaxPriority", "", "getPriority", "candidate", "(Ljava/lang/Object;)I"}, moduleName="kotlin-compiler")
    public static interface PriorityProvider<D> {
        public int getPriority(D var1);

        public int getMaxPriority();
    }
}

