/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!-Q!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u00051\u0001Qc\u0001\u0003\u0001\u0011\u0003\u0001\n!\u0007\u0003\n\u0005%\tA\u0015\u0001\r\u0002C7Ia\u0001c\u0001\u000e\t%\u0011\u0011\"\u0001\u000f\u00011\tI1\u0001#\u0002\u000e\u0003a\u0019\u0011kA\u0001\t\b\u0015ZAa\u0003E\n\u001b\u0011I!!C\u0001\u001d\u0001a\u0011\u0011d\u0001\u0005\u000b\u001b\u0005A\u0002\"K\u0007\u0005\u0007\"A\u0019!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0011AI!\u000b\u0006\u0005\u0017\"AQ!D\u0001\u0019\fqY\u0013kA\u0002\u000e\u0005\u0011)\u0001BB\u0015\u000b\t-C\u0001RA\u0007\u00021\r\t6\u0001B\u0003\u0001\u001b\t!i\u0001C\u0004*\u0015\u0011\u0019\u0005\u0002c\u0004\u000e\u0003aA\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0003\u0005\n"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "T", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getConstantValue", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "isError", "", "()Z", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "toConstantValue", "expectedType"}, moduleName="kotlin-compiler")
public final class TypedCompileTimeConstant<T>
implements CompileTimeConstant<T> {
    @NotNull
    private final KotlinType type;
    @NotNull
    private final ConstantValue<? extends T> constantValue;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    @Override
    public boolean isError() {
        return this.constantValue instanceof ErrorValue;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ConstantValue<T> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return this.constantValue;
    }

    @NotNull
    public final ConstantValue<T> getConstantValue() {
        return this.constantValue;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public TypedCompileTimeConstant(@NotNull ConstantValue<? extends T> constantValue, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull(constantValue, "constantValue");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.constantValue = constantValue;
        this.parameters = parameters2;
        this.type = this.constantValue.getType();
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public T getValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }
}

