/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class DeclarationScopeProviderImpl
implements DeclarationScopeProvider {
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final FileScopeProvider fileScopeProvider;

    public DeclarationScopeProviderImpl(@NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull FileScopeProvider fileScopeProvider) {
        if (lazyDeclarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyDeclarationResolver", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "<init>"));
        }
        if (fileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScopeProvider", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "<init>"));
        }
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.fileScopeProvider = fileScopeProvider;
    }

    @Override
    @NotNull
    public LexicalScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
        }
        KtDeclaration ktDeclaration = KtStubbedPsiUtil.getPsiOrStubParent(elementOfDeclaration, KtDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof KtDeclaration) || ktDeclaration == elementOfDeclaration) : "For JetDeclaration element getParentOfType() should return itself.";
        assert (ktDeclaration != null) : "Should be contained inside declaration.";
        KtDeclaration parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(ktDeclaration);
        if (ktDeclaration instanceof KtPropertyAccessor) {
            parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(parentDeclaration, KtDeclaration.class);
        }
        if (parentDeclaration == null) {
            LazyFileScope lazyFileScope = this.fileScopeProvider.getFileScope((KtFile)elementOfDeclaration.getContainingFile());
            if (lazyFileScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return lazyFileScope;
        }
        if (parentDeclaration instanceof KtClassOrObject) {
            KtClassOrObject classOrObject = (KtClassOrObject)parentDeclaration;
            LazyClassDescriptor classDescriptor = (LazyClassDescriptor)this.lazyDeclarationResolver.getClassDescriptor(classOrObject, NoLookupLocation.WHEN_GET_DECLARATION_SCOPE);
            if (ktDeclaration instanceof KtClassInitializer || ktDeclaration instanceof KtProperty) {
                LexicalScope lexicalScope = classDescriptor.getScopeForInitializerResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
                }
                return lexicalScope;
            }
            if (ktDeclaration instanceof KtObjectDeclaration || ktDeclaration instanceof KtClass && !((KtClass)ktDeclaration).isInner()) {
                LexicalScope lexicalScope = classDescriptor.getScopeForStaticMemberDeclarationResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
                }
                return lexicalScope;
            }
            LexicalScope lexicalScope = classDescriptor.getScopeForMemberDeclarationResolution();
            if (lexicalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return lexicalScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + ktDeclaration + "\n" + PsiUtilsKt.getElementTextWithContext(ktDeclaration));
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        return dataFlowInfo;
    }
}

