/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.PropertyMetadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.FilteringScope;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver$resultingDescriptor$1;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"O\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAaB\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001da\u0001!G\u0001\u0019\u0002\u0005\u0006\u0012b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0003\u0013\u0011A1!\u0004\u0002\r\u0002a\u001d\u0011kA\u0001\t\t\u0015\"Aa\u0003\u0005\u0012\u001b\u0005A\u001a#J\u0002\t%5\t\u0001TE\u0013\u0004\u0011Mi\u0011\u0001g\b&\t\u0011Y\u0001rE\u0007\u00021Q)C\u0001B\u0006\t*5\t\u0001$F\u0015\f\t-C\u0001bA\u0007\u0003\u0019\u0003A:!U\u0002\u0005\u000b\u0001i!\u0001\"\u0003\t\u000b%RAa\u0011\u0005\t\f5\t\u0001D\u0002\u000f$#\u000e\u0019QB\u0001C\u0007\u0011\u001dI#\u0002B&\t\u0011\u001fi\u0011\u0001\u0007\u0005R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0012!I\u0011f\u0003\u0003L\u0011!\u0011QB\u0001G\u00011\u000b\t6\u0001B\u0003\u0001\u001b\t!\u0019\u0002\u0003\u0006*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0003\u0005\fSU!1\n\b\u0005\r\u001b\u0005Ab!G\u0002\t\u00185\t\u0001D\u0002\u000f,A-\n6!C\u0003\u0003\t9Ai\"\u0004\u0002\u0005\u001a!9\u0011C\u0001\u0003\u000e\u00117I#\u0002B&\t\u0011=i\u0011\u0001g\b\u001dWE\u001b1!\u0004\u0002\u0005!!\u0005\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/QualifierReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "getClassifier", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getPackageView", "()Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "getReferenceExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "<set-?>", "resultingDescriptor", "getResultingDescriptor", "setResultingDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "resultingDescriptor$delegate", "Lkotlin/properties/ReadWriteProperty;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/KtScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/KtScope;", "exists", "", "getClassObjectReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getNestedClassesAndPackageMembersScope", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toString", ""}, moduleName="kotlin-compiler")
public final class QualifierReceiver
implements Qualifier {
    @NotNull
    private final KtExpression expression;
    @NotNull
    private final ReadWriteProperty<? super Object, DeclarationDescriptor> resultingDescriptor$delegate;
    @NotNull
    private final KtSimpleNameExpression referenceExpression;
    @Nullable
    private final PackageViewDescriptor packageView;
    @Nullable
    private final ClassifierDescriptor classifier;
    private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;

    @Override
    @NotNull
    public KtExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public final DeclarationDescriptor getDescriptor() {
        ClassifierDescriptor classifierDescriptor = this.getClassifier();
        DeclarationDescriptor declarationDescriptor = classifierDescriptor != null ? (DeclarationDescriptor)classifierDescriptor : (DeclarationDescriptor)this.getPackageView();
        if (declarationDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)"PackageView and classifier both are null"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getResultingDescriptor() {
        return this.resultingDescriptor$delegate.getValue(this, (KProperty)$delegatedProperties[0]);
    }

    public void setResultingDescriptor(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "<set-?>");
        this.resultingDescriptor$delegate.setValue(this, (KProperty)$delegatedProperties[0], declarationDescriptor);
    }

    @Override
    @NotNull
    public KtScope getScope() {
        FilteringScope filteringScope;
        Object object;
        ClassifierDescriptor classifierDescriptor = this.getClassifier();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        if ((object = (ClassDescriptor)classifierDescriptor) != null && (object = DescriptorUtilsKt.getClassObjectType((ClassDescriptor)object)) != null && (object = object.getMemberScope()) != null) {
            KtScope it;
            Object $receiver = object;
            KtScope ktScope = it = (KtScope)$receiver;
            Intrinsics.checkExpressionValueIsNotNull(ktScope, "it");
            filteringScope = new FilteringScope(ktScope, scope.classObjectTypeScope.1.1.INSTANCE);
        } else {
            filteringScope = null;
        }
        FilteringScope classObjectTypeScope2 = filteringScope;
        Collection $receiver = kotlin.CollectionsKt.filterNotNull((Iterable)kotlin.CollectionsKt.listOf(classObjectTypeScope2, this.getNestedClassesAndPackageMembersScope()));
        Collection collection = $receiver;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection = collection;
        KtScope[] ktScopeArray = thisCollection.toArray(new KtScope[thisCollection.size()]);
        if (ktScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        KtScope[] scopes = (KtScope[])((Object[])ktScopeArray);
        return new ChainedScope(this.getDescriptor(), "Member scope for " + this.getName() + " as package or class or object", Arrays.copyOf(scopes, scopes.length));
    }

    @NotNull
    public final ReceiverValue getClassObjectReceiver() {
        ReceiverValue receiverValue;
        Annotated annotated;
        ClassifierDescriptor classifierDescriptor = this.getClassifier();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        if ((annotated = (ClassDescriptor)classifierDescriptor) != null && (annotated = DescriptorUtilsKt.getClassObjectType(annotated)) != null) {
            Annotated $receiver = annotated;
            KotlinType it = (KotlinType)$receiver;
            receiverValue = new ExpressionReceiver(this.getReferenceExpression(), it);
        } else {
            receiverValue = ReceiverValue.NO_RECEIVER;
        }
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "(classifier as? ClassDes\u2026ReceiverValue.NO_RECEIVER");
        return receiverValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KtScope getNestedClassesAndPackageMembersScope() {
        void $receiver;
        ChainedScope chainedScope;
        ArrayList<KtScope> scopes = new ArrayList<KtScope>(4);
        PackageViewDescriptor packageViewDescriptor = this.getPackageView();
        CollectionsKt.addIfNotNull((Collection)scopes, packageViewDescriptor != null ? packageViewDescriptor.getMemberScope() : null);
        if (this.getClassifier() instanceof ClassDescriptor) {
            scopes.add(((ClassDescriptor)this.getClassifier()).getStaticScope());
            if (Intrinsics.areEqual((Object)((ClassDescriptor)this.getClassifier()).getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true) {
                scopes.add(DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)this.getClassifier()));
            }
        }
        Collection collection = scopes;
        String string = "Static scope for " + this.getName() + " as package or class or object";
        DeclarationDescriptor declarationDescriptor = this.getDescriptor();
        ChainedScope chainedScope2 = chainedScope;
        ChainedScope chainedScope3 = chainedScope;
        Collection thisCollection = (Collection)$receiver;
        KtScope[] ktScopeArray = thisCollection.toArray(new KtScope[thisCollection.size()]);
        if (ktScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = ktScopeArray;
        KtScope[] ktScopeArray2 = (KtScope[])objectArray;
        chainedScope2(declarationDescriptor, string, Arrays.copyOf(ktScopeArray2, ktScopeArray2.length));
        return chainedScope3;
    }

    @Override
    @NotNull
    public KotlinType getType() {
        throw (Throwable)new IllegalStateException("No type corresponds to QualifierReceiver '" + this + "'");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @NotNull
    public String toString() {
        return "Package{" + this.getPackageView() + "} OR Class{" + this.getClassifier() + "}";
    }

    @NotNull
    public final KtSimpleNameExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackageView() {
        return this.packageView;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier() {
        return this.classifier;
    }

    static {
        $delegatedProperties = new PropertyMetadata[]{QualifierReceiver$resultingDescriptor$1.INSTANCE};
    }

    public QualifierReceiver(@NotNull KtSimpleNameExpression referenceExpression, @Nullable PackageViewDescriptor packageView, @Nullable ClassifierDescriptor classifier2) {
        Intrinsics.checkParameterIsNotNull(referenceExpression, "referenceExpression");
        this.referenceExpression = referenceExpression;
        this.packageView = packageView;
        this.classifier = classifier2;
        KtQualifiedExpression ktQualifiedExpression = JetPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(this.referenceExpression);
        this.expression = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)this.referenceExpression;
        this.resultingDescriptor$delegate = Delegates.INSTANCE.notNull();
    }

    @Override
    @NotNull
    public Name getName() {
        return Qualifier.DefaultImpls.getName(this);
    }
}

