/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.CharIterator;
import kotlin.StringsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.entities.EntityConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t%\u0015\t\u0001RB\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0005\u0007\u0012a\u0001\u0001e\u0003\u001a\u0003a\u0005Q$a\u0003\u0007C7!\u0011!C\u0005\t\u000359\u0011BA\u0005\u00021\tI!!C\u0001\u0019\u0006a\r\u0011kA\u0001\t\u0007\u0015VA!Q\u0004\t\b59\u0011BA\u0005\u00021\tI!!C\u0001\u0019\u0006a\rQu\u0004\u0003D\u0007!!Q\"\u0001\r\u00013)!\u0011\u0001C\u0001\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001'\u0002\u0019\u0004\u0015B\u0001\u0012B\u0007\u0003\u0019\u0003A*!G\u0002\t\u000b5\t\u0001DA\u0015\u000e\t\u0005C\u0001\"A\u0007\b\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001T\u0001M\u0002#\u000e\tQ\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "(Ljava/util/Map;)V", "component1", "copy", "getLinkInfo", "label", "Builder", "LinkInfo"}, moduleName="intellij-markdown")
public final class LinkMap {
    @NotNull
    public static final Regex SPACES_REGEX;
    private final Map<CharSequence, ? extends LinkInfo> map;
    public static final Builder Builder;

    static {
        Builder = org.intellij.markdown.parser.LinkMap$Builder.INSTANCE;
        SPACES_REGEX = new Regex("\\s+");
    }

    @Nullable
    public final LinkInfo getLinkInfo(@NotNull CharSequence label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        return this.map.get(LinkMap.Builder.normalizeLabel(label));
    }

    private LinkMap(Map<CharSequence, ? extends LinkInfo> map) {
        this.map = map;
    }

    public /* synthetic */ LinkMap(@NotNull Map<CharSequence, ? extends LinkInfo> map, DefaultConstructorMarker $constructor_marker) {
        this(map);
    }

    private final Map<CharSequence, LinkInfo> component1() {
        return this.map;
    }

    @NotNull
    public final LinkMap copy(@NotNull Map<CharSequence, ? extends LinkInfo> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        return new LinkMap(map);
    }

    @NotNull
    public static /* synthetic */ LinkMap copy$default(LinkMap linkMap, Map map, int n) {
        if ((n & 1) != 0) {
            map = linkMap.map;
        }
        return linkMap.copy(map);
    }

    public String toString() {
        return "LinkMap(map=" + this.map + ")";
    }

    public int hashCode() {
        Map<CharSequence, ? extends LinkInfo> map = this.map;
        return map != null ? ((Object)map).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LinkMap)) break block3;
                LinkMap linkMap = (LinkMap)object;
                if (!Intrinsics.areEqual(this.map, linkMap.map)) break block3;
            }
            return true;
        }
        return false;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001b)\u0011\u0001b\u0001\u0006\u0003!EQ!\u0001\u0005\b\u000b\u0005!)\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015Z\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!*\u000b\u0005\u0003!5Q\"\u0001\r\u00073\rAq!D\u0001\u0019\reI\u0001rB\u0007\u0006\u0013\r!\t!C\u0001\u0019\u0012aA\u0011#\u0001M\t#\u000e\t\u0001\"C\u0013\b\u0011'i\u0011\u0001\u0007\u0004\u001a\u0007!9Q\"\u0001\r\u0007K!!\u0011\u0001\u0003\u0006\u000e\u0003a1\u0011d\u0001E\u000b\u001b\u0005Ab!J\u0004\t\u00175\t\u0001DB\r\u0004\u0011\u001di\u0011\u0001\u0007\u0004*\u0017\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001C\u0003\u0011\r\u0001"}, strings={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "()V", "SPACES_REGEX", "Lkotlin/text/Regex;", "getSPACES_REGEX", "()Lkotlin/text/Regex;", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "clearBounding", "s", "boundQuotes", "", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "normalizeDestination", "normalizeLabel", "label", "normalizeTitle"}, moduleName="intellij-markdown")
    public static final class Builder {
        public static final Builder INSTANCE;

        @NotNull
        public final LinkMap buildLinkMap(@NotNull ASTNode root, @NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            HashMap map = new HashMap();
            root.accept(new RecursiveVisitor(text, map){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ HashMap $map;

                /*
                 * WARNING - void declaration
                 */
                public void visitNode(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.Companion.getLINK_DEFINITION())) {
                        T element2;
                        Builder builder;
                        block4: {
                            void $receiver;
                            Iterable iterable = node.getChildren();
                            builder = LinkMap.Builder;
                            for (T element2 : $receiver) {
                                ASTNode it = (ASTNode)element2;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_LABEL())) continue;
                                break block4;
                            }
                            throw (Throwable)new NoSuchElementException("No element matching predicate was found.");
                        }
                        T t = element2;
                        CharSequence linkLabel = org.intellij.markdown.parser.LinkMap$Builder.access$normalizeLabel(builder, ASTUtilKt.getTextInNode((ASTNode)t, this.$text));
                        if (!this.$map.containsKey(linkLabel)) {
                            this.$map.put(linkLabel, LinkInfo.Companion.create$intellij_markdown(node, this.$text));
                        }
                    } else {
                        super.visitNode(node);
                    }
                }
                {
                    this.$text = $captured_local_variable$0;
                    this.$map = $captured_local_variable$1;
                }
            });
            return new LinkMap(map, null);
        }

        private final CharSequence normalizeLabel(CharSequence label) {
            String string = this.getSPACES_REGEX().replace(label, " ");
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            return StringsKt.toLowerCase((String)string, (Locale)locale);
        }

        @NotNull
        public final CharSequence normalizeDestination(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            String dest = EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "<>"), true, true);
            StringBuilder sb = new StringBuilder();
            CharIterator charIterator = StringsKt.iterator((CharSequence)dest);
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                char code = c;
                if (code == ' ') {
                    sb.append("%20");
                    continue;
                }
                if (code < ' ' || code >= '\u0080' || StringsKt.contains$default((String)"\".<>\\^_`{|}~", (char)c, (boolean)false, (int)2)) {
                    sb.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
                    continue;
                }
                sb.append(c);
            }
            CharSequence charSequence = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"sb.toString()");
            return charSequence;
        }

        @NotNull
        public final CharSequence normalizeTitle(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            return EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "\"\"", "''", "()"), true, true);
        }

        private final CharSequence clearBounding(CharSequence s, String ... boundQuotes) {
            if (s.length() == 0) {
                return s;
            }
            for (int i = 0; i < boundQuotes.length; ++i) {
                String quotePair = boundQuotes[i];
                if (s.charAt(0) != quotePair.charAt(0) || s.charAt(s.length() - 1) != quotePair.charAt(1)) continue;
                return s.subSequence(1, s.length() - 1);
            }
            return s;
        }

        @NotNull
        public final Regex getSPACES_REGEX() {
            return SPACES_REGEX;
        }

        static {
            new Builder();
        }

        private Builder() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0007\u000b\u0005!a\u0001B\"\u0005\u0019\u0001\u0001\n\"G\u0001\u0019\u0002u\u0005\t\")\t\u0005\u0003%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011\u0002\u0002\u0005\u0004\u001b\ta\t\u0001'\u0002R\u0007\u0005A9!*\u0003\u0005\u0007\u001eAi!D\u0001\u0019\u0004\u0015&AaQ\u0004\t\u000f5\t\u0001TAS\u0006\t\r;\u0001rB\u0007\u0003\u0019\u0003A*!*\u000b\u0005\u0007\u000eA\u0001\"D\u0001\u0019\u0001e!A!\u0001\u0005\u0002\u001b\u0005A\u001a!\u0007\u0003\u0005\u0003!\u0011Q\"\u0001M\u00033\u0015!\u0011\u0001C\u0002\u000e\u00051\u0005\u0001TA\u0015\u000b\t\rC\u0001BA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!A\u0001#\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011A!\u0002E\u0006S-!1\t\u0003\u0005\u0004\u001b\ta\t\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\r!%\u0001"}, strings={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "Companion"}, moduleName="intellij-markdown")
    public static final class LinkInfo {
        @NotNull
        private final ASTNode node;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;
        public static final Companion Companion = Companion.INSTANCE;

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        private LinkInfo(ASTNode node, CharSequence destination, CharSequence title) {
            this.node = node;
            this.destination = destination;
            this.title = title;
        }

        public /* synthetic */ LinkInfo(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title, DefaultConstructorMarker $constructor_marker) {
            this(node, destination, title);
        }

        @NotNull
        public final ASTNode component1() {
            return this.node;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final LinkInfo copy(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return new LinkInfo(node, destination, title);
        }

        @NotNull
        public static /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n) {
            if ((n & 1) != 0) {
                aSTNode = linkInfo.node;
            }
            if ((n & 2) != 0) {
                charSequence = linkInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = linkInfo.title;
            }
            return linkInfo.copy(aSTNode, charSequence, charSequence2);
        }

        public String toString() {
            return "LinkInfo(node=" + this.node + ", destination=" + this.destination + ", title=" + this.title + ")";
        }

        public int hashCode() {
            ASTNode aSTNode = this.node;
            CharSequence charSequence = this.destination;
            CharSequence charSequence2 = this.title;
            return ((aSTNode != null ? aSTNode.hashCode() : 0) * 31 + (charSequence != null ? charSequence.hashCode() : 0)) * 31 + (charSequence2 != null ? charSequence2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkInfo)) break block3;
                    LinkInfo linkInfo = (LinkInfo)object;
                    if (!Intrinsics.areEqual((Object)this.node, (Object)linkInfo.node) || !Intrinsics.areEqual((Object)this.destination, (Object)linkInfo.destination) || !Intrinsics.areEqual((Object)this.title, (Object)linkInfo.title)) break block3;
                }
                return true;
            }
            return false;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000e\u0015\u0001Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K;!\u0001\u0001c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B)\u0004\u0003\u0011%\u0001"}, strings={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "create$intellij_markdown"}, moduleName="intellij-markdown")
        public static final class Companion {
            public static final Companion INSTANCE;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LinkInfo create$intellij_markdown(@NotNull ASTNode node, @NotNull CharSequence fileText) {
                CharSequence charSequence;
                Object object;
                Object v0;
                Object $receiver;
                CharSequence destination;
                block5: {
                    Object element2;
                    Builder builder;
                    block4: {
                        void $receiver2;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        Intrinsics.checkParameterIsNotNull((Object)fileText, (String)"fileText");
                        Iterable iterable = node.getChildren();
                        builder = Builder;
                        for (Object element2 : $receiver2) {
                            ASTNode it = (ASTNode)element2;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_DESTINATION())) continue;
                            break block4;
                        }
                        throw (Throwable)new NoSuchElementException("No element matching predicate was found.");
                    }
                    Object t = element2;
                    destination = builder.normalizeDestination(ASTUtilKt.getTextInNode((ASTNode)t, fileText));
                    Iterable iterable = node.getChildren();
                    element2 = $receiver.iterator();
                    while (element2.hasNext()) {
                        Object element3 = element2.next();
                        ASTNode it = (ASTNode)element3;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_TITLE())) continue;
                        v0 = element3;
                        break block5;
                    }
                    v0 = null;
                }
                if ((object = (ASTNode)v0) != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, fileText)) != null) {
                    $receiver = object;
                    CharSequence it = (CharSequence)$receiver;
                    charSequence = Builder.normalizeTitle(it);
                } else {
                    charSequence = null;
                }
                CharSequence title = charSequence;
                return new LinkInfo(node, destination, title, null);
            }

            static {
                new Companion();
            }

            private Companion() {
                INSTANCE = this;
            }
        }
    }
}

