/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.CharIterator;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u0003!5AaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!Q\u0005\u0004E\u0005\u001b\ta\t\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rA)!D\u0001\u0019\u0007\u0015b\u0001\"B\u0007\u0003\u0019\u0003A2!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002&\u0017!1Q\"\u0001M\u00073\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011)s\u0001C\u0004\u000e\u0003a5\u0011d\u0001E\b\u001b\u0005A\u0002\u0002"}, strings={"Lorg/intellij/markdown/parser/markerblocks/MarkdownParserUtil;", "", "()V", "calcNumberOfConsequentEols", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "findNonEmptyLineWithSameConstraints", "getFirstNonWhitespaceLinePos", "eolsToSkip", "hasCodeBlockIndent", "", "isEmptyOrSpaces", "s", ""}, moduleName="intellij-markdown")
public final class MarkdownParserUtil {
    public static final MarkdownParserUtil INSTANCE;
    public static final MarkdownParserUtil INSTANCE$;

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        LookaheadText.Position currentPos = pos;
        int result = 1;
        Function1 isClearLine2 = (Function1)new Function1<LookaheadText.Position, Boolean>(constraints){
            final /* synthetic */ MarkdownConstraints $constraints;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull LookaheadText.Position pos) {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                MarkdownConstraints currentConstraints = MarkdownConstraints.Companion.fillFromPrevious(pos.getCurrentLine(), 0, this.$constraints);
                int constraintsLength = currentConstraints.getCharsEaten(pos.getCurrentLine());
                if (!currentConstraints.upstreamWith(this.$constraints)) return false;
                if (constraintsLength >= pos.getCurrentLine().length()) return true;
                LookaheadText.Position position = pos.nextPosition(1 + constraintsLength);
                if (position == null) return true;
                Integer n = position.charsToNonWhitespace();
                if (n != null) return false;
                return true;
            }
            {
                this.$constraints = markdownConstraints;
                super(1);
            }
        };
        while (((Boolean)isClearLine2.invoke((Object)currentPos)).booleanValue()) {
            if (currentPos.nextLinePosition() == null) {
                break;
            }
            if (++result <= 4) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        void currentPos;
        void times;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = pos;
        int n = eolsToSkip - 1;
        boolean bl = false;
        void var6_6 = times - true;
        if (bl <= var6_6) {
            void index;
            do {
                void it = ++index;
                if (pos.nextLinePosition() == null) {
                    Object cfr_ignored_0 = currentPos.element;
                    return null;
                }
                currentPos.element = currentPos.element;
            } while (index != var6_6);
        }
        while (((LookaheadText.Position)currentPos.element).charsToNonWhitespace() == null) {
            if (((LookaheadText.Position)currentPos.element).nextLinePosition() == null) {
                Object cfr_ignored_1 = currentPos.element;
                return null;
            }
            currentPos.element = currentPos.element;
        }
        return (LookaheadText.Position)currentPos.element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        int constraintsLength = constraints.getCharsEaten(pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int n = constraintsLength;
        int n2 = pos.getOffsetInCurrentLine();
        if (n <= n2) {
            while (true) {
                void i;
                if (pos.getCurrentLine().charAt((int)i) == '\t') {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        CharIterator charIterator = StringsKt.iterator((CharSequence)s);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while ((nextLineConstraints = MarkdownConstraints.Companion.fromBase(currentPos, constraints)).upstreamWith(constraints) && nextLineConstraints.extendsPrev(constraints)) {
            CharSequence stringAfterConstraints = nextLineConstraints.eatItselfFromString(currentPos.getCurrentLine());
            if (!INSTANCE.isEmptyOrSpaces(stringAfterConstraints)) {
                return currentPos;
            }
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return null;
    }

    static {
        new MarkdownParserUtil();
    }

    private MarkdownParserUtil() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

