/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001#\u0004\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015\"Aa\u0003E\u0007\u001b\u0005Ar!\n\u0005\u0005\u0015!=Q\"\u0001\r\u00073\rA\u0001\"D\u0001\u0019\u0012\u0015bAA\u0003\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011)i\u0011\u0001g\u0001&\u0011\u0011\t\u0001RC\u0007\u00021\u001dI2\u0001C\u0006\u000e\u0003a]Q\u0005\u0002\u0003\u000b\u00111i\u0011\u0001'\u0007&\t\u0011Y\u0001\"D\u0007\u000217)\u0003\u0002B\u0006\t\u001d5\t\u0001dB\r\u0004\u0011!i\u0011\u0001'\u0005*\u000f\u0011\t\u0005\u0002#\u0003\u000e\u0003a)\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00075\t\u0001tA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005c\u00022B\u0007\u00021\u0019\t6!A\u0003\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "fenceStart", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Ljava/lang/String;)V", "endLineRegex", "Lkotlin/text/Regex;", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "endsThisFence", "line", "", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class CodeFenceMarkerBlock
extends MarkerBlockImpl {
    private final Regex endLineRegex;
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;
    private final String fenceStart;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        int nextLineOffset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffset() < this.realInterestingOffset) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.extendsPrev(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nextLineOffset = pos.getNextLineOrEofOffset();
        CharSequence currentLine = nextLineConstraints.eatItselfFromString(pos.getCurrentLine());
        if (this.endsThisFence(currentLine)) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset())), MarkdownTokenTypes.Companion.getCODE_FENCE_END())));
            this.scheduleProcessingResult(nextLineOffset, MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        } else {
            IntRange contentRange = new IntRange(Math.min(pos.getOffset() + 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine()), nextLineOffset), nextLineOffset);
            if (((Number)contentRange.getStart()).intValue() < ((Number)contentRange.getEnd()).intValue()) {
                this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)contentRange), MarkdownTokenTypes.Companion.getCODE_FENCE_CONTENT())));
            }
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean endsThisFence(CharSequence line) {
        return this.endLineRegex.matches(line);
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getCODE_FENCE();
    }

    public CodeFenceMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull String fenceStart) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)fenceStart, (String)"fenceStart");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.fenceStart = fenceStart;
        this.endLineRegex = new Regex("^ {0,3}" + this.fenceStart + "+ *" + "$");
        this.realInterestingOffset = -1;
    }
}

