/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0004\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015\"Aa\u0003E\u0005\u001b\u0005AR!\n\u0005\u0005\u0015!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000f\u0015bAA\u0003E\b\u001b\u0005A\u0002\"G\u0002\t\u000e5\t\u0001dB\r\u0004\u0011#i\u0011\u0001g\u0001&\t\u0011Q\u0001\"C\u0007\u00021')C\u0001B\u0006\t\u00155\t\u0001TC\u0013\t\t-A1\"D\u0001\u0019\u000be\u0019\u0001RB\u0007\u00021\u001dIs\u0001B!\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/ListMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "listType", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;C)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class ListMarkerBlock
extends MarkerBlockImpl {
    private final char listType;

    @Override
    public boolean allowsSubBlocks() {
        return true;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getChar() == '\n';
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Integer n = pos.getNextLineOffset();
        return n != null ? ((Number)n).intValue() : -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        int eolN = MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints());
        if (eolN >= 3) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position position = MarkdownParserUtil.INSTANCE.getFirstNonWhitespaceLinePos(pos, eolN);
        if (position == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonemptyPos = position;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
        if (!nextLineConstraints.extendsList(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getPASS();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.listType == '-' || this.listType == '*' || this.listType == '+' ? MarkdownElementTypes.Companion.getUNORDERED_LIST() : MarkdownElementTypes.Companion.getORDERED_LIST();
    }

    public ListMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker, char listType) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.listType = listType;
    }
}

